/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.debug;

import java.util.HashMap;
import java.util.Map;
import org.cqframework.cql.elm.execution.Element;
import org.opencds.cqf.cql.engine.debug.DebugAction;
import org.opencds.cqf.cql.engine.debug.DebugLocator;
import org.opencds.cqf.cql.engine.debug.DebugMapEntry;
import org.opencds.cqf.cql.engine.debug.Location;
import org.opencds.cqf.cql.engine.elm.execution.Executable;

public class DebugLibraryMapEntry {
    private String libraryName;
    private Map<String, DebugMapEntry> nodeEntries;
    private Map<String, DebugMapEntry> locationEntries;

    public String getLibraryName() {
        return this.libraryName;
    }

    public DebugLibraryMapEntry(String libraryName) {
        this.libraryName = libraryName;
        this.nodeEntries = new HashMap<String, DebugMapEntry>();
        this.locationEntries = new HashMap<String, DebugMapEntry>();
    }

    public DebugAction shouldDebug(Executable node) {
        Element element;
        if (node instanceof Element && (element = (Element)node) != null) {
            DebugMapEntry nodeEntry = this.nodeEntries.get(element.getLocalId());
            if (nodeEntry != null && nodeEntry.getAction() != DebugAction.NONE) {
                return nodeEntry.getAction();
            }
            for (DebugMapEntry entry : this.locationEntries.values()) {
                if (element.getLocator() == null) continue;
                Location nodeLocation = Location.fromLocator(element.getLocator());
                if (!entry.getLocator().getLocation().includes(nodeLocation) || entry.getAction() == DebugAction.NONE) continue;
                return entry.getAction();
            }
        }
        return DebugAction.NONE;
    }

    public void addEntry(DebugLocator debugLocator, DebugAction action) {
        this.addEntry(new DebugMapEntry(debugLocator, action));
    }

    public void addEntry(DebugMapEntry entry) {
        switch (entry.getLocator().getLocatorType()) {
            case NODE_ID: {
                this.nodeEntries.put(entry.getLocator().getLocator(), entry);
                break;
            }
            case LOCATION: {
                this.locationEntries.put(entry.getLocator().getLocator(), entry);
                break;
            }
            default: {
                throw new IllegalArgumentException("Library debug map entry can only contain node id or location debug entries");
            }
        }
    }

    public void removeEntry(DebugLocator debugLocator) {
        switch (debugLocator.getLocatorType()) {
            case NODE_ID: {
                this.nodeEntries.remove(debugLocator.getLocator());
                break;
            }
            case LOCATION: {
                this.locationEntries.remove(debugLocator.getLocator());
                break;
            }
            default: {
                throw new IllegalArgumentException("Library debug map entry only contains node id or location debug entries");
            }
        }
    }
}

