/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.data;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.opencds.cqf.cql.engine.data.ExternalFunctionProvider;

public class SystemExternalFunctionProvider
implements ExternalFunctionProvider {
    private List<Method> staticFunctions;

    public SystemExternalFunctionProvider(List<Method> staticFunctions) {
        this.staticFunctions = staticFunctions;
    }

    @Override
    public Object evaluate(String staticFunctionName, List<Object> arguments) {
        for (Method staticFunction : this.staticFunctions) {
            if (!staticFunction.getName().equals(staticFunctionName)) continue;
            try {
                return staticFunction.invoke(staticFunction.getDeclaringClass(), arguments.toArray());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("Unable to invoke function [" + staticFunctionName + "]: " + e.getMessage());
            }
            catch (Exception e) {
                throw new RuntimeException("Error when executing function [" + staticFunctionName + "]: \n" + e.toString());
            }
        }
        throw new IllegalArgumentException("Unable to find function [" + staticFunctionName + "].");
    }
}

