/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.retrieve;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.util.BundleUtil;
import java.util.Iterator;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.cql.engine.fhir.exception.UnknownElement;

public class FhirBundleCursor
implements Iterable<Object> {
    private IGenericClient fhirClient;
    private IBaseBundle results;
    private String dataType;

    public FhirBundleCursor(IGenericClient fhirClient, IBaseBundle results) {
        this(fhirClient, results, null);
    }

    public FhirBundleCursor(IGenericClient fhirClient, IBaseBundle results, String dataType) {
        this.fhirClient = fhirClient;
        this.results = results;
        this.dataType = dataType;
    }

    @Override
    public Iterator<Object> iterator() {
        return new FhirBundleIterator(this.fhirClient, this.results, this.dataType);
    }

    private class FhirBundleIterator
    implements Iterator<Object> {
        private IGenericClient fhirClient;
        private IBaseBundle results;
        private int current;
        private String dataType;
        private Class<? extends IBaseResource> dataTypeClass;
        private List<? extends IBaseResource> currentEntry;

        public FhirBundleIterator(IGenericClient fhirClient, IBaseBundle results, String dataType) {
            this.fhirClient = fhirClient;
            this.results = results;
            this.current = -1;
            this.dataType = dataType;
            if (dataType != null) {
                this.dataTypeClass = this.fhirClient.getFhirContext().getResourceDefinition(this.dataType).getImplementingClass();
            }
            this.currentEntry = this.getEntry();
        }

        @Override
        public boolean hasNext() {
            return this.current < this.currentEntry.size() - 1 || this.getLink() != null;
        }

        private List<? extends IBaseResource> getEntry() {
            if (this.dataTypeClass != null) {
                return BundleUtil.toListOfResourcesOfType((FhirContext)this.fhirClient.getFhirContext(), (IBaseBundle)this.results, this.dataTypeClass);
            }
            return BundleUtil.toListOfResources((FhirContext)this.fhirClient.getFhirContext(), (IBaseBundle)this.results);
        }

        private String getLink() {
            return BundleUtil.getLinkUrlOfType((FhirContext)this.fhirClient.getFhirContext(), (IBaseBundle)this.results, (String)"next");
        }

        @Override
        public Object next() {
            ++this.current;
            if (this.current < this.currentEntry.size()) {
                return this.currentEntry.get(this.current);
            }
            this.results = (IBaseBundle)this.fhirClient.loadPage().next(this.results).execute();
            this.currentEntry = this.getEntry();
            this.current = 0;
            if (this.current < this.currentEntry.size()) {
                return this.currentEntry.get(this.current);
            }
            throw new UnknownElement("The iteration has no more elements.");
        }
    }
}

