/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workingfilerepository.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.opencastproject.storage.StorageUsage;
import org.opencastproject.util.NotFoundException;

public interface WorkingFileRepository
extends StorageUsage {
    public static final String CHAR_ENCODING = "UTF-8";
    public static final String URI_PREFIX = "/files/";
    public static final String COLLECTION_PATH_PREFIX = "/collection/";
    public static final String MEDIAPACKAGE_PATH_PREFIX = "/mediapackage/";
    public static final String SERVICE_TYPE = "org.opencastproject.files";

    public URI getBaseUri();

    public URI put(String var1, String var2, String var3, InputStream var4) throws IOException, IllegalArgumentException;

    public InputStream get(String var1, String var2) throws IOException, NotFoundException;

    public URI getCollectionURI(String var1, String var2) throws IllegalArgumentException;

    public URI getURI(String var1, String var2) throws IllegalArgumentException;

    public URI getURI(String var1, String var2, String var3) throws IllegalArgumentException;

    public String toSafeName(String var1);

    public boolean delete(String var1, String var2) throws IOException;

    public URI putInCollection(String var1, String var2, InputStream var3) throws IOException;

    public URI[] getCollectionContents(String var1) throws NotFoundException;

    public boolean deleteFromCollection(String var1, String var2) throws IOException;

    public boolean deleteFromCollection(String var1, String var2, boolean var3) throws IOException;

    public URI moveTo(String var1, String var2, String var3, String var4, String var5) throws NotFoundException, IOException;

    public String getDiskSpace();

    public boolean cleanupOldFilesFromCollection(String var1, long var2) throws IOException;

    public boolean cleanupOldFilesFromMediaPackage(long var1) throws IOException;
}

