/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.waveform;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.waveform.api.WaveformService;
import org.opencastproject.waveform.api.WaveformServiceException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, name="org.opencastproject.workflow.handler.videoeditor.WaveformWorkflowOperationHandler", service={WorkflowOperationHandler.class}, property={"service.description=Waveform Workflow Operation Handler", "workflow.operation=waveform"})
public class WaveformWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(WaveformWorkflowOperationHandler.class);
    private static final String SOURCE_FLAVOR_PROPERTY = "source-flavor";
    private static final String SOURCE_TAGS_PROPERTY = "source-tags";
    private static final int DEFAULT_PIXELS_PER_MINUTE = 200;
    private static final int DEFAULT_MIN_WIDTH = 5000;
    private static final int DEFAULT_MAX_WIDTH = 20000;
    private static final int DEFAULT_HEIGHT = 500;
    private static final String PIXELS_PER_MINUTE_PROPERTY = "pixels-per-minute";
    private static final String MIN_WIDTH_PROPERTY = "min-width";
    private static final String MAX_WIDTH_PROPERTY = "max-width";
    private static final String HEIGHT_PROPERTY = "height";
    private static final String COLOR_PROPERTY = "color";
    private WaveformService waveformService = null;
    private Workspace workspace = null;

    public void activate(ComponentContext cc) {
        super.activate(cc);
        logger.info("Registering waveform workflow operation handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        logger.info("Start waveform workflow operation for mediapackage {}", (Object)mediaPackage);
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.one);
        List sourceFlavorList = tagsAndFlavors.getSrcFlavors();
        List sourceTagList = tagsAndFlavors.getSrcTags();
        if (sourceFlavorList.isEmpty() && sourceTagList.isEmpty()) {
            throw new WorkflowOperationException(String.format("Required property %s or %s not set", SOURCE_FLAVOR_PROPERTY, SOURCE_TAGS_PROPERTY));
        }
        MediaPackageElementFlavor targetFlavor = tagsAndFlavors.getSingleTargetFlavor();
        List targetTagList = tagsAndFlavors.getTargetTags();
        int pixelsPerMinute = NumberUtils.toInt((String)StringUtils.trimToNull((String)workflowInstance.getCurrentOperation().getConfiguration(PIXELS_PER_MINUTE_PROPERTY)), (int)200);
        int minWidth = NumberUtils.toInt((String)StringUtils.trimToNull((String)workflowInstance.getCurrentOperation().getConfiguration(MIN_WIDTH_PROPERTY)), (int)5000);
        int maxWidth = NumberUtils.toInt((String)StringUtils.trimToNull((String)workflowInstance.getCurrentOperation().getConfiguration(MAX_WIDTH_PROPERTY)), (int)20000);
        int height = NumberUtils.toInt((String)StringUtils.trimToNull((String)workflowInstance.getCurrentOperation().getConfiguration(HEIGHT_PROPERTY)), (int)500);
        String color = StringUtils.trimToNull((String)workflowInstance.getCurrentOperation().getConfiguration(COLOR_PROPERTY));
        try {
            TrackSelector trackSelector = new TrackSelector();
            for (MediaPackageElementFlavor flavor : sourceFlavorList) {
                trackSelector.addFlavor(flavor);
            }
            for (String tag : sourceTagList) {
                trackSelector.addTag(tag);
            }
            Collection sourceTracks = trackSelector.select(mediaPackage, false);
            if (sourceTracks.isEmpty()) {
                String tag;
                logger.info("No tracks found in mediapackage {} with specified {} = {}", new Object[]{mediaPackage, SOURCE_FLAVOR_PROPERTY, sourceFlavorList});
                tag = this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
                return tag;
            }
            ArrayList<Job> waveformJobs = new ArrayList<Job>(sourceTracks.size());
            for (Track sourceTrack : sourceTracks) {
                if (!sourceTrack.hasAudio()) {
                    logger.info("Skipping waveform extraction of track {} since it has no audio", (Object)sourceTrack.getIdentifier());
                    continue;
                }
                try {
                    logger.info("Creating waveform extraction job for track '{}' in mediapackage '{}'", (Object)sourceTrack.getIdentifier(), (Object)mediaPackage);
                    Job waveformJob = this.waveformService.createWaveformImage(sourceTrack, pixelsPerMinute, minWidth, maxWidth, height, color);
                    waveformJobs.add(waveformJob);
                }
                catch (MediaPackageException | WaveformServiceException e) {
                    logger.error("Creating waveform extraction job for track '{}' in media package '{}' failed", new Object[]{sourceTrack.getIdentifier(), mediaPackage, e});
                }
            }
            logger.debug("Waiting for waveform jobs for media package {}", (Object)mediaPackage);
            if (!this.waitForStatus(waveformJobs.toArray(new Job[waveformJobs.size()])).isSuccess()) {
                throw new WorkflowOperationException(String.format("Waveform extraction jobs for media package '%s' have not completed successfully", mediaPackage.getIdentifier()));
            }
            for (Job job : waveformJobs) {
                String jobPayload = job.getPayload();
                if (StringUtils.isEmpty((CharSequence)jobPayload)) continue;
                MediaPackageElement waveformMpe = null;
                try {
                    waveformMpe = MediaPackageElementParser.getFromXml((String)jobPayload);
                    URI newURI = this.workspace.moveTo(waveformMpe.getURI(), mediaPackage.getIdentifier().toString(), waveformMpe.getIdentifier(), "waveform.png");
                    waveformMpe.setURI(newURI);
                }
                catch (MediaPackageException ex) {
                    throw new WorkflowOperationException("Can't parse waveform attachment from job " + job.getId());
                }
                catch (NotFoundException ex) {
                    throw new WorkflowOperationException("Waveform image file '" + waveformMpe.getURI() + "' not found", (Throwable)ex);
                }
                catch (IOException ex) {
                    throw new WorkflowOperationException("Can't get workflow image file '" + waveformMpe.getURI() + "' from workspace");
                }
                if ("*".equals(targetFlavor.getType())) {
                    targetFlavor = new MediaPackageElementFlavor(waveformMpe.getFlavor().getType(), targetFlavor.getSubtype());
                }
                if ("*".equals(targetFlavor.getSubtype())) {
                    targetFlavor = new MediaPackageElementFlavor(targetFlavor.getType(), waveformMpe.getFlavor().getSubtype());
                }
                waveformMpe.setFlavor(targetFlavor);
                for (String tag : targetTagList) {
                    waveformMpe.addTag(tag);
                }
                mediaPackage.add(waveformMpe);
            }
            logger.info("Waveform workflow operation for mediapackage {} completed", (Object)mediaPackage);
            WorkflowOperationResult workflowOperationResult = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
            return workflowOperationResult;
        }
        finally {
            try {
                this.workspace.cleanup(mediaPackage.getIdentifier(), true);
            }
            catch (IOException e) {
                throw new WorkflowOperationException((Throwable)e);
            }
        }
    }

    @Reference
    public void setWaveformService(WaveformService waveformService) {
        this.waveformService = waveformService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

