/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.videosegmenter.ffmpeg;

import java.util.LinkedList;
import org.opencastproject.metadata.mpeg7.Mpeg7Catalog;
import org.opencastproject.metadata.mpeg7.Segment;

public class OptimizationStep
implements Comparable<OptimizationStep> {
    private float changesThreshold;
    private float error;
    private float errorAbs;
    private int segmentNum;
    private int prefNum;
    private Mpeg7Catalog mpeg7;
    private LinkedList<Segment> segments;

    public OptimizationStep(float changesThreshold, int segNum, int prefNum, Mpeg7Catalog mpeg7, LinkedList<Segment> segments) {
        this.changesThreshold = changesThreshold;
        this.segmentNum = segNum;
        this.prefNum = prefNum;
        this.mpeg7 = mpeg7;
        this.segments = segments;
        this.calcErrors();
    }

    public OptimizationStep() {
        this.changesThreshold = 0.0f;
        this.segmentNum = 1;
        this.prefNum = 1;
        this.mpeg7 = null;
        this.segments = null;
        this.calcErrors();
    }

    private void calcErrors() {
        this.error = (float)(this.segmentNum - this.prefNum) / (float)this.prefNum;
        this.errorAbs = Math.abs(this.error);
    }

    public float getChangesThreshold() {
        return this.changesThreshold;
    }

    public float getError() {
        return this.error;
    }

    public float getErrorAbs() {
        return this.errorAbs;
    }

    public int getSegmentNum() {
        return this.segmentNum;
    }

    public void setSegmentNumAndRecalcErrors(int segNum) {
        this.segmentNum = segNum;
        this.calcErrors();
    }

    public Mpeg7Catalog getMpeg7() {
        return this.mpeg7;
    }

    public LinkedList<Segment> getSegments() {
        return this.segments;
    }

    public static float calculateErrorAbs(int segmentNum, int prefNum) {
        return Math.abs((float)(segmentNum - prefNum) / (float)prefNum);
    }

    @Override
    public int compareTo(OptimizationStep o) {
        if (this.error == o.getError()) {
            return 0;
        }
        if (this.error >= 0.0f) {
            if (o.getError() < 0.0f) {
                return -1;
            }
            if (this.error < o.getError()) {
                return -1;
            }
            return 1;
        }
        if (o.getError() >= 0.0f) {
            return 1;
        }
        if (this.error < o.getError()) {
            return -1;
        }
        return 1;
    }
}

