/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.videogrid.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.ConfigurationException;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.videogrid.api.VideoGridService;
import org.opencastproject.videogrid.api.VideoGridServiceException;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={VideoGridService.class, ManagedService.class}, property={"service.description=Video Grid Service", "service.pid=org.opencastproject.videogrid.impl.VideoGridServiceImpl"})
public class VideoGridServiceImpl
extends AbstractJobProducer
implements VideoGridService,
ManagedService {
    private static final String JOB_LOAD_CONFIG = "job.load.videogrid";
    private static final float JOB_LOAD_DEFAULT = 1.5f;
    private float jobLoad = 1.5f;
    private static final Logger logger = LoggerFactory.getLogger(VideoGridServiceImpl.class);
    private static final String OPERATION = "createPartialTrack";
    private Workspace workspace;
    private ServiceRegistry serviceRegistry;
    private SecurityService securityService;
    private UserDirectoryService userDirectoryService;
    private OrganizationDirectoryService organizationDirectoryService;
    private static final Gson gson = new Gson();
    private static final Type stringListOfListType = new TypeToken<List<List<String>>>(){}.getType();

    public VideoGridServiceImpl() {
        super("org.opencastproject.videogrid");
    }

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
        logger.debug("Activated videogrid service");
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        if (properties == null) {
            return;
        }
        logger.debug("Start updating videogrid service");
        this.jobLoad = LoadUtil.getConfiguredLoadValue((Dictionary)properties, (String)JOB_LOAD_CONFIG, (Float)Float.valueOf(1.5f), (ServiceRegistry)this.serviceRegistry);
        logger.debug("Set videogrid job load to {}", (Object)Float.valueOf(this.jobLoad));
        logger.debug("Finished updating videogrid service");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String process(Job job) throws Exception {
        URI videoFileUri;
        logger.debug("Started processing job {}", (Object)job.getId());
        if (!OPERATION.equals(job.getOperation())) {
            throw new ServiceRegistryException(String.format("This service can't handle operations of type '%s'", job.getOperation()));
        }
        List arguments = job.getArguments();
        List command = (List)gson.fromJson((String)arguments.get(0), new TypeToken<List<String>>(){}.getType());
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (int i = 1; i < arguments.size(); ++i) {
            tracks.add(i - 1, (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(i))));
        }
        String outputDirPath = String.format("%s/videogrid/%d/", this.workspace.rootDirectory(), job.getId());
        FileUtils.forceMkdir((File)new File(outputDirPath));
        for (int i = 0; i < command.size(); ++i) {
            String[] trackIds = StringUtils.substringsBetween((String)((String)command.get(i)), (String)"#{", (String)"}");
            if (trackIds == null) continue;
            for (String trackId : trackIds) {
                Track replaceTrack = tracks.stream().filter(track -> track.getIdentifier().equals(trackId)).findAny().orElse(null);
                if (replaceTrack == null) {
                    throw new VideoGridServiceException(String.format("Track with id %s could not be found!", trackId));
                }
                command.set(i, ((String)command.get(i)).replaceAll("#\\{" + trackId + "\\}", this.getTrackPath(replaceTrack)));
            }
        }
        String outputFile = outputDirPath + "videogrid_for_Job_" + job.getId() + ".mp4";
        command.add(outputFile);
        logger.info("Running command: {}", (Object)command);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        Process ffmpegProcess = null;
        int exitCode = 1;
        BufferedReader errStream = null;
        try {
            ffmpegProcess = pb.start();
            errStream = new BufferedReader(new InputStreamReader(ffmpegProcess.getInputStream()));
            String line = errStream.readLine();
            while (line != null) {
                logger.info(line);
                line = errStream.readLine();
            }
            exitCode = ffmpegProcess.waitFor();
        }
        catch (IOException ex) {
            try {
                throw new VideoGridServiceException("Start ffmpeg process failed", (Throwable)ex);
                catch (InterruptedException ex2) {
                    throw new VideoGridServiceException("Waiting for encoder process exited was interrupted unexpectedly", (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                IoSupport.closeQuietly((Process)ffmpegProcess);
                IoSupport.closeQuietly(errStream);
                if (exitCode == 0) throw throwable;
                try {
                    logger.warn("FFMPEG process exited with errorcode: " + exitCode);
                    FileUtils.forceDelete((File)new File(outputDirPath));
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        IoSupport.closeQuietly((Process)ffmpegProcess);
        IoSupport.closeQuietly((Closeable)errStream);
        if (exitCode != 0) {
            try {
                logger.warn("FFMPEG process exited with errorcode: " + exitCode);
                FileUtils.forceDelete((File)new File(outputDirPath));
            }
            catch (IOException line) {}
        }
        if (exitCode != 0) {
            throw new Exception(String.format("The encoder process exited abnormally with exit code %s using command\n%s", exitCode, String.join((CharSequence)" ", command)));
        }
        FileInputStream outputFileInputStream = null;
        try {
            outputFileInputStream = new FileInputStream(outputFile);
            videoFileUri = this.workspace.putInCollection("videogrid", FilenameUtils.getName((String)outputFile), (InputStream)outputFileInputStream);
            logger.info("Copied the created video to the workspace {}", (Object)videoFileUri);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new VideoGridServiceException(String.format("Video file '%s' not found", outputFile), (Throwable)ex);
                catch (IOException ex3) {
                    throw new VideoGridServiceException(String.format("Can't write video file '%s' to workspace", outputFile), (Throwable)ex3);
                }
                catch (IllegalArgumentException ex4) {
                    throw new VideoGridServiceException((Throwable)ex4);
                }
            }
            catch (Throwable throwable) {
                IoSupport.closeQuietly(outputFileInputStream);
                throw throwable;
            }
        }
        IoSupport.closeQuietly((Closeable)outputFileInputStream);
        FileUtils.deleteQuietly((File)new File(this.workspace.rootDirectory(), String.format("videogrid/%d", job.getId())));
        return gson.toJson((Object)videoFileUri);
    }

    public Job createPartialTrack(List<String> command, Track ... tracks) throws VideoGridServiceException, MediaPackageException {
        ArrayList<String> jobArguments = new ArrayList<String>(Arrays.asList(gson.toJson(command)));
        for (int i = 0; i < tracks.length; ++i) {
            jobArguments.add(i + 1, MediaPackageElementParser.getAsXml((MediaPackageElement)tracks[i]));
        }
        try {
            logger.debug("Create videogrid service job");
            return this.serviceRegistry.createJob("org.opencastproject.videogrid", OPERATION, jobArguments, Float.valueOf(this.jobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new VideoGridServiceException((Throwable)e);
        }
    }

    private String getTrackPath(Track track) throws VideoGridServiceException {
        File mediaFile;
        try {
            mediaFile = this.workspace.get(track.getURI());
        }
        catch (NotFoundException e) {
            throw new VideoGridServiceException("Error finding the media file in the workspace", (Throwable)e);
        }
        catch (IOException e) {
            throw new VideoGridServiceException("Error reading the media file in the workspace", (Throwable)e);
        }
        return mediaFile.getAbsolutePath();
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry jobManager) {
        this.serviceRegistry = jobManager;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }
}

