/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.naming.Name;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;

public class OpencastUserDetails
implements UserDetails {
    private String dn;
    private String password;
    private String username;
    private String name;
    private String mail;
    private Collection<GrantedAuthority> authorities = AuthorityUtils.NO_AUTHORITIES;
    private boolean accountNonExpired = true;
    private boolean accountNonLocked = true;
    private boolean credentialsNonExpired = true;
    private boolean enabled = true;

    protected OpencastUserDetails() {
    }

    public boolean equals(Object obj) {
        if (obj instanceof OpencastUserDetails) {
            return this.dn.equals(((OpencastUserDetails)obj).dn);
        }
        return false;
    }

    public int hashCode() {
        return this.dn.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(": ");
        sb.append("Dn: ").append(this.dn).append("; ");
        sb.append("Username: ").append(this.username).append("; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Name: ").append(this.name);
        sb.append("Mail: ").append(this.mail);
        sb.append("Enabled: ").append(this.enabled).append("; ");
        sb.append("AccountNonExpired: ").append(this.accountNonExpired).append("; ");
        sb.append("CredentialsNonExpired: ").append(this.credentialsNonExpired).append("; ");
        sb.append("AccountNonLocked: ").append(this.accountNonLocked).append("; ");
        if (this.getAuthorities() != null) {
            sb.append("Granted Authorities: ");
            boolean first = true;
            for (GrantedAuthority grantedAuthority : this.getAuthorities()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(grantedAuthority.toString());
            }
        } else {
            sb.append("Not granted any authorities");
        }
        return sb.toString();
    }

    public String getDn() {
        return this.dn;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getMail() {
        return this.mail;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static class Essence {
        protected OpencastUserDetails instance = this.createTarget();
        private List<GrantedAuthority> mutableAuthorities = new ArrayList<GrantedAuthority>();

        protected OpencastUserDetails createTarget() {
            return new OpencastUserDetails();
        }

        public void addAuthority(GrantedAuthority a) {
            if (!this.hasAuthority(a)) {
                this.mutableAuthorities.add(a);
            }
        }

        private boolean hasAuthority(GrantedAuthority a) {
            for (GrantedAuthority authority : this.mutableAuthorities) {
                if (!authority.equals(a)) continue;
                return true;
            }
            return false;
        }

        public OpencastUserDetails createUserDetails() {
            Objects.requireNonNull(this.instance, "Essence can only be used to create a single instance");
            Objects.requireNonNull(this.instance, "Essence can only be used to create a single instance");
            Objects.requireNonNull(this.instance.username, "username must not be null");
            Objects.requireNonNull(this.instance.getDn(), "Distinguished name must not be null");
            this.instance.authorities = Collections.unmodifiableList(this.mutableAuthorities);
            OpencastUserDetails newInstance = this.instance;
            this.instance = null;
            return newInstance;
        }

        public Collection<GrantedAuthority> getGrantedAuthorities() {
            return this.mutableAuthorities;
        }

        public void setAccountNonExpired(boolean accountNonExpired) {
            this.instance.accountNonExpired = accountNonExpired;
        }

        public void setAccountNonLocked(boolean accountNonLocked) {
            this.instance.accountNonLocked = accountNonLocked;
        }

        public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
            this.mutableAuthorities = new ArrayList<GrantedAuthority>();
            this.mutableAuthorities.addAll(authorities);
        }

        public void setCredentialsNonExpired(boolean credentialsNonExpired) {
            this.instance.credentialsNonExpired = credentialsNonExpired;
        }

        public void setDn(String dn) {
            this.instance.dn = dn;
        }

        public void setDn(Name dn) {
            this.instance.dn = dn.toString();
        }

        public void setEnabled(boolean enabled) {
            this.instance.enabled = enabled;
        }

        public void setPassword(String password) {
            this.instance.password = password;
        }

        public void setUsername(String username) {
            this.instance.username = username;
        }

        public void setName(String name) {
            this.instance.name = name;
        }

        public void setMail(String mail) {
            this.instance.mail = mail;
        }
    }
}

