/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.transcription.microsoftazure;

import com.microsoft.cognitiveservices.speech.AutoDetectSourceLanguageConfig;
import com.microsoft.cognitiveservices.speech.AutoDetectSourceLanguageResult;
import com.microsoft.cognitiveservices.speech.CancellationReason;
import com.microsoft.cognitiveservices.speech.PhraseListGrammar;
import com.microsoft.cognitiveservices.speech.ProfanityOption;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.ResultReason;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionResult;
import com.microsoft.cognitiveservices.speech.SpeechRecognizer;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioInputStream;
import com.microsoft.cognitiveservices.speech.audio.AudioStreamContainerFormat;
import com.microsoft.cognitiveservices.speech.audio.AudioStreamFormat;
import com.microsoft.cognitiveservices.speech.audio.PullAudioInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.fn.Enrichments;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.assetmanager.util.Workflows;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.kernel.mail.SmtpService;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.security.api.DefaultOrganization;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.transcription.api.TranscriptionService;
import org.opencastproject.transcription.api.TranscriptionServiceException;
import org.opencastproject.transcription.microsoftazure.BinaryFileReader;
import org.opencastproject.transcription.persistence.TranscriptionDatabase;
import org.opencastproject.transcription.persistence.TranscriptionDatabaseException;
import org.opencastproject.transcription.persistence.TranscriptionJobControl;
import org.opencastproject.transcription.persistence.TranscriptionProviderControl;
import org.opencastproject.util.ConfigurationException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.data.Option;
import org.opencastproject.workflow.api.ConfiguredWorkflow;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowService;
import org.opencastproject.workingfilerepository.api.WorkingFileRepository;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={TranscriptionService.class, MicrosoftAzureTranscriptionService.class}, property={"service.description=Microsoft Azure Transcription Service", "provider=microsoft.azure"})
public class MicrosoftAzureTranscriptionService
extends AbstractJobProducer
implements TranscriptionService {
    private static final Logger logger = LoggerFactory.getLogger(MicrosoftAzureTranscriptionService.class);
    private static final String JOB_TYPE = "org.opencastproject.transcription.microsoftazure";
    static final String TRANSCRIPT_COLLECTION = "transcripts";
    static final String TRANSCRIPTION_ERROR = "Transcription ERROR";
    static final String TRANSCRIPTION_JOB_ID_KEY = "transcriptionJobId";
    public static final String DEFAULT_WF_DEF = "microsoft-azure-attach-transcripts";
    private static final long DEFAULT_COMPLETION_BUFFER = 300L;
    private static final long DEFAULT_DISPATCH_INTERVAL = 60L;
    private static final long DEFAULT_MAX_PROCESSING_TIME = 18000L;
    private static final int DEFAULT_CLEANUP_RESULTS_DAYS = 7;
    private static final String DEFAULT_LANGUAGE = "en-US";
    private static final String PROVIDER = "Microsoft Azure";
    private static final AudioStreamContainerFormat DEFAULT_ENCODING = AudioStreamContainerFormat.ANY;
    private static final ProfanityOption DEFAULT_PROFANITY_OPTION = ProfanityOption.Raw;
    private static final boolean DEFAULT_IS_AUTO_DETECT_LANGUAGE = false;
    private String clusterName = "";
    private static final String DETECTED_LANGUAGE = "autoDetectedLanguage";
    private ServiceRegistry serviceRegistry;
    private SecurityService securityService;
    private UserDirectoryService userDirectoryService;
    private OrganizationDirectoryService organizationDirectoryService;
    private Workspace workspace;
    private TranscriptionDatabase database;
    private AssetManager assetManager;
    private WorkflowService workflowService;
    private WorkingFileRepository wfr;
    private SmtpService smtpService;
    private Workflows wfUtil;
    public static final String ENABLED_CONFIG = "enabled";
    public static final String LANGUAGE = "language";
    public static final String PROFANITY_OPTION = "profanity.option";
    public static final String USE_SUBRIP_FORMAT = "use.subrip.format";
    public static final String PHRASES_LIST = "phrases.list";
    public static final String SUBSCRIPTION_KEY = "subscription.key";
    public static final String REGION = "region";
    public static final String WORKFLOW_CONFIG = "workflow";
    public static final String DISPATCH_WORKFLOW_INTERVAL_CONFIG = "workflow.dispatch.interval";
    public static final String COMPLETION_CHECK_BUFFER_CONFIG = "completion.check.buffer";
    public static final String MAX_PROCESSING_TIME_CONFIG = "max.processing.time";
    public static final String NOTIFICATION_EMAIL_CONFIG = "notification.email";
    public static final String CLEANUP_RESULTS_DAYS_CONFIG = "cleanup.results.days";
    public static final String ENCODING_EXTENSION = "encoding.extension";
    public static final String IS_AUTO_DETECT_LANGUAGE = "auto.detect.language";
    public static final String AUTO_DETECT_LANGUAGES = "auto.detect.languages";
    public static final String SPLIT_TEXT = "split.text";
    public static final String SPLIT_TEXT_LINE_SIZE = "split.text.line.size";
    private boolean enabled = false;
    private String subscriptionKey;
    private String region;
    private String defaultLanguage = "en-US";
    private String workflowDefinitionId = "microsoft-azure-attach-transcripts";
    private long workflowDispatchInterval = 60L;
    private long completionCheckBuffer = 300L;
    private long maxProcessingSeconds = 18000L;
    private String toEmailAddress;
    private int cleanupResultDays = 7;
    private String systemAccount;
    private ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2);
    private AudioStreamContainerFormat compressedAudioFormat = DEFAULT_ENCODING;
    private ProfanityOption profanityOption = DEFAULT_PROFANITY_OPTION;
    private List<String> phraseList = new ArrayList<String>();
    private boolean useSubRipTextCaptionFormat = false;
    private String fileFormat = "vtt";
    private boolean defaultIsAutoDetectLanguage = false;
    private List<String> defaultAutoDetectLanguages = new ArrayList<String>();
    private boolean splitText = false;
    private int splitTextLineSize = 100;

    public MicrosoftAzureTranscriptionService() {
        super(JOB_TYPE);
    }

    @Activate
    public void activate(ComponentContext cc) {
        Option wfOpt;
        Option splitTextLineSizeOpt;
        Option phrasesOpt;
        this.enabled = (Boolean)OsgiUtil.getOptCfgAsBoolean((Dictionary)cc.getProperties(), (String)ENABLED_CONFIG).get();
        if (!this.enabled) {
            logger.info("Service disabled. If you want to enable it, please update the service configuration.");
            return;
        }
        this.subscriptionKey = OsgiUtil.getComponentContextProperty((ComponentContext)cc, (String)SUBSCRIPTION_KEY);
        this.region = OsgiUtil.getComponentContextProperty((ComponentContext)cc, (String)REGION);
        if (this.subscriptionKey == null) {
            logger.error("SubscriptionKey not set, disabling service.");
            return;
        }
        if (this.region == null) {
            logger.error("Region not set, disabling service.");
            return;
        }
        Option profanityOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)PROFANITY_OPTION);
        if (profanityOpt.isSome()) {
            try {
                this.profanityOption = ProfanityOption.valueOf((String)profanityOpt.get());
                logger.info("Profanity filter is set to {}", (Object)this.profanityOption);
            }
            catch (IllegalArgumentException e) {
                logger.error("Profanity filter set to illegal value, disabling service.");
                return;
            }
        } else {
            logger.info("Default profanity filter will be used: {}", (Object)this.profanityOption);
        }
        Option useSubRipOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)USE_SUBRIP_FORMAT);
        if (useSubRipOpt.isSome()) {
            this.useSubRipTextCaptionFormat = Boolean.valueOf((String)useSubRipOpt.get());
            logger.info("Subrip caption format in use: {}", (Object)this.useSubRipTextCaptionFormat);
        } else {
            logger.info("Default '{}' format will be used", (Object)this.useSubRipTextCaptionFormat);
        }
        if (this.useSubRipTextCaptionFormat) {
            this.fileFormat = "srt";
        }
        if ((phrasesOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)PHRASES_LIST)).isSome()) {
            this.phraseList = new ArrayList<String>(Arrays.asList(((String)phrasesOpt.get()).split(",")));
            logger.info("Phrases added to recognition: {}", this.phraseList);
        } else {
            logger.info("No additional phrases defined");
        }
        Option languageOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)LANGUAGE);
        if (languageOpt.isSome()) {
            this.defaultLanguage = (String)languageOpt.get();
            logger.info("Language used is {}", (Object)this.defaultLanguage);
        } else {
            logger.info("Default '{}' language will be used during recognition.", (Object)this.defaultLanguage);
        }
        Option encodingOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)ENCODING_EXTENSION);
        if (encodingOpt.isSome()) {
            this.compressedAudioFormat = AudioStreamContainerFormat.valueOf((String)encodingOpt.get());
            logger.info("Audio encoding configured as {}", (Object)this.compressedAudioFormat);
        } else {
            logger.info("Default '{}' audio encoding will be used", (Object)this.compressedAudioFormat);
        }
        Option isAutoDetectLanguageOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)IS_AUTO_DETECT_LANGUAGE);
        if (isAutoDetectLanguageOpt.isSome()) {
            this.defaultIsAutoDetectLanguage = Boolean.valueOf((String)isAutoDetectLanguageOpt.get());
        }
        logger.info("Automatically detecting language is globally enabled: {}", (Object)this.defaultIsAutoDetectLanguage);
        Option autoDetectLanguagesOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)AUTO_DETECT_LANGUAGES);
        if (autoDetectLanguagesOpt.isSome()) {
            this.defaultAutoDetectLanguages = new ArrayList<String>(Arrays.asList(((String)autoDetectLanguagesOpt.get()).split(",")));
            if (this.defaultIsAutoDetectLanguage && (this.defaultAutoDetectLanguages.size() == 0 || this.defaultAutoDetectLanguages.size() > 4)) {
                throw new ConfigurationException("When using automatic language detection, the list of languages must containat least one language and at most four languages");
            }
            logger.info("Languages for auto detection: {}", this.defaultAutoDetectLanguages);
        } else {
            logger.info("No languages for auto detection defined");
        }
        Option isSplitTextOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)SPLIT_TEXT);
        if (isSplitTextOpt.isSome()) {
            this.splitText = Boolean.valueOf((String)isSplitTextOpt.get());
        }
        if ((splitTextLineSizeOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)SPLIT_TEXT_LINE_SIZE)).isSome()) {
            try {
                this.splitTextLineSize = Integer.parseInt((String)splitTextLineSizeOpt.get());
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Invalid configuration for split text line size. Please check yourconfiguration");
            }
        }
        if (this.splitText) {
            logger.info("Long text will be split at {} characters", (Object)this.splitTextLineSize);
        }
        if ((wfOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)WORKFLOW_CONFIG)).isSome()) {
            this.workflowDefinitionId = (String)wfOpt.get();
        }
        logger.info("Workflow definition is {}", (Object)this.workflowDefinitionId);
        Option intervalOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)DISPATCH_WORKFLOW_INTERVAL_CONFIG);
        if (intervalOpt.isSome()) {
            try {
                this.workflowDispatchInterval = Long.parseLong((String)intervalOpt.get());
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid configuration for Workflow dispatch interval. Default used instead: {}", (Object)this.workflowDispatchInterval);
            }
        }
        logger.info("Workflow dispatch interval is {} seconds", (Object)this.workflowDispatchInterval);
        Option bufferOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)COMPLETION_CHECK_BUFFER_CONFIG);
        if (bufferOpt.isSome()) {
            try {
                this.completionCheckBuffer = Long.parseLong((String)bufferOpt.get());
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid configuration for {} : {}. Default used instead: {}", new Object[]{COMPLETION_CHECK_BUFFER_CONFIG, bufferOpt.get(), this.completionCheckBuffer});
            }
        }
        logger.info("Completion check buffer is {} seconds", (Object)this.completionCheckBuffer);
        Option maxProcessingOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)MAX_PROCESSING_TIME_CONFIG);
        if (maxProcessingOpt.isSome()) {
            try {
                this.maxProcessingSeconds = Long.parseLong((String)maxProcessingOpt.get());
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid configuration for maximum processing time. Default used instead: {}", (Object)this.maxProcessingSeconds);
            }
        }
        logger.info("Maximum time a job is checked after it should have ended is {} seconds", (Object)this.maxProcessingSeconds);
        Option cleaupOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)CLEANUP_RESULTS_DAYS_CONFIG);
        if (cleaupOpt.isSome()) {
            try {
                this.cleanupResultDays = Integer.parseInt((String)cleaupOpt.get());
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid configuration for clean up days. Default used instead: {}", (Object)this.cleanupResultDays);
            }
        }
        logger.info("Cleanup result files after {} days", (Object)this.cleanupResultDays);
        this.systemAccount = OsgiUtil.getContextProperty((ComponentContext)cc, (String)"org.opencastproject.security.digest.user");
        Option optTo = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)NOTIFICATION_EMAIL_CONFIG);
        if (optTo.isSome()) {
            this.toEmailAddress = (String)optTo.get();
        } else {
            optTo = OsgiUtil.getOptContextProperty((ComponentContext)cc, (String)"org.opencastproject.admin.email");
            if (optTo.isSome()) {
                this.toEmailAddress = (String)optTo.get();
            }
        }
        if (this.toEmailAddress != null) {
            logger.info("Notification email set to {}", (Object)this.toEmailAddress);
        } else {
            logger.warn("Email notification disabled");
        }
        Option optCluster = OsgiUtil.getOptContextProperty((ComponentContext)cc, (String)"org.opencastproject.environment.name");
        if (optCluster.isSome()) {
            this.clusterName = (String)optCluster.get();
        }
        logger.info("Environment name is {}", (Object)this.clusterName);
        this.scheduledExecutor.scheduleWithFixedDelay(new WorkflowDispatcher(), 120L, this.workflowDispatchInterval, TimeUnit.SECONDS);
        this.scheduledExecutor.scheduleWithFixedDelay(new ResultsFileCleanup(), 1L, 1L, TimeUnit.DAYS);
        logger.info("Activated!");
    }

    private AudioConfig getAudioConfig(String filePath) {
        AudioStreamFormat format = AudioStreamFormat.getCompressedFormat(this.compressedAudioFormat);
        BinaryFileReader callback = new BinaryFileReader(filePath);
        PullAudioInputStream stream = AudioInputStream.createPullStream(callback, format);
        return AudioConfig.fromStreamInput(stream);
    }

    private SpeechConfig getSpeechConfig(String languageCode) {
        SpeechConfig speechConfig = SpeechConfig.fromSubscription(this.subscriptionKey, this.region);
        speechConfig.setSpeechRecognitionLanguage(languageCode);
        speechConfig.setProfanity(this.profanityOption);
        speechConfig.setProperty(PropertyId.SpeechServiceResponse_PostProcessingOption, "TrueText");
        return speechConfig;
    }

    public Job startTranscription(String mpId, Track track, String ... args) throws TranscriptionServiceException {
        if (!this.enabled) {
            throw new TranscriptionServiceException("This service is disabled. If you want to enable it, please update the service configuration.");
        }
        if (args.length != 3) {
            throw new IllegalArgumentException("Must provide three arguments: language, autoDetect, autoDetectLanguages. Anyof these arguments may be an empty string.");
        }
        String language = args[0];
        String autoDetect = args[1];
        String autoDetectLanguages = args[2];
        try {
            return this.serviceRegistry.createJob(JOB_TYPE, Operation.StartTranscription.name(), Arrays.asList(mpId, MediaPackageElementParser.getAsXml((MediaPackageElement)track), language, autoDetect, autoDetectLanguages));
        }
        catch (ServiceRegistryException e) {
            throw new TranscriptionServiceException("Unable to create a job", (Throwable)e);
        }
        catch (MediaPackageException e) {
            throw new TranscriptionServiceException("Invalid track " + track.toString(), (Throwable)e);
        }
    }

    public Job startTranscription(String mpId, Track track) throws TranscriptionServiceException {
        return this.startTranscription(mpId, track, this.defaultLanguage, Boolean.toString(this.defaultIsAutoDetectLanguage), String.join((CharSequence)", ", this.defaultAutoDetectLanguages));
    }

    public String getLanguage() {
        return this.defaultLanguage;
    }

    public void transcriptionError(String mpId, Object obj) throws TranscriptionServiceException {
        String jobId = null;
        try {
            jobId = (String)obj;
            this.database.updateJobControl(jobId, TranscriptionJobControl.Status.Error.name());
            TranscriptionJobControl jobControl = this.database.findByJob(jobId);
            logger.warn("Error received for media package {}, job id {}", (Object)jobControl.getMediaPackageId(), (Object)jobId);
            this.sendEmail(TRANSCRIPTION_ERROR, String.format("There was a transcription error for for media package %s, job id %s.", jobControl.getMediaPackageId(), jobId));
        }
        catch (TranscriptionDatabaseException e) {
            logger.warn("Transcription error. State in db could not be updated to error for mpId {}, jobId {}", (Object)mpId, (Object)jobId);
            throw new TranscriptionServiceException("Could not update transcription job control db", (Throwable)e);
        }
    }

    protected String process(Job job) throws Exception {
        Operation op = null;
        String operation = job.getOperation();
        List arguments = job.getArguments();
        op = Operation.valueOf(operation);
        switch (op) {
            case StartTranscription: {
                String mpId = (String)arguments.get(0);
                Track track = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(1)));
                String languageCode = (String)arguments.get(2);
                String autoDetect = (String)arguments.get(3);
                String autoDetectLanguages = (String)arguments.get(4);
                this.runTranscriptionJob(mpId, track, Long.toString(job.getId()), languageCode, autoDetect, autoDetectLanguages);
                break;
            }
            default: {
                throw new IllegalStateException("Don't know how to handle operation '" + operation + "'");
            }
        }
        return "";
    }

    void runTranscriptionJob(String mpId, Track track, String jobId, String languageCode, String isAutoDetectString, String isAutoDetectLanguagesString) throws TranscriptionServiceException {
        List<String> autoDetectLanguages;
        if (StringUtils.isBlank((CharSequence)languageCode)) {
            languageCode = this.defaultLanguage;
        }
        boolean isAutoDetectLanguage = StringUtils.isBlank((CharSequence)isAutoDetectString) ? this.defaultIsAutoDetectLanguage : Boolean.valueOf(isAutoDetectString);
        if (StringUtils.isBlank((CharSequence)isAutoDetectLanguagesString)) {
            autoDetectLanguages = this.defaultAutoDetectLanguages;
        } else {
            autoDetectLanguages = new ArrayList<String>(Arrays.asList(isAutoDetectLanguagesString.split(",")));
            if (this.defaultIsAutoDetectLanguage && (this.defaultAutoDetectLanguages.size() == 0 || this.defaultAutoDetectLanguages.size() > 4)) {
                throw new TranscriptionServiceException("When using automatic language detection, the list of languages must contain at least one language and at most four languages");
            }
        }
        try {
            SpeechRecognizer speechRecognizer;
            AudioConfig audioConfig = this.getAudioConfig(this.workspace.get(track.getURI()).getPath());
            SpeechConfig speechConfig = this.getSpeechConfig(languageCode);
            if (isAutoDetectLanguage) {
                AutoDetectSourceLanguageConfig autoDetectSourceLanguageConfig = AutoDetectSourceLanguageConfig.fromLanguages(autoDetectLanguages);
                speechRecognizer = new SpeechRecognizer(speechConfig, autoDetectSourceLanguageConfig, audioConfig);
            } else {
                speechRecognizer = new SpeechRecognizer(speechConfig, audioConfig);
            }
            PhraseListGrammar grammar = PhraseListGrammar.fromRecognizer(speechRecognizer);
            for (String phrase : this.phraseList) {
                grammar.addPhrase(phrase);
            }
            this.recognizeContinuous(speechRecognizer, jobId, mpId, track, isAutoDetectLanguage);
        }
        catch (IOException | ExecutionException | NotFoundException e) {
            throw new TranscriptionServiceException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new TranscriptionServiceException(e.getMessage());
        }
    }

    void recognizeContinuous(SpeechRecognizer speechRecognizer, String jobId, String mpId, Track track, boolean isAutoDetectLanguage) throws ExecutionException, InterruptedException {
        int[] sequenceNumber = new int[]{0};
        boolean[] languageDetected = new boolean[]{false};
        speechRecognizer.sessionStarted.addEventListener((s, e) -> {
            logger.info("Transcription job {} for media package {} started.", (Object)jobId, (Object)mpId);
            try {
                this.database.storeJobControl(mpId, track.getIdentifier(), jobId, TranscriptionJobControl.Status.InProgress.name(), track.getDuration() == null ? 0L : track.getDuration(), null, PROVIDER);
                this.createTranscriptFile(jobId);
            }
            catch (TranscriptionDatabaseException ex) {
                this.errorCallback("Could not store job: " + ex, speechRecognizer, jobId, mpId);
            }
            catch (IOException ex) {
                this.errorCallback("Unable to create transcription file: " + ex, speechRecognizer, jobId, mpId);
            }
        });
        speechRecognizer.recognized.addEventListener((s, e) -> {
            SpeechRecognitionResult result = e.getResult();
            if (ResultReason.RecognizedSpeech == result.getReason() && result.getText().length() > 0) {
                AutoDetectSourceLanguageResult autoDetectSourceLanguageResult;
                sequenceNumber[0] = sequenceNumber[0] + 1;
                List<String> texts = this.captionFromSpeechRecognitionResult(sequenceNumber[0], e.getResult());
                sequenceNumber[0] = sequenceNumber[0] + (texts.size() - 1);
                for (String text : texts) {
                    try {
                        this.writeTranscriptToFile(text, jobId);
                    }
                    catch (NotFoundException ex) {
                        this.errorCallback("Transcription file not found: " + ex, speechRecognizer, jobId, mpId);
                    }
                    catch (IOException ex) {
                        this.errorCallback("Unable to write to transcription file: " + ex, speechRecognizer, jobId, mpId);
                    }
                }
                if (!languageDetected[0] && isAutoDetectLanguage && (autoDetectSourceLanguageResult = AutoDetectSourceLanguageResult.fromResult(result)) != null && StringUtils.isNotBlank((CharSequence)autoDetectSourceLanguageResult.getLanguage())) {
                    try {
                        this.workspace.putInCollection(TRANSCRIPT_COLLECTION, this.getTranscriptLanguageFileName(jobId), (InputStream)new ByteArrayInputStream(autoDetectSourceLanguageResult.getLanguage().getBytes(StandardCharsets.UTF_8)));
                        languageDetected[0] = true;
                    }
                    catch (IOException ex) {
                        this.errorCallback("Unable to write to transcription language file: " + ex, speechRecognizer, jobId, mpId);
                    }
                }
            } else if (ResultReason.NoMatch == e.getResult().getReason()) {
                logger.debug("NOMATCH: Speech could not be recognized by transcription job {}.", (Object)jobId);
            }
        });
        speechRecognizer.canceled.addEventListener((s, e) -> {
            String errorMessage = null;
            if (CancellationReason.EndOfStream == e.getReason()) {
                logger.debug("End of stream reached for transcription job {}", (Object)jobId);
                return;
            }
            errorMessage = CancellationReason.CancelledByUser == e.getReason() ? "User canceled request." : (CancellationReason.Error == e.getReason() ? String.format("Encountered error.%sError code: %s%sError details: %s", System.lineSeparator(), e.getErrorCode().name(), System.lineSeparator(), e.getErrorDetails()) : String.format("Request was cancelled for an unrecognized reason: %d.", new Object[]{e.getReason()}));
            this.errorCallback(errorMessage, speechRecognizer, jobId, mpId);
        });
        speechRecognizer.sessionStopped.addEventListener((s, e) -> {
            try {
                logger.info("Transcription job {} for media package {} ended.", (Object)jobId, (Object)mpId);
                speechRecognizer.stopContinuousRecognitionAsync().get();
                this.database.updateJobControl(jobId, TranscriptionJobControl.Status.TranscriptionComplete.name());
            }
            catch (InterruptedException | ExecutionException | TranscriptionDatabaseException ex) {
                this.errorCallback("Could not save transcription results file: " + (Exception)ex, speechRecognizer, jobId, mpId);
            }
        });
        speechRecognizer.startContinuousRecognitionAsync().get();
    }

    private URI createTranscriptFile(String jobId) throws IOException {
        String transcript = "";
        if (!this.useSubRipTextCaptionFormat) {
            transcript = String.format("WEBVTT%s%s", System.lineSeparator(), System.lineSeparator());
        }
        logger.trace("Create transcript for transcription job {}", (Object)jobId);
        return this.workspace.putInCollection(TRANSCRIPT_COLLECTION, this.getTranscriptFileName(jobId), (InputStream)new ByteArrayInputStream(transcript.getBytes(StandardCharsets.UTF_8)));
    }

    private void writeTranscriptToFile(String text, String jobId) throws NotFoundException, IOException {
        URI collectionURI = this.workspace.getCollectionURI(TRANSCRIPT_COLLECTION, this.getTranscriptFileName(jobId));
        File transcriptFile = this.workspace.get(collectionURI);
        logger.trace("Write transcript to {}: {}", (Object)transcriptFile.getAbsolutePath(), (Object)text);
        try (FileWriter transcriptWriter = new FileWriter(transcriptFile, StandardCharsets.UTF_8, true);){
            transcriptWriter.write(text);
        }
    }

    private String getTranscriptFileName(String jobId) {
        return this.workspace.toSafeName("transcript_" + jobId + "." + this.fileFormat);
    }

    private String getTranscriptLanguageFileName(String jobId) {
        return this.workspace.toSafeName("transcript_lang_" + jobId + ".txt");
    }

    private List<String> captionFromSpeechRecognitionResult(int sequenceNumber, SpeechRecognitionResult result) {
        List<BigInteger> durations;
        List<BigInteger> offsets;
        List<String> lines;
        if (this.splitText) {
            lines = this.splitText(result.getText());
            Map<String, List<BigInteger>> offsetsAndDurations = this.splitTextTimes(lines, result.getOffset(), result.getDuration());
            offsets = offsetsAndDurations.get("offsets");
            durations = offsetsAndDurations.get("durations");
        } else {
            lines = Collections.singletonList(result.getText());
            offsets = Collections.singletonList(result.getOffset());
            durations = Collections.singletonList(result.getDuration());
        }
        ArrayList<String> formattedLines = new ArrayList<String>();
        for (int i = 0; i < lines.size(); ++i) {
            StringBuilder caption = new StringBuilder();
            if (this.useSubRipTextCaptionFormat) {
                caption.append(String.format("%d%s", sequenceNumber + i, System.lineSeparator()));
            }
            caption.append(String.format("%s%s", this.timestampFromSpeechRecognitionResult(offsets.get(i), durations.get(i)), System.lineSeparator()));
            caption.append(String.format("%s%s%s", lines.get(i), System.lineSeparator(), System.lineSeparator()));
            formattedLines.add(caption.toString());
        }
        return formattedLines;
    }

    private List<String> splitText(String text) {
        int previousSplitLength = 0;
        int nextSplitLength = this.splitTextLineSize;
        ArrayList<String> lines = new ArrayList<String>();
        do {
            int index;
            for (index = nextSplitLength; index < text.length() && text.charAt(index) != ' '; ++index) {
            }
            if (index >= text.length()) {
                index = text.length() - 1;
            }
            lines.add(text.substring(previousSplitLength, index).trim());
            previousSplitLength = index;
            nextSplitLength = index + this.splitTextLineSize;
        } while (text.length() > previousSplitLength + 1);
        return lines;
    }

    private Map<String, List<BigInteger>> splitTextTimes(List<String> lines, BigInteger offset, BigInteger duration) {
        ArrayList<BigInteger> offsets = new ArrayList<BigInteger>();
        ArrayList<BigInteger> durations = new ArrayList<BigInteger>();
        BigInteger percentage = BigInteger.ZERO;
        int lengthOfAllLines = lines.stream().mapToInt(l -> l.length()).sum();
        for (int i = 0; i < lines.size(); ++i) {
            BigInteger previousDurations = durations.stream().reduce(BigInteger.ZERO, BigInteger::add);
            offsets.add(offset.add(previousDurations));
            percentage = BigDecimal.valueOf((double)lines.get(i).length() / (double)lengthOfAllLines).multiply(new BigDecimal(duration)).toBigInteger();
            durations.add(percentage);
        }
        HashMap<String, List<BigInteger>> map = new HashMap<String, List<BigInteger>>();
        map.put("offsets", offsets);
        map.put("durations", durations);
        return map;
    }

    private String timestampFromSpeechRecognitionResult(BigInteger offset, BigInteger duration) {
        BigInteger ticksPerMillisecond = BigInteger.valueOf(10000L);
        Date startTime = new Date(offset.divide(ticksPerMillisecond).longValue());
        Date endTime = new Date(offset.add(duration).divide(ticksPerMillisecond).longValue());
        String format = "";
        format = this.useSubRipTextCaptionFormat ? "HH:mm:ss,SSS" : "HH:mm:ss.SSS";
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return String.format("%s --> %s", formatter.format(startTime), formatter.format(endTime));
    }

    private void errorCallback(String errorMessage, SpeechRecognizer speechRecognizer, String jobId, String mpId) {
        try {
            logger.error(errorMessage);
            if (speechRecognizer != null) {
                speechRecognizer.stopContinuousRecognitionAsync().get();
            }
            this.transcriptionError(mpId, jobId);
        }
        catch (InterruptedException | ExecutionException | TranscriptionServiceException interruptedException) {
            logger.error("Error in error state: " + (Exception)interruptedException);
        }
    }

    public MediaPackageElement getGeneratedTranscription(String mpId, String jobId, MediaPackageElement.Type type) throws TranscriptionServiceException {
        try {
            if (jobId == null || "null".equals(jobId)) {
                jobId = this.getTranscriptionJobId(mpId);
            }
            URI uri = this.workspace.getCollectionURI(TRANSCRIPT_COLLECTION, this.getTranscriptFileName(jobId));
            MediaPackageElementBuilder builder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
            return builder.elementFromURI(uri, type, new MediaPackageElementFlavor("captions", "microsoft-azure"));
        }
        catch (TranscriptionDatabaseException e) {
            throw new TranscriptionServiceException("Job id not informed and could not find transcription", (Throwable)e);
        }
    }

    public Map<String, Object> getReturnValues(String mpId, String jobId) throws TranscriptionServiceException {
        try {
            if (jobId == null || "null".equals(jobId)) {
                jobId = this.getTranscriptionJobId(mpId);
            }
            URI uri = this.workspace.getCollectionURI(TRANSCRIPT_COLLECTION, this.getTranscriptLanguageFileName(jobId));
            File languageFile = this.workspace.get(uri);
            String language = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(languageFile.getAbsoluteFile(), StandardCharsets.UTF_8));){
                language = reader.readLine();
            }
            HashMap<String, Object> returnValues = new HashMap<String, Object>();
            returnValues.put(DETECTED_LANGUAGE, language);
            return returnValues;
        }
        catch (FileNotFoundException | TranscriptionDatabaseException e) {
            throw new TranscriptionServiceException("Job id not informed and could not find transcription", e);
        }
        catch (IOException | NotFoundException e) {
            throw new TranscriptionServiceException("Error getting file from workspace", e);
        }
    }

    public void transcriptionDone(String mpId, Object obj) throws TranscriptionServiceException {
        logger.info("transcriptionDone not implemented");
    }

    private String getTranscriptionJobId(String mpId) throws TranscriptionServiceException, TranscriptionDatabaseException {
        String jobId = null;
        for (TranscriptionJobControl jc : this.database.findByMediaPackage(mpId)) {
            if (!TranscriptionJobControl.Status.Closed.name().equals(jc.getStatus()) && !TranscriptionJobControl.Status.TranscriptionComplete.name().equals(jc.getStatus())) continue;
            jobId = jc.getTranscriptionJobId();
        }
        if (jobId == null) {
            throw new TranscriptionServiceException("No completed or closed transcription job found in database for media package " + mpId);
        }
        return jobId;
    }

    private void sendEmail(String subject, String body) {
        if (this.toEmailAddress == null) {
            logger.info("Skipping sending email notification. Message is {}.", (Object)body);
            return;
        }
        try {
            logger.debug("Sending e-mail notification to {}", (Object)this.toEmailAddress);
            this.smtpService.send(this.toEmailAddress, String.format("%s (%s)", subject, this.clusterName), body);
            logger.info("Sent e-mail notification to {}", (Object)this.toEmailAddress);
        }
        catch (Exception e) {
            logger.error("Could not send email: {}\n{}", new Object[]{subject, body, e});
        }
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Reference
    public void setSmtpService(SmtpService service) {
        this.smtpService = service;
    }

    @Reference
    public void setWorkspace(Workspace ws) {
        this.workspace = ws;
    }

    @Reference
    public void setWorkingFileRepository(WorkingFileRepository wfr) {
        this.wfr = wfr;
    }

    @Reference
    public void setDatabase(TranscriptionDatabase service) {
        this.database = service;
    }

    @Reference
    public void setAssetManager(AssetManager service) {
        this.assetManager = service;
    }

    @Reference
    public void setWorkflowService(WorkflowService service) {
        this.workflowService = service;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    void setWfUtil(Workflows wfUtil) {
        this.wfUtil = wfUtil;
    }

    private String startWorkflow(String mpId, String wfDefId, String jobId, Map<String, String> params) {
        DefaultOrganization defaultOrg = new DefaultOrganization();
        this.securityService.setOrganization((Organization)defaultOrg);
        this.securityService.setUser(SecurityUtil.createSystemUser((String)this.systemAccount, (Organization)defaultOrg));
        AQueryBuilder q = this.assetManager.createQuery();
        AResult r = q.select(new Target[]{q.snapshot()}).where(q.mediaPackageId(mpId).and(q.version().isLatest())).run();
        if (r.getSize() == 0L) {
            if (!this.hasTranscriptionRequestExpired(jobId)) {
                logger.warn("Media package {} has not been archived yet or has been deleted. Will keep trying for {} more minutes before cancelling transcription job {}.", new Object[]{mpId, this.getRemainingTranscriptionExpireTimeInMin(jobId), jobId});
            } else {
                this.cancelTranscription(jobId, " Microsoft Azure Transcription job canceled, archived media package not found");
                logger.info("Microsoft Azure Transcription job {} has been canceled. Email notification sent", (Object)jobId);
            }
            return null;
        }
        String org = ((Snapshot)Enrichments.enrich((AResult)r).getSnapshots().stream().findFirst().get()).getOrganizationId();
        Organization organization = null;
        try {
            organization = this.organizationDirectoryService.getOrganization(org);
            if (organization == null) {
                logger.warn("Media package {} has an unknown organization {}.", (Object)mpId, (Object)org);
                return null;
            }
        }
        catch (NotFoundException e) {
            logger.warn("Organization {} not found for media package {}.", (Object)org, (Object)mpId);
            return null;
        }
        this.securityService.setOrganization(organization);
        try {
            WorkflowDefinition wfDef = this.workflowService.getWorkflowDefinitionById(wfDefId);
            Workflows workflows = this.wfUtil != null ? this.wfUtil : new Workflows(this.assetManager, this.workflowService);
            HashSet<String> mpIds = new HashSet<String>();
            mpIds.add(mpId);
            List wfList = workflows.applyWorkflowToLatestVersion(mpIds, ConfiguredWorkflow.workflow((WorkflowDefinition)wfDef, params)).toList();
            return wfList.size() > 0 ? Long.toString(((WorkflowInstance)wfList.get(0)).getId()) : null;
        }
        catch (NotFoundException | WorkflowDatabaseException e) {
            logger.warn("Could not get workflow definition: {}", (Object)wfDefId);
            return null;
        }
    }

    private boolean hasTranscriptionRequestExpired(String jobId) {
        try {
            if (this.database.findByJob(jobId).getDateCreated().getTime() + this.database.findByJob(jobId).getTrackDuration() + (this.completionCheckBuffer + this.maxProcessingSeconds) * 1000L < System.currentTimeMillis()) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("ERROR while calculating transcription request expiration for job: %s", (Object)jobId, (Object)e);
            return true;
        }
        return false;
    }

    private long getRemainingTranscriptionExpireTimeInMin(String jobId) {
        try {
            long expiredTime = this.database.findByJob(jobId).getDateCreated().getTime() + this.database.findByJob(jobId).getTrackDuration() + (this.completionCheckBuffer + this.maxProcessingSeconds) * 1000L - System.currentTimeMillis();
            if (expiredTime < 0L) {
                expiredTime = 0L;
            }
            return TimeUnit.MILLISECONDS.toMinutes(expiredTime);
        }
        catch (Exception e) {
            logger.error("Unable to calculate remaining transcription expired time for transcription job {}", (Object)jobId);
            return 0L;
        }
    }

    private void cancelTranscription(String jobId, String message) {
        try {
            this.database.updateJobControl(jobId, TranscriptionJobControl.Status.Canceled.name());
            String mpId = this.database.findByJob(jobId).getMediaPackageId();
            this.sendEmail(TRANSCRIPTION_ERROR, String.format("%s(media package %s, job id %s).", message, mpId, jobId));
        }
        catch (Exception e) {
            logger.error("ERROR while deleting transcription job: %s", (Object)jobId, (Object)e);
        }
    }

    class ResultsFileCleanup
    implements Runnable {
        ResultsFileCleanup() {
        }

        @Override
        public void run() {
            logger.info("ResultsFileCleanup waking up...");
            try {
                MicrosoftAzureTranscriptionService.this.wfr.cleanupOldFilesFromCollection(MicrosoftAzureTranscriptionService.TRANSCRIPT_COLLECTION, (long)MicrosoftAzureTranscriptionService.this.cleanupResultDays);
            }
            catch (IOException e) {
                logger.warn("Could not cleanup old transcript results files", (Throwable)e);
            }
        }
    }

    class WorkflowDispatcher
    implements Runnable {
        WorkflowDispatcher() {
        }

        @Override
        public void run() {
            logger.debug("WorkflowDispatcher waking up...");
            try {
                TranscriptionProviderControl providerInfo = MicrosoftAzureTranscriptionService.this.database.findIdByProvider(MicrosoftAzureTranscriptionService.PROVIDER);
                if (providerInfo == null) {
                    logger.debug("No jobs yet for provider {}", (Object)MicrosoftAzureTranscriptionService.PROVIDER);
                    return;
                }
                long providerId = providerInfo.getId();
                List jobs = MicrosoftAzureTranscriptionService.this.database.findByStatus(new String[]{TranscriptionJobControl.Status.TranscriptionComplete.name()});
                for (TranscriptionJobControl j : jobs) {
                    if (j.getProviderId() != providerId) continue;
                    String mpId = j.getMediaPackageId();
                    String jobId = j.getTranscriptionJobId();
                    try {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put(MicrosoftAzureTranscriptionService.TRANSCRIPTION_JOB_ID_KEY, jobId);
                        String wfId = MicrosoftAzureTranscriptionService.this.startWorkflow(mpId, MicrosoftAzureTranscriptionService.this.workflowDefinitionId, jobId, params);
                        if (wfId == null) {
                            logger.warn("Attach transcription workflow could NOT be scheduled for mp {}, microsoft azure job {}", (Object)mpId, (Object)jobId);
                            continue;
                        }
                        MicrosoftAzureTranscriptionService.this.database.updateJobControl(jobId, TranscriptionJobControl.Status.Closed.name());
                        logger.info("Attach transcription workflow {} scheduled for mp {}, microsoft azure job {}", new Object[]{wfId, mpId, jobId});
                    }
                    catch (Exception e) {
                        logger.warn("Attach transcription workflow could NOT be scheduled for mp {},microsoft azure job {}, {}: {}", new Object[]{mpId, jobId, e.getClass().getName(), e.getMessage()});
                    }
                }
            }
            catch (TranscriptionDatabaseException e) {
                logger.warn("Could not read transcription job control database: {}", (Object)e.getMessage());
            }
        }
    }

    private static enum Operation {
        StartTranscription;

    }
}

