/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.transcription.microsoftazure;

import com.microsoft.cognitiveservices.speech.audio.PullAudioInputStreamCallback;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryFileReader
extends PullAudioInputStreamCallback {
    private static final Logger logger = LoggerFactory.getLogger(BinaryFileReader.class);
    private InputStream stream;

    public BinaryFileReader(String audioFileName) {
        try {
            this.stream = new FileInputStream(audioFileName);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    @Override
    public int read(byte[] dataBuffer) {
        long ret = 0L;
        try {
            ret = this.stream.read(dataBuffer, 0, dataBuffer.length);
        }
        catch (Exception ex) {
            logger.error("Read: " + ex);
        }
        return (int)Math.max(0L, ret);
    }

    @Override
    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

