/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.util;

import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public class SafeHandle
implements AutoCloseable {
    private long value = 0L;
    private SafeHandleType handleType = SafeHandleType.UnInitialized;

    public SafeHandle(long l, SafeHandleType safeHandleType) {
        this.value = l;
        this.handleType = safeHandleType;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void setValue(long l) {
        this.value = l;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public void close() {
        if (this.value != 0L) {
            if (this.handleType == SafeHandleType.Event) {
                this.releaseEventHandle(this.value);
            } else if (this.handleType == SafeHandleType.Recognizer) {
                this.releaseRecognizerHandle(this.value);
            } else if (this.handleType == SafeHandleType.SpeechConfig) {
                this.releaseSpeechConfigHandle(this.value);
            } else if (this.handleType == SafeHandleType.PropertyCollection) {
                this.releasePropertyHandle(this.value);
            } else if (this.handleType == SafeHandleType.RecognitionResult) {
                this.releaseRecognizerResultHandle(this.value);
            } else if (this.handleType == SafeHandleType.AudioConfig) {
                this.releaseAudioConfigHandle(this.value);
            } else if (this.handleType == SafeHandleType.Connection) {
                this.releaseConnectionHandle(this.value);
            } else if (this.handleType == SafeHandleType.ConnectionMessage) {
                this.releaseConnectionMessageHandle(this.value);
            } else if (this.handleType == SafeHandleType.ConnectionMessageEvent) {
                this.releaseConnectionMessageEventHandle(this.value);
            } else if (this.handleType == SafeHandleType.AudioInputStream) {
                this.releaseAudioInputStreamHandle(this.value);
            } else if (this.handleType == SafeHandleType.AudioStreamFormat) {
                this.releaseAudioStreamFormatHandle(this.value);
            } else if (this.handleType == SafeHandleType.KeywordModel) {
                this.releaseKeywordModelHandle(this.value);
            } else if (this.handleType == SafeHandleType.LanguageUnderstandingModel) {
                this.releaseLanguageUnderstandingModelHandle(this.value);
            } else if (this.handleType == SafeHandleType.IntentTrigger) {
                this.releaseIntentTriggerHandle(this.value);
            } else if (this.handleType == SafeHandleType.User) {
                this.releaseUserHandle(this.value);
            } else if (this.handleType == SafeHandleType.Participant) {
                this.releaseParticipantHandle(this.value);
            } else if (this.handleType == SafeHandleType.Conversation) {
                this.releaseConversationHandle(this.value);
            } else if (this.handleType == SafeHandleType.DialogServiceConnector) {
                this.releaseDialogServiceConnectorHandle(this.value);
            } else if (this.handleType == SafeHandleType.TurnStatusReceivedEvent) {
                this.releaseTurnStatusReceivedEventHandle(this.value);
            } else if (this.handleType == SafeHandleType.ActivityReceivedEvent) {
                this.releaseActivityReceivedEventHandle(this.value);
            } else if (this.handleType == SafeHandleType.AudioOutputStream) {
                this.releaseAudioOutputStreamHandle(this.value);
            } else if (this.handleType == SafeHandleType.AutoDetectSourceLanguageConfig) {
                this.releaseAutoDetectSourceLanguageConfigHandle(this.value);
            } else if (this.handleType == SafeHandleType.SourceLanguageConfig) {
                this.releaseSourceLanguageConfigHandle(this.value);
            } else if (this.handleType == SafeHandleType.SynthesisEvent) {
                this.releaseSynthesisEventHandle(this.value);
            } else if (this.handleType == SafeHandleType.SynthesisResult) {
                this.releaseSynthesisResultHandle(this.value);
            } else if (this.handleType == SafeHandleType.VoiceInfo) {
                this.releaseVoiceInfoHandle(this.value);
            } else if (this.handleType == SafeHandleType.AudioDataStream) {
                this.releaseAudioDataStreamHandle(this.value);
            } else if (this.handleType == SafeHandleType.Synthesizer) {
                this.releaseSynthesizerHandle(this.value);
            } else if (this.handleType == SafeHandleType.Grammar) {
                this.releaseGrammarHandle(this.value);
            } else if (this.handleType == SafeHandleType.TranslationSynthesis) {
                this.releaseTranslationSynthesisHandle(this.value);
            } else if (this.handleType == SafeHandleType.ConversationTranslator) {
                this.releaseConversationTranslatorHandle(this.value);
            } else if (this.handleType == SafeHandleType.KeywordRecognizer) {
                this.releaseKeywordRecognizerHandle(this.value);
            } else if (this.handleType == SafeHandleType.PronunciationAssessmentConfig) {
                this.releasePronunciationAssessmentConfig(this.value);
            } else if (this.handleType == SafeHandleType.SpeakerRecognizer) {
                this.releaseSpeakerRecognizerHandle(this.value);
            } else if (this.handleType == SafeHandleType.SpeakerIdentificationModel) {
                this.releaseSpeakerIdentificationModelHandle(this.value);
            } else if (this.handleType == SafeHandleType.SpeakerRecognitionResult) {
                this.releaseSpeakerRecognitionResultHandle(this.value);
            } else if (this.handleType == SafeHandleType.SpeakerVerificationModel) {
                this.releaseSpeakerVerificationModelHandle(this.value);
            } else if (this.handleType == SafeHandleType.VoiceProfileResult) {
                this.releaseVoiceProfileResultHandle(this.value);
            } else if (this.handleType == SafeHandleType.VoiceProfileEnrollmentResult) {
                this.releaseVoiceProfileEnrollmentResultHandle(this.value);
            } else if (this.handleType == SafeHandleType.VoiceProfilePhraseResult) {
                this.releaseVoiceProfilePhraseResultHandle(this.value);
            } else if (this.handleType == SafeHandleType.VoiceProfileClient) {
                this.releaseVoiceProfileClientHandle(this.value);
            } else if (this.handleType == SafeHandleType.VoiceProfile) {
                this.releaseVoiceProfileHandle(this.value);
            } else if (this.handleType == SafeHandleType.AudioProcessingOptions) {
                this.releaseAudioProcessingOptionsHandle(this.value);
            } else if (this.handleType == SafeHandleType.SpeechRecognitionModel) {
                this.releaseSpeechRecognitionModelHandle(this.value);
            } else {
                System.out.println("Java SafeHandle close, invalid handle value: " + String.valueOf(this.value));
            }
            this.value = 0L;
            this.handleType = SafeHandleType.UnInitialized;
        }
    }

    private final native long releaseEventHandle(long var1);

    private final native long releaseRecognizerHandle(long var1);

    private final native long releaseSpeechConfigHandle(long var1);

    private final native long releaseAudioConfigHandle(long var1);

    private final native long releasePropertyHandle(long var1);

    private final native long releaseRecognizerResultHandle(long var1);

    private final native long releaseConnectionHandle(long var1);

    private final native long releaseConnectionMessageHandle(long var1);

    private final native long releaseConnectionMessageEventHandle(long var1);

    private final native long releaseAudioInputStreamHandle(long var1);

    private final native long releaseAudioOutputStreamHandle(long var1);

    private final native long releaseAudioStreamFormatHandle(long var1);

    private final native long releaseKeywordModelHandle(long var1);

    private final native long releaseLanguageUnderstandingModelHandle(long var1);

    private final native long releaseIntentTriggerHandle(long var1);

    private final native long releaseUserHandle(long var1);

    private final native long releaseParticipantHandle(long var1);

    private final native long releaseConversationHandle(long var1);

    private final native long releaseDialogServiceConnectorHandle(long var1);

    private final native long releaseTurnStatusReceivedEventHandle(long var1);

    private final native long releaseActivityReceivedEventHandle(long var1);

    private final native long releaseAutoDetectSourceLanguageConfigHandle(long var1);

    private final native long releaseSourceLanguageConfigHandle(long var1);

    private final native long releaseSynthesisEventHandle(long var1);

    private final native long releaseSynthesisResultHandle(long var1);

    private final native long releaseVoiceInfoHandle(long var1);

    private final native long releaseAudioDataStreamHandle(long var1);

    private final native long releaseSynthesizerHandle(long var1);

    private final native long releaseGrammarHandle(long var1);

    private final native long releaseTranslationSynthesisHandle(long var1);

    private final native long releaseConversationTranslatorHandle(long var1);

    private final native long releaseKeywordRecognizerHandle(long var1);

    private final native long releasePronunciationAssessmentConfig(long var1);

    private final native long releaseSpeakerRecognizerHandle(long var1);

    private final native long releaseSpeakerIdentificationModelHandle(long var1);

    private final native long releaseSpeakerRecognitionResultHandle(long var1);

    private final native long releaseSpeakerVerificationModelHandle(long var1);

    private final native long releaseVoiceProfileResultHandle(long var1);

    private final native long releaseVoiceProfileEnrollmentResultHandle(long var1);

    private final native long releaseVoiceProfilePhraseResultHandle(long var1);

    private final native long releaseVoiceProfileHandle(long var1);

    private final native long releaseVoiceProfileClientHandle(long var1);

    private final native long releaseAudioProcessingOptionsHandle(long var1);

    private final native long releaseSpeechRecognitionModelHandle(long var1);
}

