/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.speaker;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.speaker.VoiceProfile;
import com.microsoft.cognitiveservices.speech.speaker.VoiceProfileEnrollmentResult;
import com.microsoft.cognitiveservices.speech.speaker.VoiceProfilePhraseResult;
import com.microsoft.cognitiveservices.speech.speaker.VoiceProfileResult;
import com.microsoft.cognitiveservices.speech.speaker.VoiceProfileType;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class VoiceProfileClient
implements AutoCloseable {
    private SafeHandle voiceProfileClientHandle = null;
    private PropertyCollection propertyHandle = null;
    private boolean disposed = false;

    public VoiceProfileClient(SpeechConfig speechConfig) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.createFromConfig(intRef, speechConfig.getImpl()));
        this.voiceProfileClientHandle = new SafeHandle(intRef.getValue(), SafeHandleType.VoiceProfileClient);
        this.initialize();
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<VoiceProfile> createProfileAsync(final VoiceProfileType voiceProfileType, final String string) {
        return AsyncThreadService.submit(new Callable<VoiceProfile>(){

            @Override
            public VoiceProfile call() {
                IntRef intRef = new IntRef(0L);
                Contracts.throwIfFail(VoiceProfileClient.this.createVoiceProfile(VoiceProfileClient.this.voiceProfileClientHandle, voiceProfileType.getValue(), string, intRef));
                return new VoiceProfile(intRef.getValue());
            }
        });
    }

    public Future<VoiceProfileEnrollmentResult> enrollProfileAsync(final VoiceProfile voiceProfile, final AudioConfig audioConfig) {
        return AsyncThreadService.submit(new Callable<VoiceProfileEnrollmentResult>(){

            @Override
            public VoiceProfileEnrollmentResult call() {
                IntRef intRef = new IntRef(0L);
                Contracts.throwIfFail(VoiceProfileClient.this.enrollVoiceProfile(VoiceProfileClient.this.voiceProfileClientHandle, voiceProfile.getImpl(), audioConfig.getImpl(), intRef));
                return new VoiceProfileEnrollmentResult(intRef.getValue());
            }
        });
    }

    public Future<VoiceProfilePhraseResult> getActivationPhrasesAsync(final VoiceProfileType voiceProfileType, final String string) {
        return AsyncThreadService.submit(new Callable<VoiceProfilePhraseResult>(){

            @Override
            public VoiceProfilePhraseResult call() {
                IntRef intRef = new IntRef(0L);
                Contracts.throwIfFail(VoiceProfileClient.this.getActivationPhrases(VoiceProfileClient.this.voiceProfileClientHandle, voiceProfileType.getValue(), string, intRef));
                return new VoiceProfilePhraseResult(intRef.getValue());
            }
        });
    }

    public Future<VoiceProfileResult> deleteProfileAsync(final VoiceProfile voiceProfile) {
        return AsyncThreadService.submit(new Callable<VoiceProfileResult>(){

            @Override
            public VoiceProfileResult call() {
                IntRef intRef = new IntRef(0L);
                Contracts.throwIfFail(VoiceProfileClient.this.deleteVoiceProfile(VoiceProfileClient.this.voiceProfileClientHandle, voiceProfile.getImpl(), intRef));
                return new VoiceProfileResult(intRef.getValue());
            }
        });
    }

    public Future<VoiceProfileResult> resetProfileAsync(final VoiceProfile voiceProfile) {
        return AsyncThreadService.submit(new Callable<VoiceProfileResult>(){

            @Override
            public VoiceProfileResult call() {
                IntRef intRef = new IntRef(0L);
                Contracts.throwIfFail(VoiceProfileClient.this.resetVoiceProfile(VoiceProfileClient.this.voiceProfileClientHandle, voiceProfile.getImpl(), intRef));
                return new VoiceProfileResult(intRef.getValue());
            }
        });
    }

    public Future<VoiceProfileEnrollmentResult> retrieveEnrollmentResultAsync(final VoiceProfile voiceProfile) {
        return AsyncThreadService.submit(new Callable<VoiceProfileEnrollmentResult>(){

            @Override
            public VoiceProfileEnrollmentResult call() {
                IntRef intRef = new IntRef(0L);
                Contracts.throwIfFail(VoiceProfileClient.this.retrieveEnrollmentResult(VoiceProfileClient.this.voiceProfileClientHandle, voiceProfile.getId(), voiceProfile.getType().getValue(), intRef));
                return new VoiceProfileEnrollmentResult(intRef.getValue());
            }
        });
    }

    public Future<List<VoiceProfile>> getAllProfilesAsync(final VoiceProfileType voiceProfileType) {
        return AsyncThreadService.submit(new Callable<List<VoiceProfile>>(){

            @Override
            public List<VoiceProfile> call() {
                ArrayList<VoiceProfile> arrayList = new ArrayList<VoiceProfile>();
                String string = VoiceProfileClient.this.getProfilesJson(VoiceProfileClient.this.voiceProfileClientHandle, voiceProfileType.getValue());
                if (!string.isEmpty()) {
                    List<String> list = Arrays.asList(string.split("\\|"));
                    for (String string2 : list) {
                        arrayList.add(new VoiceProfile(string2, voiceProfileType));
                    }
                }
                return arrayList;
            }
        });
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.propertyHandle != null) {
            this.propertyHandle.close();
            this.propertyHandle = null;
        }
        if (this.voiceProfileClientHandle != null) {
            this.voiceProfileClientHandle.close();
            this.voiceProfileClientHandle = null;
        }
        AsyncThreadService.shutdown();
        this.disposed = true;
    }

    public SafeHandle getImpl() {
        return this.voiceProfileClientHandle;
    }

    private void initialize() {
        VoiceProfileClient voiceProfileClient = this;
        AsyncThreadService.initialize();
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromHandle(voiceProfileClient.voiceProfileClientHandle, intRef));
        this.propertyHandle = new PropertyCollection(intRef);
    }

    private final native long createFromConfig(IntRef var1, SafeHandle var2);

    private final native long createVoiceProfile(SafeHandle var1, int var2, String var3, IntRef var4);

    private final native String getProfilesJson(SafeHandle var1, int var2);

    private final native long enrollVoiceProfile(SafeHandle var1, SafeHandle var2, SafeHandle var3, IntRef var4);

    private final native long deleteVoiceProfile(SafeHandle var1, SafeHandle var2, IntRef var3);

    private final native long resetVoiceProfile(SafeHandle var1, SafeHandle var2, IntRef var3);

    private final native long retrieveEnrollmentResult(SafeHandle var1, String var2, int var3, IntRef var4);

    private final native long getActivationPhrases(SafeHandle var1, int var2, String var3, IntRef var4);

    private final native long getPropertyBagFromHandle(SafeHandle var1, IntRef var2);
}

