/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.intent;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class LanguageUnderstandingModel {
    private SafeHandle modelHandle = null;

    public static LanguageUnderstandingModel fromEndpoint(String string) {
        Contracts.throwIfNullOrWhitespace(string, "uri");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(LanguageUnderstandingModel.createModelFromUri(intRef, string));
        return new LanguageUnderstandingModel(intRef);
    }

    public static LanguageUnderstandingModel fromAppId(String string) {
        Contracts.throwIfNullOrWhitespace(string, "appId");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(LanguageUnderstandingModel.createModelFromAppId(intRef, string));
        return new LanguageUnderstandingModel(intRef);
    }

    public static LanguageUnderstandingModel fromSubscription(String string, String string2, String string3) {
        Contracts.throwIfNullOrWhitespace(string, "subscriptionKey");
        Contracts.throwIfNullOrWhitespace(string2, "appId");
        Contracts.throwIfNullOrWhitespace(string3, "region");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(LanguageUnderstandingModel.createModelFromSubscription(intRef, string, string2, string3));
        return new LanguageUnderstandingModel(intRef);
    }

    LanguageUnderstandingModel(IntRef intRef) {
        Contracts.throwIfNull(intRef, "model");
        this.modelHandle = new SafeHandle(intRef.getValue(), SafeHandleType.LanguageUnderstandingModel);
    }

    public SafeHandle getImpl() {
        return this.modelHandle;
    }

    private static final native long createModelFromUri(IntRef var0, String var1);

    private static final native long createModelFromAppId(IntRef var0, String var1);

    private static final native long createModelFromSubscription(IntRef var0, String var1, String var2, String var3);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

