/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.intent;

import com.microsoft.cognitiveservices.speech.KeywordRecognitionModel;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.intent.IntentRecognitionCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.intent.IntentRecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.intent.IntentRecognitionResult;
import com.microsoft.cognitiveservices.speech.intent.IntentTrigger;
import com.microsoft.cognitiveservices.speech.intent.LanguageUnderstandingModel;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class IntentRecognizer
extends Recognizer {
    public final EventHandlerImpl<IntentRecognitionEventArgs> recognizing;
    public final EventHandlerImpl<IntentRecognitionEventArgs> recognized;
    public final EventHandlerImpl<IntentRecognitionCanceledEventArgs> canceled;
    static Set<IntentRecognizer> intentRecognizerObjects = Collections.synchronizedSet(new HashSet());
    private PropertyCollection propertyHandle;

    public IntentRecognizer(SpeechConfig speechConfig) {
        super(null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(this.recoHandle, "recoHandle");
        Contracts.throwIfFail(this.createIntentRecognizerFromConfig(this.recoHandle, speechConfig.getImpl(), null));
        this.initialize();
    }

    public IntentRecognizer(SpeechConfig speechConfig, AudioConfig audioConfig) {
        super(audioConfig);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createIntentRecognizerFromConfig(this.recoHandle, speechConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createIntentRecognizerFromConfig(this.recoHandle, speechConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public String getSpeechRecognitionLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_RecoLanguage);
    }

    public void setAuthorizationToken(String string) {
        Contracts.throwIfNullOrWhitespace(string, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, string);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<IntentRecognitionResult> recognizeOnceAsync() {
        final IntentRecognizer intentRecognizer = this;
        return AsyncThreadService.submit(new Callable<IntentRecognitionResult>(){

            @Override
            public IntentRecognitionResult call() {
                final IntentRecognitionResult[] intentRecognitionResultArray = new IntentRecognitionResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        intentRecognitionResultArray[0] = new IntentRecognitionResult(intentRecognizer.recognize());
                    }
                };
                intentRecognizer.doAsyncRecognitionAction(runnable);
                return intentRecognitionResultArray[0];
            }
        });
    }

    public Future<Void> startContinuousRecognitionAsync() {
        final IntentRecognizer intentRecognizer = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        intentRecognizer.startContinuousRecognition(IntentRecognizer.this.recoHandle);
                    }
                };
                intentRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopContinuousRecognitionAsync() {
        final IntentRecognizer intentRecognizer = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        intentRecognizer.stopContinuousRecognition(IntentRecognizer.this.recoHandle);
                    }
                };
                intentRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public void addIntent(String string) {
        Contracts.throwIfNullOrWhitespace(string, "simplePhrase");
        IntentTrigger intentTrigger = IntentTrigger.fromPhrase(string);
        Contracts.throwIfFail(this.addIntent(this.recoHandle, string, intentTrigger.getImpl()));
    }

    public void addIntent(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, "simplePhrase");
        Contracts.throwIfNullOrWhitespace(string2, "intentId");
        IntentTrigger intentTrigger = IntentTrigger.fromPhrase(string);
        Contracts.throwIfFail(this.addIntent(this.recoHandle, string2, intentTrigger.getImpl()));
    }

    public void addIntent(LanguageUnderstandingModel languageUnderstandingModel, String string) {
        Contracts.throwIfNull(languageUnderstandingModel, "model");
        Contracts.throwIfNullOrWhitespace(string, "intentName");
        IntentTrigger intentTrigger = IntentTrigger.fromModel(languageUnderstandingModel.getImpl(), string);
        Contracts.throwIfFail(this.addIntent(this.recoHandle, string, intentTrigger.getImpl()));
    }

    public void addIntent(LanguageUnderstandingModel languageUnderstandingModel, String string, String string2) {
        Contracts.throwIfNull(languageUnderstandingModel, "model");
        Contracts.throwIfNullOrWhitespace(string, "intentName");
        Contracts.throwIfNullOrWhitespace(string2, "intentId");
        IntentTrigger intentTrigger = IntentTrigger.fromModel(languageUnderstandingModel.getImpl(), string);
        Contracts.throwIfFail(this.addIntent(this.recoHandle, string2, intentTrigger.getImpl()));
    }

    public void addAllIntents(LanguageUnderstandingModel languageUnderstandingModel, String string) {
        Contracts.throwIfNull(languageUnderstandingModel, "model");
        Contracts.throwIfNullOrWhitespace(string, "intentId");
        IntentTrigger intentTrigger = IntentTrigger.fromModel(languageUnderstandingModel.getImpl());
        Contracts.throwIfFail(this.addIntent(this.recoHandle, string, intentTrigger.getImpl()));
    }

    public void addAllIntents(LanguageUnderstandingModel languageUnderstandingModel) {
        Contracts.throwIfNull(languageUnderstandingModel, "model");
        IntentTrigger intentTrigger = IntentTrigger.fromModel(languageUnderstandingModel.getImpl());
        Contracts.throwIfFail(this.addIntent(this.recoHandle, null, intentTrigger.getImpl()));
    }

    public Future<Void> startKeywordRecognitionAsync(KeywordRecognitionModel keywordRecognitionModel) {
        Contracts.throwIfNull(keywordRecognitionModel, "model");
        final IntentRecognizer intentRecognizer = this;
        final KeywordRecognitionModel keywordRecognitionModel2 = keywordRecognitionModel;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        intentRecognizer.startKeywordRecognition(IntentRecognizer.this.recoHandle, keywordRecognitionModel2.getImpl());
                    }
                };
                intentRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopKeywordRecognitionAsync() {
        final IntentRecognizer intentRecognizer = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        intentRecognizer.stopKeywordRecognition(IntentRecognizer.this.recoHandle);
                    }
                };
                intentRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    @Override
    protected void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            if (this.recoHandle != null) {
                this.recoHandle.close();
                this.recoHandle = null;
            }
            intentRecognizerObjects.remove(this);
            super.dispose(bl);
        }
    }

    public SafeHandle getRecoImpl() {
        return this.recoHandle;
    }

    private void initialize() {
        final IntentRecognizer intentRecognizer = this;
        this.recognizing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(intentRecognizer);
                Contracts.throwIfFail(IntentRecognizer.this.recognizingSetCallback(intentRecognizer.recoHandle.getValue()));
            }
        });
        this.recognized.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(intentRecognizer);
                Contracts.throwIfFail(IntentRecognizer.this.recognizedSetCallback(intentRecognizer.recoHandle.getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(intentRecognizer);
                Contracts.throwIfFail(IntentRecognizer.this.canceledSetCallback(intentRecognizer.recoHandle.getValue()));
            }
        });
        this.sessionStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(intentRecognizer);
                Contracts.throwIfFail(IntentRecognizer.this.sessionStartedSetCallback(intentRecognizer.recoHandle.getValue()));
            }
        });
        this.sessionStopped.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(intentRecognizer);
                Contracts.throwIfFail(IntentRecognizer.this.sessionStoppedSetCallback(intentRecognizer.recoHandle.getValue()));
            }
        });
        this.speechStartDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(intentRecognizer);
                Contracts.throwIfFail(IntentRecognizer.this.speechStartDetectedSetCallback(intentRecognizer.recoHandle.getValue()));
            }
        });
        this.speechEndDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(intentRecognizer);
                Contracts.throwIfFail(IntentRecognizer.this.speechEndDetectedSetCallback(intentRecognizer.recoHandle.getValue()));
            }
        });
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromRecognizerHandle(intentRecognizer.recoHandle, intRef));
        this.propertyHandle = new PropertyCollection(intRef);
    }

    private void recognizingEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            IntentRecognitionEventArgs intentRecognitionEventArgs = new IntentRecognitionEventArgs(l, true);
            EventHandlerImpl<IntentRecognitionEventArgs> eventHandlerImpl = this.recognizing;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, intentRecognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recognizedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            IntentRecognitionEventArgs intentRecognitionEventArgs = new IntentRecognitionEventArgs(l, true);
            EventHandlerImpl<IntentRecognitionEventArgs> eventHandlerImpl = this.recognized;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, intentRecognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            IntentRecognitionCanceledEventArgs intentRecognitionCanceledEventArgs = new IntentRecognitionCanceledEventArgs(l, true);
            EventHandlerImpl<IntentRecognitionCanceledEventArgs> eventHandlerImpl = this.canceled;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, intentRecognitionCanceledEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final native long createIntentRecognizerFromConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3);

    private final native long addIntent(SafeHandle var1, String var2, SafeHandle var3);
}

