/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioInputStream;
import com.microsoft.cognitiveservices.speech.audio.AudioStreamFormat;
import com.microsoft.cognitiveservices.speech.util.CloseGuard;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class PushAudioInputStream
extends AudioInputStream {
    private CloseGuard cg = new CloseGuard();

    public static PushAudioInputStream create() {
        SafeHandle safeHandle = new SafeHandle(0L, SafeHandleType.AudioInputStream);
        Contracts.throwIfFail(PushAudioInputStream.createPushAudioInputStream(safeHandle, null));
        return new PushAudioInputStream(safeHandle);
    }

    public static PushAudioInputStream create(AudioStreamFormat audioStreamFormat) {
        SafeHandle safeHandle = new SafeHandle(0L, SafeHandleType.AudioInputStream);
        Contracts.throwIfFail(PushAudioInputStream.createPushAudioInputStream(safeHandle, audioStreamFormat.getImpl()));
        return new PushAudioInputStream(safeHandle);
    }

    public void write(byte[] byArray) {
        this.cg.enterUseObject();
        try {
            Contracts.throwIfFail(this.pushAudioInputStreamWrite(this.streamHandle, byArray, byArray.length));
        }
        finally {
            this.cg.exitUseObject();
        }
    }

    @Override
    public void close() {
        this.cg.closeObject();
        if (this.streamHandle != null) {
            Contracts.throwIfFail(this.pushAudioInputStreamClose(this.streamHandle));
        }
        super.close();
    }

    protected PushAudioInputStream(SafeHandle safeHandle) {
        super(safeHandle);
    }

    private static final native long createPushAudioInputStream(SafeHandle var0, SafeHandle var1);

    private final native long pushAudioInputStreamWrite(SafeHandle var1, byte[] var2, int var3);

    private final native long pushAudioInputStreamClose(SafeHandle var1);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

