/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioStreamContainerFormat;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class AudioStreamFormat {
    private SafeHandle formatHandle = null;

    public static AudioStreamFormat getDefaultInputFormat() {
        SafeHandle safeHandle = new SafeHandle(0L, SafeHandleType.AudioStreamFormat);
        Contracts.throwIfFail(AudioStreamFormat.createFromDefaultInput(safeHandle));
        return new AudioStreamFormat(safeHandle);
    }

    public static AudioStreamFormat getWaveFormatPCM(long l, short s, short s2) {
        SafeHandle safeHandle = new SafeHandle(0L, SafeHandleType.AudioStreamFormat);
        Contracts.throwIfFail(AudioStreamFormat.createFromWaveFormatPCM(safeHandle, l, s, s2));
        return new AudioStreamFormat(safeHandle);
    }

    public static AudioStreamFormat getCompressedFormat(AudioStreamContainerFormat audioStreamContainerFormat) {
        SafeHandle safeHandle = new SafeHandle(0L, SafeHandleType.AudioStreamFormat);
        int n = AudioStreamContainerFormat.values()[audioStreamContainerFormat.ordinal()].getValue();
        Contracts.throwIfFail(AudioStreamFormat.createFromCompressedFormat(safeHandle, n));
        return new AudioStreamFormat(safeHandle);
    }

    public void close() {
        if (this.formatHandle != null) {
            this.formatHandle.close();
            this.formatHandle = null;
        }
    }

    AudioStreamFormat(SafeHandle safeHandle) {
        Contracts.throwIfNull(safeHandle, "format");
        this.formatHandle = safeHandle;
    }

    public SafeHandle getImpl() {
        return this.formatHandle;
    }

    private static final native long createFromDefaultInput(SafeHandle var0);

    private static final native long createFromWaveFormatPCM(SafeHandle var0, long var1, short var3, short var4);

    private static final native long createFromCompressedFormat(SafeHandle var0, int var1);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

