/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.ResultReason;
import com.microsoft.cognitiveservices.speech.VoiceInfo;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SynthesisVoicesResult
implements AutoCloseable {
    private String resultId;
    private ResultReason reason;
    private String errorDetails;
    private List<VoiceInfo> voices;
    private PropertyCollection properties;
    private SafeHandle resultHandle = null;

    protected SynthesisVoicesResult(IntRef intRef) {
        IntRef intRef2;
        Contracts.throwIfNull(intRef, "result");
        this.resultHandle = new SafeHandle(intRef.getValue(), SafeHandleType.SynthesisResult);
        IntRef intRef3 = new IntRef(0L);
        Contracts.throwIfFail(this.getVoiceNumber(this.resultHandle, intRef3));
        int n = (int)intRef3.getValue();
        ArrayList<VoiceInfo> arrayList = new ArrayList<VoiceInfo>();
        for (int i = 0; i < n; ++i) {
            intRef2 = new IntRef(0L);
            Contracts.throwIfFail(this.getVoiceInfo(this.resultHandle, i, intRef2));
            arrayList.add(new VoiceInfo(intRef2));
        }
        this.voices = Collections.unmodifiableList(arrayList);
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getResultId(this.resultHandle, stringRef));
        this.resultId = stringRef.getValue();
        Contracts.throwIfFail(this.getResultReason(this.resultHandle, intRef3));
        this.reason = ResultReason.values()[(int)intRef3.getValue()];
        intRef2 = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromResult(this.resultHandle, intRef2));
        this.properties = new PropertyCollection(intRef2);
        this.errorDetails = this.properties.getProperty(PropertyId.CancellationDetails_ReasonDetailedText);
    }

    public List<VoiceInfo> getVoices() {
        return this.voices;
    }

    public String getResultId() {
        return this.resultId;
    }

    public ResultReason getReason() {
        return this.reason;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public PropertyCollection getProperties() {
        return this.properties;
    }

    @Override
    public void close() {
        if (this.resultHandle != null) {
            this.resultHandle.close();
            this.resultHandle = null;
        }
        if (this.properties != null) {
            this.properties.close();
            this.properties = null;
        }
        if (this.voices != null) {
            for (VoiceInfo voiceInfo : this.voices) {
                voiceInfo.close();
            }
            this.voices = null;
        }
    }

    public SafeHandle getImpl() {
        return this.resultHandle;
    }

    private final native long getResultId(SafeHandle var1, StringRef var2);

    private final native long getResultReason(SafeHandle var1, IntRef var2);

    private final native long getPropertyBagFromResult(SafeHandle var1, IntRef var2);

    private final native long getVoiceNumber(SafeHandle var1, IntRef var2);

    private final native long getVoiceInfo(SafeHandle var1, int var2, IntRef var3);
}

