/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.AutoDetectSourceLanguageConfig;
import com.microsoft.cognitiveservices.speech.EmbeddedSpeechConfig;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisBookmarkEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisResult;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisVisemeEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisWordBoundaryEventArgs;
import com.microsoft.cognitiveservices.speech.SynthesisVoicesResult;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class SpeechSynthesizer
implements AutoCloseable {
    private AtomicInteger eventCounter = new AtomicInteger(0);
    public final EventHandlerImpl<SpeechSynthesisEventArgs> SynthesisStarted = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SpeechSynthesisEventArgs> Synthesizing = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SpeechSynthesisEventArgs> SynthesisCompleted = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SpeechSynthesisEventArgs> SynthesisCanceled = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SpeechSynthesisWordBoundaryEventArgs> WordBoundary = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SpeechSynthesisVisemeEventArgs> VisemeReceived = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SpeechSynthesisBookmarkEventArgs> BookmarkReached = new EventHandlerImpl(this.eventCounter);
    private static Set<SpeechSynthesizer> s_speechSynthesizerObjects = Collections.synchronizedSet(new HashSet());
    private SafeHandle synthHandle = null;
    private PropertyCollection propertyHandle;
    private boolean disposed = false;
    private static Integer disposeWaitingTime = 100;
    private final Object synthesizerLock = new Object();
    private int activeAsyncSynthesisCounter = 0;
    private AudioConfig audioOutputKeepAlive = null;

    public SpeechSynthesizer(SpeechConfig speechConfig) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        this.synthHandle = new SafeHandle(0L, SafeHandleType.Synthesizer);
        AudioConfig audioConfig = AudioConfig.fromDefaultSpeakerOutput();
        Contracts.throwIfFail(this.createSpeechSynthesizerFromConfig(this.synthHandle, speechConfig.getImpl(), audioConfig.getImpl()));
        Contracts.throwIfNull(this.synthHandle.getValue(), "synthHandle");
        audioConfig.close();
        this.initialize();
    }

    public SpeechSynthesizer(SpeechConfig speechConfig, AudioConfig audioConfig) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        this.synthHandle = new SafeHandle(0L, SafeHandleType.Synthesizer);
        Contracts.throwIfFail(this.createSpeechSynthesizerFromConfig(this.synthHandle, speechConfig.getImpl(), audioConfig == null ? null : audioConfig.getImpl()));
        Contracts.throwIfNull(this.synthHandle.getValue(), "synthHandle");
        this.audioOutputKeepAlive = audioConfig;
        this.initialize();
    }

    public SpeechSynthesizer(SpeechConfig speechConfig, AutoDetectSourceLanguageConfig autoDetectSourceLanguageConfig, AudioConfig audioConfig) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(autoDetectSourceLanguageConfig, "autoDetectSourceLangConfig");
        this.synthHandle = new SafeHandle(0L, SafeHandleType.Synthesizer);
        Contracts.throwIfFail(this.createSpeechSynthesizerFromAutoDetectSourceLangConfig(this.synthHandle, speechConfig.getImpl(), autoDetectSourceLanguageConfig.getImpl(), audioConfig == null ? null : audioConfig.getImpl()));
        Contracts.throwIfNull(this.synthHandle.getValue(), "synthHandle");
        this.audioOutputKeepAlive = audioConfig;
        this.initialize();
    }

    public SpeechSynthesizer(EmbeddedSpeechConfig embeddedSpeechConfig) {
        this(embeddedSpeechConfig.config);
    }

    public SpeechSynthesizer(EmbeddedSpeechConfig embeddedSpeechConfig, AudioConfig audioConfig) {
        this(embeddedSpeechConfig.config, audioConfig);
    }

    public SpeechSynthesisResult SpeakText(String string) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.speakText(this.synthHandle, string, intRef));
        return new SpeechSynthesisResult(intRef);
    }

    public SpeechSynthesisResult SpeakSsml(String string) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.speakSsml(this.synthHandle, string, intRef));
        return new SpeechSynthesisResult(intRef);
    }

    public Future<SpeechSynthesisResult> SpeakTextAsync(String string) {
        final SpeechSynthesizer speechSynthesizer = this;
        final String string2 = string;
        return AsyncThreadService.submit(new Callable<SpeechSynthesisResult>(){

            @Override
            public SpeechSynthesisResult call() {
                final SpeechSynthesisResult[] speechSynthesisResultArray = new SpeechSynthesisResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IntRef intRef = new IntRef(0L);
                        Contracts.throwIfFail(SpeechSynthesizer.this.speakText(SpeechSynthesizer.this.synthHandle, string2, intRef));
                        speechSynthesisResultArray[0] = new SpeechSynthesisResult(intRef);
                    }
                };
                speechSynthesizer.doAsyncSynthesisAction(runnable);
                return speechSynthesisResultArray[0];
            }
        });
    }

    public Future<SpeechSynthesisResult> SpeakSsmlAsync(String string) {
        final SpeechSynthesizer speechSynthesizer = this;
        final String string2 = string;
        return AsyncThreadService.submit(new Callable<SpeechSynthesisResult>(){

            @Override
            public SpeechSynthesisResult call() {
                final SpeechSynthesisResult[] speechSynthesisResultArray = new SpeechSynthesisResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IntRef intRef = new IntRef(0L);
                        Contracts.throwIfFail(SpeechSynthesizer.this.speakSsml(SpeechSynthesizer.this.synthHandle, string2, intRef));
                        speechSynthesisResultArray[0] = new SpeechSynthesisResult(intRef);
                    }
                };
                speechSynthesizer.doAsyncSynthesisAction(runnable);
                return speechSynthesisResultArray[0];
            }
        });
    }

    public SpeechSynthesisResult StartSpeakingText(String string) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.startSpeakingText(this.synthHandle, string, intRef));
        return new SpeechSynthesisResult(intRef);
    }

    public SpeechSynthesisResult StartSpeakingSsml(String string) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.startSpeakingSsml(this.synthHandle, string, intRef));
        return new SpeechSynthesisResult(intRef);
    }

    public Future<SpeechSynthesisResult> StartSpeakingTextAsync(String string) {
        final SpeechSynthesizer speechSynthesizer = this;
        final String string2 = string;
        return AsyncThreadService.submit(new Callable<SpeechSynthesisResult>(){

            @Override
            public SpeechSynthesisResult call() {
                final SpeechSynthesisResult[] speechSynthesisResultArray = new SpeechSynthesisResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IntRef intRef = new IntRef(0L);
                        Contracts.throwIfFail(SpeechSynthesizer.this.startSpeakingText(SpeechSynthesizer.this.synthHandle, string2, intRef));
                        speechSynthesisResultArray[0] = new SpeechSynthesisResult(intRef);
                    }
                };
                speechSynthesizer.doAsyncSynthesisAction(runnable);
                return speechSynthesisResultArray[0];
            }
        });
    }

    public Future<SpeechSynthesisResult> StartSpeakingSsmlAsync(String string) {
        final SpeechSynthesizer speechSynthesizer = this;
        final String string2 = string;
        return AsyncThreadService.submit(new Callable<SpeechSynthesisResult>(){

            @Override
            public SpeechSynthesisResult call() {
                final SpeechSynthesisResult[] speechSynthesisResultArray = new SpeechSynthesisResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IntRef intRef = new IntRef(0L);
                        Contracts.throwIfFail(SpeechSynthesizer.this.startSpeakingSsml(SpeechSynthesizer.this.synthHandle, string2, intRef));
                        speechSynthesisResultArray[0] = new SpeechSynthesisResult(intRef);
                    }
                };
                speechSynthesizer.doAsyncSynthesisAction(runnable);
                return speechSynthesisResultArray[0];
            }
        });
    }

    public Future<Void> StopSpeakingAsync() {
        final SpeechSynthesizer speechSynthesizer = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        SpeechSynthesizer.this.stopSpeaking(SpeechSynthesizer.this.synthHandle);
                    }
                };
                speechSynthesizer.doAsyncSynthesisAction(runnable);
                return null;
            }
        });
    }

    public Future<SynthesisVoicesResult> getVoicesAsync(String string) {
        final SpeechSynthesizer speechSynthesizer = this;
        final String string2 = string;
        return AsyncThreadService.submit(new Callable<SynthesisVoicesResult>(){

            @Override
            public SynthesisVoicesResult call() {
                final SynthesisVoicesResult[] synthesisVoicesResultArray = new SynthesisVoicesResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IntRef intRef = new IntRef(0L);
                        Contracts.throwIfFail(SpeechSynthesizer.this.getVoices(SpeechSynthesizer.this.synthHandle, string2, intRef));
                        synthesisVoicesResultArray[0] = new SynthesisVoicesResult(intRef);
                    }
                };
                speechSynthesizer.doAsyncSynthesisAction(runnable);
                return synthesisVoicesResultArray[0];
            }
        });
    }

    public Future<SynthesisVoicesResult> getVoicesAsync() {
        return this.getVoicesAsync("");
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public void setAuthorizationToken(String string) {
        Contracts.throwIfNullOrWhitespace(string, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, string);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.synthesizerLock;
        synchronized (object) {
            if (this.activeAsyncSynthesisCounter != 0) {
                try {
                    this.synthesizerLock.wait(disposeWaitingTime.intValue());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.activeAsyncSynthesisCounter != 0) {
                throw new IllegalStateException("Cannot dispose a synthesizer while async synthesis is running. Await async synthesis to avoid unexpected disposals.");
            }
            this.dispose(true);
        }
    }

    public SafeHandle getImpl() {
        return this.synthHandle;
    }

    private void initialize() {
        final SpeechSynthesizer speechSynthesizer = this;
        AsyncThreadService.initialize();
        this.SynthesisStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                s_speechSynthesizerObjects.add(speechSynthesizer);
                Contracts.throwIfFail(SpeechSynthesizer.this.synthesisStartedSetCallback(speechSynthesizer.synthHandle));
            }
        });
        this.Synthesizing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                s_speechSynthesizerObjects.add(speechSynthesizer);
                Contracts.throwIfFail(SpeechSynthesizer.this.synthesizingSetCallback(speechSynthesizer.synthHandle));
            }
        });
        this.SynthesisCompleted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                s_speechSynthesizerObjects.add(speechSynthesizer);
                Contracts.throwIfFail(SpeechSynthesizer.this.synthesisCompletedSetCallback(speechSynthesizer.synthHandle));
            }
        });
        this.SynthesisCanceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                s_speechSynthesizerObjects.add(speechSynthesizer);
                Contracts.throwIfFail(SpeechSynthesizer.this.synthesisCanceledSetCallback(speechSynthesizer.synthHandle));
            }
        });
        this.WordBoundary.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                s_speechSynthesizerObjects.add(speechSynthesizer);
                Contracts.throwIfFail(SpeechSynthesizer.this.wordBoundarySetCallback(speechSynthesizer.synthHandle));
            }
        });
        this.VisemeReceived.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                s_speechSynthesizerObjects.add(speechSynthesizer);
                Contracts.throwIfFail(SpeechSynthesizer.this.visemeReceivedSetCallback(speechSynthesizer.synthHandle));
            }
        });
        this.BookmarkReached.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                s_speechSynthesizerObjects.add(speechSynthesizer);
                Contracts.throwIfFail(SpeechSynthesizer.this.bookmarkReachedSetCallback(speechSynthesizer.synthHandle));
            }
        });
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromSynthesizerHandle(speechSynthesizer.synthHandle, intRef));
        this.propertyHandle = new PropertyCollection(intRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncSynthesisAction(Runnable runnable) {
        Object object = this.synthesizerLock;
        synchronized (object) {
            ++this.activeAsyncSynthesisCounter;
        }
        if (this.disposed) {
            throw new IllegalStateException(this.getClass().getName());
        }
        try {
            runnable.run();
        }
        finally {
            object = this.synthesizerLock;
            synchronized (object) {
                --this.activeAsyncSynthesisCounter;
                this.synthesizerLock.notifyAll();
            }
        }
    }

    private void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            if (this.synthHandle != null) {
                this.synthHandle.close();
                this.synthHandle = null;
            }
            this.audioOutputKeepAlive = null;
            s_speechSynthesizerObjects.remove(this);
            AsyncThreadService.shutdown();
            this.disposed = true;
        }
    }

    private void synthesisStartedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "synthesizer");
            if (this.disposed) {
                return;
            }
            SpeechSynthesisEventArgs speechSynthesisEventArgs = new SpeechSynthesisEventArgs(l);
            EventHandlerImpl<SpeechSynthesisEventArgs> eventHandlerImpl = this.SynthesisStarted;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, speechSynthesisEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void synthesizingEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "synthesizer");
            if (this.disposed) {
                return;
            }
            SpeechSynthesisEventArgs speechSynthesisEventArgs = new SpeechSynthesisEventArgs(l);
            EventHandlerImpl<SpeechSynthesisEventArgs> eventHandlerImpl = this.Synthesizing;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, speechSynthesisEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void synthesisCompletedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "synthesizer");
            if (this.disposed) {
                return;
            }
            SpeechSynthesisEventArgs speechSynthesisEventArgs = new SpeechSynthesisEventArgs(l);
            EventHandlerImpl<SpeechSynthesisEventArgs> eventHandlerImpl = this.SynthesisCompleted;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, speechSynthesisEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void synthesisCanceledEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "synthesizer");
            if (this.disposed) {
                return;
            }
            SpeechSynthesisEventArgs speechSynthesisEventArgs = new SpeechSynthesisEventArgs(l);
            EventHandlerImpl<SpeechSynthesisEventArgs> eventHandlerImpl = this.SynthesisCanceled;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, speechSynthesisEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void wordBoundaryEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "synthesizer");
            if (this.disposed) {
                return;
            }
            SpeechSynthesisWordBoundaryEventArgs speechSynthesisWordBoundaryEventArgs = new SpeechSynthesisWordBoundaryEventArgs(l);
            EventHandlerImpl<SpeechSynthesisWordBoundaryEventArgs> eventHandlerImpl = this.WordBoundary;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, speechSynthesisWordBoundaryEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void visemeReceivedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "synthesizer");
            if (this.disposed) {
                return;
            }
            SpeechSynthesisVisemeEventArgs speechSynthesisVisemeEventArgs = new SpeechSynthesisVisemeEventArgs(l);
            EventHandlerImpl<SpeechSynthesisVisemeEventArgs> eventHandlerImpl = this.VisemeReceived;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, speechSynthesisVisemeEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void bookmarkReachedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "synthesizer");
            if (this.disposed) {
                return;
            }
            SpeechSynthesisBookmarkEventArgs speechSynthesisBookmarkEventArgs = new SpeechSynthesisBookmarkEventArgs(l);
            EventHandlerImpl<SpeechSynthesisBookmarkEventArgs> eventHandlerImpl = this.BookmarkReached;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, speechSynthesisBookmarkEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final native long createSpeechSynthesizerFromConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3);

    private final native long createSpeechSynthesizerFromAutoDetectSourceLangConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3, SafeHandle var4);

    private final native long speakText(SafeHandle var1, String var2, IntRef var3);

    private final native long speakSsml(SafeHandle var1, String var2, IntRef var3);

    private final native long startSpeakingText(SafeHandle var1, String var2, IntRef var3);

    private final native long startSpeakingSsml(SafeHandle var1, String var2, IntRef var3);

    private final native long stopSpeaking(SafeHandle var1);

    private final native long getVoices(SafeHandle var1, String var2, IntRef var3);

    private final native long synthesisStartedSetCallback(SafeHandle var1);

    private final native long synthesizingSetCallback(SafeHandle var1);

    private final native long synthesisCompletedSetCallback(SafeHandle var1);

    private final native long synthesisCanceledSetCallback(SafeHandle var1);

    private final native long wordBoundarySetCallback(SafeHandle var1);

    private final native long visemeReceivedSetCallback(SafeHandle var1);

    private final native long bookmarkReachedSetCallback(SafeHandle var1);

    private final native long getPropertyBagFromSynthesizerHandle(SafeHandle var1, IntRef var2);
}

