/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SpeechRecognitionModel
implements AutoCloseable {
    private String name;
    private List<String> locales;
    private String path;
    private String version;
    private SafeHandle modelInfoHandle = null;

    protected SpeechRecognitionModel(IntRef intRef) {
        Contracts.throwIfNull(intRef, "modelInfo");
        this.modelInfoHandle = new SafeHandle(intRef.getValue(), SafeHandleType.SpeechRecognitionModel);
        this.name = this.getName(this.modelInfoHandle);
        String string = this.getLocalesString(this.modelInfoHandle);
        this.locales = string.isEmpty() ? new ArrayList<String>() : Arrays.asList(string.split("\\|"));
        this.path = this.getPath(this.modelInfoHandle);
        this.version = this.getVersion(this.modelInfoHandle);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLocales() {
        return this.locales;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public void close() {
        if (this.modelInfoHandle != null) {
            this.modelInfoHandle.close();
            this.modelInfoHandle = null;
        }
    }

    public SafeHandle getImpl() {
        return this.modelInfoHandle;
    }

    private final native String getName(SafeHandle var1);

    private final native String getLocalesString(SafeHandle var1);

    private final native String getPath(SafeHandle var1);

    private final native String getVersion(SafeHandle var1);
}

