/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.transcription.ibmwatson;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.fn.Enrichments;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.assetmanager.util.Workflows;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.kernel.mail.SmtpService;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.security.api.DefaultOrganization;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.transcription.api.TranscriptionService;
import org.opencastproject.transcription.api.TranscriptionServiceException;
import org.opencastproject.transcription.persistence.TranscriptionDatabase;
import org.opencastproject.transcription.persistence.TranscriptionDatabaseException;
import org.opencastproject.transcription.persistence.TranscriptionJobControl;
import org.opencastproject.transcription.persistence.TranscriptionProviderControl;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Option;
import org.opencastproject.workflow.api.ConfiguredWorkflow;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowService;
import org.opencastproject.workingfilerepository.api.WorkingFileRepository;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={TranscriptionService.class, IBMWatsonTranscriptionService.class}, property={"service.description=IBM Watson Transcription Service", "provider=ibm.watson"})
public class IBMWatsonTranscriptionService
extends AbstractJobProducer
implements TranscriptionService {
    private static final Logger logger = LoggerFactory.getLogger(IBMWatsonTranscriptionService.class);
    private static final String PROVIDER = "IBM Watson";
    private static final String JOB_TYPE = "org.opencastproject.transcription.ibmwatson";
    static final String TRANSCRIPT_COLLECTION = "transcripts";
    static final String APIKEY = "apikey";
    private static final int CONNECTION_TIMEOUT = 60000;
    private static final int SOCKET_TIMEOUT = 60000;
    public static final String DEFAULT_WF_DEF = "attach-watson-transcripts";
    private static final long DEFAULT_COMPLETION_BUFFER = 600L;
    private static final long DEFAULT_DISPATCH_INTERVAL = 60L;
    private static final long DEFAULT_MAX_PROCESSING_TIME = 7200L;
    private static final String DEFAULT_LANGUAGE = "en";
    private static final int DEFAULT_CLEANUP_RESULTS_DAYS = 7;
    public static final String ADMIN_URL_PROPERTY = "org.opencastproject.admin.ui.url";
    private static final String DIGEST_USER_PROPERTY = "org.opencastproject.security.digest.user";
    private static final String CLUSTER_NAME_PROPERTY = "org.opencastproject.environment.name";
    private String clusterName = "";
    public static final float DEFAULT_START_TRANSCRIPTION_JOB_LOAD = 0.1f;
    public static final String START_TRANSCRIPTION_JOB_LOAD_KEY = "job.load.start.transcription";
    private float jobLoad = 0.1f;
    private ServiceRegistry serviceRegistry;
    private SecurityService securityService;
    private UserDirectoryService userDirectoryService;
    private OrganizationDirectoryService organizationDirectoryService;
    private Workspace workspace;
    private TranscriptionDatabase database;
    private AssetManager assetManager;
    private WorkflowService workflowService;
    private WorkingFileRepository wfr;
    private SmtpService smtpService;
    private Workflows wfUtil;
    private static final String IBM_WATSON_SERVICE_URL = "https://stream.watsonplatform.net/speech-to-text/api";
    private static final String API_VERSION = "v1";
    private static final String REGISTER_CALLBACK = "register_callback";
    private static final String RECOGNITIONS = "recognitions";
    private static final String CALLBACK_PATH = "/transcripts/watson/results";
    public static final String ENABLED_CONFIG = "enabled";
    public static final String IBM_WATSON_SERVICE_URL_CONFIG = "ibm.watson.service.url";
    public static final String IBM_WATSON_USER_CONFIG = "ibm.watson.user";
    public static final String IBM_WATSON_PSW_CONFIG = "ibm.watson.password";
    public static final String IBM_WATSON_API_KEY_CONFIG = "ibm.watson.api.key";
    public static final String IBM_WATSON_MODEL_CONFIG = "ibm.watson.model";
    public static final String WORKFLOW_CONFIG = "workflow";
    public static final String DISPATCH_WORKFLOW_INTERVAL_CONFIG = "workflow.dispatch.interval";
    public static final String COMPLETION_CHECK_BUFFER_CONFIG = "completion.check.buffer";
    public static final String MAX_PROCESSING_TIME_CONFIG = "max.processing.time";
    public static final String NOTIFICATION_EMAIL_CONFIG = "notification.email";
    public static final String CLEANUP_RESULTS_DAYS_CONFIG = "cleanup.results.days";
    public static final String MAX_ATTEMPTS_CONFIG = "max.attempts";
    public static final String RETRY_WORKLFOW_CONFIG = "retry.workflow";
    private boolean enabled = false;
    private String watsonServiceUrl = UrlSupport.concat((String)"https://stream.watsonplatform.net/speech-to-text/api", (String)"v1");
    private String model;
    private String workflowDefinitionId = "attach-watson-transcripts";
    private long workflowDispatchInterval = 60L;
    private long completionCheckBuffer = 600L;
    private long maxProcessingSeconds = 7200L;
    private String toEmailAddress;
    private int cleanupResultDays = 7;
    private String language = "en";
    private int maxAttempts = 1;
    private String retryWfDefId = null;
    private String systemAccount;
    private String serverUrl;
    private String callbackUrl;
    private boolean callbackAlreadyRegistered = false;
    private ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2);
    private AuthCache authCache;
    private CredentialsProvider credentialsProvider;

    public IBMWatsonTranscriptionService() {
        super(JOB_TYPE);
    }

    @Activate
    public void activate(ComponentContext cc) {
        if (cc != null) {
            this.enabled = (Boolean)OsgiUtil.getOptCfgAsBoolean((Dictionary)cc.getProperties(), (String)ENABLED_CONFIG).get();
            if (this.enabled) {
                String psw;
                String user;
                Option keyOpt;
                Option urlOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)IBM_WATSON_SERVICE_URL_CONFIG);
                if (urlOpt.isSome()) {
                    this.watsonServiceUrl = UrlSupport.concat((String)((String)urlOpt.get()), (String)API_VERSION);
                }
                if ((keyOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)IBM_WATSON_API_KEY_CONFIG)).isSome()) {
                    user = APIKEY;
                    psw = (String)keyOpt.get();
                    logger.info("Using transcription service at {} with api key", (Object)this.watsonServiceUrl);
                } else {
                    user = OsgiUtil.getComponentContextProperty((ComponentContext)cc, (String)IBM_WATSON_USER_CONFIG);
                    psw = OsgiUtil.getComponentContextProperty((ComponentContext)cc, (String)IBM_WATSON_PSW_CONFIG);
                    logger.info("Using transcription service at {} with username {}", (Object)this.watsonServiceUrl, (Object)user);
                }
                try {
                    URI uri = new URI(this.watsonServiceUrl);
                    HttpHost targetHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
                    this.credentialsProvider = new BasicCredentialsProvider();
                    this.credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, psw));
                    this.authCache = new BasicAuthCache();
                    this.authCache.put(targetHost, (AuthScheme)new BasicScheme());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Watson STT service url is not valid: " + this.watsonServiceUrl, e);
                }
                Option modelOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)IBM_WATSON_MODEL_CONFIG);
                if (modelOpt.isSome()) {
                    this.model = (String)modelOpt.get();
                    this.language = StringUtils.substringBefore((String)this.model, (String)"-");
                    logger.info("Model is {}", (Object)this.model);
                } else {
                    logger.info("Default model will be used");
                }
                Option wfOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)WORKFLOW_CONFIG);
                if (wfOpt.isSome()) {
                    this.workflowDefinitionId = (String)wfOpt.get();
                }
                logger.info("Workflow definition is {}", (Object)this.workflowDefinitionId);
                Option intervalOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)DISPATCH_WORKFLOW_INTERVAL_CONFIG);
                if (intervalOpt.isSome()) {
                    try {
                        this.workflowDispatchInterval = Long.parseLong((String)intervalOpt.get());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                logger.info("Workflow dispatch interval is {} seconds", (Object)this.workflowDispatchInterval);
                Option bufferOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)COMPLETION_CHECK_BUFFER_CONFIG);
                if (bufferOpt.isSome()) {
                    try {
                        this.completionCheckBuffer = Long.parseLong((String)bufferOpt.get());
                    }
                    catch (NumberFormatException e) {
                        logger.warn("Invalid configuration for {} : {}. Default used instead: {}", new Object[]{COMPLETION_CHECK_BUFFER_CONFIG, bufferOpt.get(), this.completionCheckBuffer});
                    }
                }
                logger.info("Completion check buffer is {} seconds", (Object)this.completionCheckBuffer);
                Option maxProcessingOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)MAX_PROCESSING_TIME_CONFIG);
                if (maxProcessingOpt.isSome()) {
                    try {
                        this.maxProcessingSeconds = Long.parseLong((String)maxProcessingOpt.get());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                logger.info("Maximum time a job is checked after it should have ended is {} seconds", (Object)this.maxProcessingSeconds);
                Option cleaupOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)CLEANUP_RESULTS_DAYS_CONFIG);
                if (cleaupOpt.isSome()) {
                    try {
                        this.cleanupResultDays = Integer.parseInt((String)cleaupOpt.get());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                logger.info("Cleanup result files after {} days", (Object)this.cleanupResultDays);
                Option maxAttemptsOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)MAX_ATTEMPTS_CONFIG);
                if (maxAttemptsOpt.isSome()) {
                    try {
                        this.maxAttempts = Integer.parseInt((String)maxAttemptsOpt.get());
                        this.retryWfDefId = OsgiUtil.getComponentContextProperty((ComponentContext)cc, (String)RETRY_WORKLFOW_CONFIG);
                    }
                    catch (NumberFormatException e) {
                        logger.warn("Invalid configuration for {} : {}. Default used instead: no retries", (Object)MAX_ATTEMPTS_CONFIG, maxAttemptsOpt.get());
                    }
                } else {
                    logger.info("No retries in case of errors");
                }
                this.serverUrl = OsgiUtil.getContextProperty((ComponentContext)cc, (String)"org.opencastproject.server.url");
                this.systemAccount = OsgiUtil.getContextProperty((ComponentContext)cc, (String)DIGEST_USER_PROPERTY);
                this.jobLoad = LoadUtil.getConfiguredLoadValue((Dictionary)cc.getProperties(), (String)START_TRANSCRIPTION_JOB_LOAD_KEY, (Float)Float.valueOf(0.1f), (ServiceRegistry)this.serviceRegistry);
                this.scheduledExecutor.scheduleWithFixedDelay(new WorkflowDispatcher(), 120L, this.workflowDispatchInterval, TimeUnit.SECONDS);
                this.scheduledExecutor.scheduleWithFixedDelay(new ResultsFileCleanup(), 1L, 1L, TimeUnit.DAYS);
                Option optTo = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)NOTIFICATION_EMAIL_CONFIG);
                if (optTo.isSome()) {
                    this.toEmailAddress = (String)optTo.get();
                } else {
                    optTo = OsgiUtil.getOptContextProperty((ComponentContext)cc, (String)"org.opencastproject.admin.email");
                    if (optTo.isSome()) {
                        this.toEmailAddress = (String)optTo.get();
                    }
                }
                if (this.toEmailAddress != null) {
                    logger.info("Notification email set to {}", (Object)this.toEmailAddress);
                } else {
                    logger.warn("Email notification disabled");
                }
                Option optCluster = OsgiUtil.getOptContextProperty((ComponentContext)cc, (String)CLUSTER_NAME_PROPERTY);
                if (optCluster.isSome()) {
                    this.clusterName = (String)optCluster.get();
                }
                logger.info("Environment name is {}", (Object)this.clusterName);
                logger.info("Activated!");
            } else {
                logger.info("Service disabled. If you want to enable it, please update the service configuration.");
            }
        } else {
            throw new IllegalArgumentException("Missing component context");
        }
    }

    public Job startTranscription(String mpId, Track track) throws TranscriptionServiceException {
        if (!this.enabled) {
            throw new TranscriptionServiceException("This service is disabled. If you want to enable it, please update the service configuration.");
        }
        try {
            return this.serviceRegistry.createJob(JOB_TYPE, Operation.StartTranscription.name(), Arrays.asList(mpId, MediaPackageElementParser.getAsXml((MediaPackageElement)track)), Float.valueOf(this.jobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new TranscriptionServiceException("Unable to create a job", (Throwable)e);
        }
        catch (MediaPackageException e) {
            throw new TranscriptionServiceException("Invalid track " + track.toString(), (Throwable)e);
        }
    }

    public Job startTranscription(String mpId, Track track, String ... args) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void transcriptionDone(String mpId, Object obj) throws TranscriptionServiceException {
        JSONObject jsonObj = null;
        String jobId = null;
        try {
            String error;
            JSONArray resultsArray;
            jsonObj = (JSONObject)obj;
            jobId = (String)jsonObj.get((Object)"id");
            if (jsonObj.get((Object)"results") instanceof JSONArray && (resultsArray = (JSONArray)jsonObj.get((Object)"results")) != null && resultsArray.size() > 0 && !StringUtils.isEmpty((CharSequence)(error = (String)((JSONObject)resultsArray.get(0)).get((Object)"error")))) {
                this.retryOrError(jobId, mpId, String.format("Transcription completed with error for mpId %s, jobId %s: %s", mpId, jobId, error));
                return;
            }
            logger.info("Transcription done for mpId {}, jobId {}", (Object)mpId, (Object)jobId);
            this.database.updateJobControl(jobId, TranscriptionJobControl.Status.TranscriptionComplete.name());
            if (jsonObj.get((Object)"results") != null) {
                this.saveResults(jobId, jsonObj);
            }
        }
        catch (IOException e) {
            logger.warn("Could not save transcription results file for mpId {}, jobId {}: {}", new Object[]{mpId, jobId, jsonObj == null ? "null" : jsonObj.toJSONString()});
            throw new TranscriptionServiceException("Could not save transcription results file", (Throwable)e);
        }
        catch (TranscriptionDatabaseException e) {
            logger.warn("Error when updating state in database for mpId {}, jobId {}", (Object)mpId, jobId);
            throw new TranscriptionServiceException("Could not update transcription job control db", (Throwable)e);
        }
    }

    public void transcriptionError(String mpId, Object obj) throws TranscriptionServiceException {
        JSONObject jsonObj = (JSONObject)obj;
        String jobId = (String)jsonObj.get((Object)"id");
        try {
            this.retryOrError(jobId, mpId, String.format("Transcription error for media package %s, job id %s", mpId, jobId));
        }
        catch (TranscriptionDatabaseException e) {
            throw new TranscriptionServiceException("Error when updating job state.", (Throwable)e);
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public Map<String, Object> getReturnValues(String mpId, String jobId) throws TranscriptionServiceException {
        throw new TranscriptionServiceException("Method not implemented");
    }

    protected String process(Job job) throws Exception {
        Operation op = null;
        String operation = job.getOperation();
        List arguments = job.getArguments();
        String result = "";
        op = Operation.valueOf(operation);
        switch (op) {
            case StartTranscription: {
                String mpId = (String)arguments.get(0);
                Track track = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(1)));
                this.createRecognitionsJob(mpId, track);
                break;
            }
            default: {
                throw new IllegalStateException("Don't know how to handle operation '" + operation + "'");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void registerCallback() throws TranscriptionServiceException {
        if (this.callbackAlreadyRegistered) {
            return;
        }
        Organization org = this.securityService.getOrganization();
        String adminUrl = StringUtils.trimToNull((String)((String)org.getProperties().get(ADMIN_URL_PROPERTY)));
        this.callbackUrl = adminUrl != null ? adminUrl + CALLBACK_PATH : this.serverUrl + CALLBACK_PATH;
        logger.info("Callback url is {}", (Object)this.callbackUrl);
        CloseableHttpClient httpClient = this.makeHttpClient();
        HttpPost httpPost = new HttpPost(UrlSupport.concat((String)this.watsonServiceUrl, (String)REGISTER_CALLBACK) + String.format("?callback_url=%s", this.callbackUrl));
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider(this.credentialsProvider);
        context.setAuthCache(this.authCache);
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpPost, (HttpContext)context);
            int code = response.getStatusLine().getStatusCode();
            switch (code) {
                case 200: {
                    logger.info("Callback url: {} had already already been registered", (Object)this.callbackUrl);
                    this.callbackAlreadyRegistered = true;
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    return;
                }
                case 201: {
                    logger.info("Callback url: {} has been successfully registered", (Object)this.callbackUrl);
                    this.callbackAlreadyRegistered = true;
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    return;
                }
                case 400: {
                    logger.warn("Callback url {} could not be verified, status: {}", (Object)this.callbackUrl, (Object)code);
                    return;
                }
                case 503: {
                    logger.warn("Service unavailable when registering callback url {} status: {}", (Object)this.callbackUrl, (Object)code);
                    return;
                }
                default: {
                    logger.warn("Unknown status when registering callback url {}, status: {}", (Object)this.callbackUrl, (Object)code);
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.warn("Exception when calling the the register callback endpoint", (Throwable)e);
            return;
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Exception decompiling
     */
    void createRecognitionsJob(String mpId, Track track) throws TranscriptionServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CASE]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    String getAndSaveJobResults(String jobId) throws TranscriptionServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CASE]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void saveResults(String jobId, JSONObject jsonObj) throws IOException {
        if (jsonObj.get((Object)"results") != null) {
            this.workspace.putInCollection(TRANSCRIPT_COLLECTION, jobId + ".json", (InputStream)new ByteArrayInputStream(jsonObj.toJSONString().getBytes()));
        }
    }

    public MediaPackageElement getGeneratedTranscription(String mpId, String jobId, MediaPackageElement.Type type) throws TranscriptionServiceException {
        try {
            if (jobId == null || "null".equals(jobId)) {
                jobId = null;
                for (TranscriptionJobControl jc : this.database.findByMediaPackage(mpId)) {
                    if (!TranscriptionJobControl.Status.Closed.name().equals(jc.getStatus()) && !TranscriptionJobControl.Status.TranscriptionComplete.name().equals(jc.getStatus())) continue;
                    jobId = jc.getTranscriptionJobId();
                }
            }
            if (jobId == null) {
                throw new TranscriptionServiceException("No completed or closed transcription job found in database for media package " + mpId);
            }
            URI uri = this.workspace.getCollectionURI(TRANSCRIPT_COLLECTION, jobId + ".json");
            try {
                this.workspace.get(uri);
            }
            catch (Exception e) {
                this.getAndSaveJobResults(jobId);
            }
            MediaPackageElementBuilder builder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
            return builder.elementFromURI(uri, type, new MediaPackageElementFlavor("captions", "ibm-watson-json"));
        }
        catch (TranscriptionDatabaseException e) {
            throw new TranscriptionServiceException("Job id not informed and could not find transcription", (Throwable)e);
        }
    }

    protected CloseableHttpClient makeHttpClient() {
        RequestConfig reqConfig = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).setConnectionRequestTimeout(60000).build();
        return HttpClients.custom().setDefaultRequestConfig(reqConfig).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(3, true)).build();
    }

    protected void retryOrError(String jobId, String mpId, String errorMsg) throws TranscriptionDatabaseException {
        logger.warn(errorMsg);
        TranscriptionJobControl jc = this.database.findByJob(jobId);
        String trackId = jc.getTrackId();
        int attempts = this.database.findByMediaPackageTrackAndStatus(mpId, trackId, new String[]{TranscriptionJobControl.Status.Error.name(), TranscriptionJobControl.Status.InProgress.name(), TranscriptionJobControl.Status.Canceled.name()}).size();
        if (attempts < this.maxAttempts) {
            this.database.updateJobControl(jobId, TranscriptionJobControl.Status.Retry.name());
            logger.info("Will retry transcription for media package {}, track {}", (Object)mpId, (Object)trackId);
        } else {
            this.database.updateJobControl(jobId, TranscriptionJobControl.Status.Error.name());
            logger.error("{} transcription attempts exceeded maximum of {} for media package {}, track {}.", new Object[]{attempts, this.maxAttempts, mpId, trackId});
            this.sendEmail("Transcription ERROR", String.format(errorMsg, mpId, jobId));
        }
    }

    private void sendEmail(String subject, String body) {
        if (this.toEmailAddress == null) {
            logger.info("Skipping sending email notification. Message is {}.", (Object)body);
            return;
        }
        try {
            logger.debug("Sending e-mail notification to {}", (Object)this.toEmailAddress);
            this.smtpService.send(this.toEmailAddress, String.format("%s (%s)", subject, this.clusterName), body);
            logger.info("Sent e-mail notification to {}", (Object)this.toEmailAddress);
        }
        catch (Exception e) {
            logger.error("Could not send email: {}\n{}", new Object[]{subject, body, e});
        }
    }

    public boolean isCallbackAlreadyRegistered() {
        return this.callbackAlreadyRegistered;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Reference
    public void setSmtpService(SmtpService service) {
        this.smtpService = service;
    }

    @Reference
    public void setWorkspace(Workspace ws) {
        this.workspace = ws;
    }

    @Reference
    public void setWorkingFileRepository(WorkingFileRepository wfr) {
        this.wfr = wfr;
    }

    @Reference
    public void setDatabase(TranscriptionDatabase service) {
        this.database = service;
    }

    @Reference
    public void setAssetManager(AssetManager service) {
        this.assetManager = service;
    }

    @Reference
    public void setWorkflowService(WorkflowService service) {
        this.workflowService = service;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    void setWfUtil(Workflows wfUtil) {
        this.wfUtil = wfUtil;
    }

    private String startWorkflow(String mpId, String wfDefId, Map<String, String> params) {
        DefaultOrganization defaultOrg = new DefaultOrganization();
        this.securityService.setOrganization((Organization)defaultOrg);
        this.securityService.setUser(SecurityUtil.createSystemUser((String)this.systemAccount, (Organization)defaultOrg));
        AQueryBuilder q = this.assetManager.createQuery();
        AResult r = q.select(new Target[]{q.snapshot()}).where(q.mediaPackageId(mpId).and(q.version().isLatest())).run();
        if (r.getSize() == 0L) {
            logger.warn("Media package {} has not been archived yet.", (Object)mpId);
            return null;
        }
        String org = ((Snapshot)Enrichments.enrich((AResult)r).getSnapshots().stream().findFirst().get()).getOrganizationId();
        Organization organization = null;
        try {
            organization = this.organizationDirectoryService.getOrganization(org);
            if (organization == null) {
                logger.warn("Media package {} has an unknown organization {}.", (Object)mpId, (Object)org);
                return null;
            }
        }
        catch (NotFoundException e) {
            logger.warn("Organization {} not found for media package {}.", (Object)org, (Object)mpId);
            return null;
        }
        this.securityService.setOrganization(organization);
        try {
            WorkflowDefinition wfDef = this.workflowService.getWorkflowDefinitionById(wfDefId);
            Workflows workflows = this.wfUtil != null ? this.wfUtil : new Workflows(this.assetManager, this.workflowService);
            HashSet<String> mpIds = new HashSet<String>();
            mpIds.add(mpId);
            List wfList = workflows.applyWorkflowToLatestVersion(mpIds, ConfiguredWorkflow.workflow((WorkflowDefinition)wfDef, params)).toList();
            return wfList.size() > 0 ? Long.toString(((WorkflowInstance)wfList.get(0)).getId()) : null;
        }
        catch (NotFoundException | WorkflowDatabaseException e) {
            logger.warn("Could not get workflow definition: {}", (Object)wfDefId);
            return null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    class ResultsFileCleanup
    implements Runnable {
        ResultsFileCleanup() {
        }

        @Override
        public void run() {
            logger.info("ResultsFileCleanup waking up...");
            try {
                IBMWatsonTranscriptionService.this.wfr.cleanupOldFilesFromCollection(IBMWatsonTranscriptionService.TRANSCRIPT_COLLECTION, (long)IBMWatsonTranscriptionService.this.cleanupResultDays);
            }
            catch (IOException e) {
                logger.warn("Could not cleanup old transcript results files", (Throwable)e);
            }
        }
    }

    class WorkflowDispatcher
    implements Runnable {
        WorkflowDispatcher() {
        }

        @Override
        public void run() {
            logger.debug("WorkflowDispatcher waking up...");
            try {
                TranscriptionProviderControl providerInfo = IBMWatsonTranscriptionService.this.database.findIdByProvider(IBMWatsonTranscriptionService.PROVIDER);
                if (providerInfo == null) {
                    logger.warn("No provider entry for {}", (Object)IBMWatsonTranscriptionService.PROVIDER);
                    return;
                }
                long providerId = providerInfo.getId();
                List jobs = IBMWatsonTranscriptionService.this.database.findByStatus(new String[]{TranscriptionJobControl.Status.InProgress.name(), TranscriptionJobControl.Status.TranscriptionComplete.name()});
                for (TranscriptionJobControl j : jobs) {
                    String jobId;
                    String mpId;
                    block15: {
                        if (j.getProviderId() != providerId) continue;
                        mpId = j.getMediaPackageId();
                        jobId = j.getTranscriptionJobId();
                        if (TranscriptionJobControl.Status.InProgress.name().equals(j.getStatus())) {
                            if (j.getDateCreated().getTime() + j.getTrackDuration() + IBMWatsonTranscriptionService.this.completionCheckBuffer * 1000L >= System.currentTimeMillis()) continue;
                            try {
                                String jobStatus = IBMWatsonTranscriptionService.this.getAndSaveJobResults(jobId);
                                if ("failed".equals(jobStatus)) {
                                    IBMWatsonTranscriptionService.this.retryOrError(jobId, mpId, String.format("Transcription job failed for mpId %s, jobId %s", mpId, jobId));
                                    continue;
                                }
                                if ("processing".equals(jobStatus) || "waiting".equals(jobStatus)) {
                                    if (j.getDateCreated().getTime() + j.getTrackDuration() + (IBMWatsonTranscriptionService.this.completionCheckBuffer + IBMWatsonTranscriptionService.this.maxProcessingSeconds) * 1000L >= System.currentTimeMillis()) continue;
                                    IBMWatsonTranscriptionService.this.retryOrError(jobId, mpId, String.format("Transcription job was in waiting or processing state for too long (media package %s, job id %s)", mpId, jobId));
                                }
                                break block15;
                            }
                            catch (TranscriptionServiceException e) {
                                if (e.getCode() != 404) continue;
                                IBMWatsonTranscriptionService.this.database.updateJobControl(jobId, TranscriptionJobControl.Status.Canceled.name());
                                IBMWatsonTranscriptionService.this.sendEmail("Transcription ERROR", String.format("Transcription job was not found (media package %s, job id %s).", mpId, jobId));
                            }
                            continue;
                        }
                    }
                    try {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("transcriptionJobId", jobId);
                        String wfId = IBMWatsonTranscriptionService.this.startWorkflow(mpId, IBMWatsonTranscriptionService.this.workflowDefinitionId, params);
                        if (wfId == null) {
                            logger.warn("Attach transcription workflow could NOT be scheduled for mp {}, watson job {}", (Object)mpId, (Object)jobId);
                            continue;
                        }
                        IBMWatsonTranscriptionService.this.database.updateJobControl(jobId, TranscriptionJobControl.Status.Closed.name());
                        logger.info("Attach transcription workflow {} scheduled for mp {}, watson job {}", new Object[]{wfId, mpId, jobId});
                    }
                    catch (Exception e) {
                        logger.warn("Attach transcription workflow could NOT be scheduled for media package {}, watson job {}, {}: {}", new Object[]{mpId, jobId, e.getClass().getName(), e.getMessage()});
                    }
                }
                if (IBMWatsonTranscriptionService.this.maxAttempts > 1) {
                    jobs = IBMWatsonTranscriptionService.this.database.findByStatus(new String[]{TranscriptionJobControl.Status.Retry.name()});
                    HashMap<String, String> params = new HashMap<String, String>();
                    for (TranscriptionJobControl j : jobs) {
                        String mpId = j.getMediaPackageId();
                        String wfId = IBMWatsonTranscriptionService.this.startWorkflow(mpId, IBMWatsonTranscriptionService.this.retryWfDefId, params);
                        String jobId = j.getTranscriptionJobId();
                        if (wfId == null) {
                            logger.warn("Retry transcription workflow could NOT be scheduled for mp {}, watson job {}. Will try again next time.", (Object)mpId, (Object)jobId);
                            continue;
                        }
                        logger.info("Retry transcription workflow {} scheduled for mp {}.", (Object)wfId, (Object)mpId);
                        IBMWatsonTranscriptionService.this.database.updateJobControl(jobId, TranscriptionJobControl.Status.Error.name());
                    }
                }
            }
            catch (TranscriptionDatabaseException e) {
                logger.warn("Could not read/update transcription job control database.", (Throwable)e);
            }
        }
    }

    private static enum Operation {
        StartTranscription;

    }

    public static interface RecognitionJobStatus {
        public static final String COMPLETED = "completed";
        public static final String FAILED = "failed";
        public static final String PROCESSING = "processing";
        public static final String WAITING = "waiting";
    }

    public static interface JobEvent {
        public static final String COMPLETED_WITH_RESULTS = "recognitions.completed_with_results";
        public static final String FAILED = "recognitions.failed";
    }
}

