/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.timelinepreviews.endpoint;

import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.timelinepreviews.api.TimelinePreviewsException;
import org.opencastproject.timelinepreviews.api.TimelinePreviewsService;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="TimelinePreviewsEndpoint", title="Timeline Previews Service REST Endpoint", abstractText="This service generates timeline preview images from media files that contain a video.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={TimelinePreviewsRestEndpoint.class}, property={"service.description=Timeline previews REST Endpoint", "opencast.service.type=org.opencastproject.timelinepreviews", "opencast.service.path=/timelinepreviews", "opencast.service.jobproducer=true"})
public class TimelinePreviewsRestEndpoint
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(TimelinePreviewsRestEndpoint.class);
    protected String docs;
    protected TimelinePreviewsService service;
    protected ServiceRegistry serviceRegistry = null;

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    protected void setTimelinePreviewsService(TimelinePreviewsService timelinePreviewsService) {
        this.service = timelinePreviewsService;
    }

    @POST
    @Path(value="/create")
    @Produces(value={"text/xml"})
    @RestQuery(name="create", description="Create preview images from the given track.", restParameters={@RestParameter(description="The track to generate timeline preview images for.", isRequired=true, name="track", type=RestParameter.Type.FILE), @RestParameter(description="The number of timeline preview images to generate.", isRequired=true, name="imageCount", type=RestParameter.Type.INTEGER)}, responses={@RestResponse(description="Timeline previews job successfully created", responseCode=200), @RestResponse(description="The given track can't be parsed.", responseCode=400), @RestResponse(description="Internal server error.", responseCode=500)}, returnDescription="The job ID to use when polling for the resulting media package attachment, that contains the generated timeline preview images.")
    public Response createTimelinePreviews(@FormParam(value="track") String trackAsXml, @FormParam(value="imageCount") int imageCount) throws Exception {
        if (StringUtils.isBlank((CharSequence)trackAsXml)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"track must not be null").build();
        }
        MediaPackageElement sourceTrack = MediaPackageElementParser.getFromXml((String)trackAsXml);
        if (!Track.TYPE.equals((Object)sourceTrack.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"mediapackage element must be of type track").build();
        }
        try {
            Job job = this.service.createTimelinePreviewImages((Track)sourceTrack, imageCount);
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (TimelinePreviewsException e) {
            logger.warn("Generation of timeline preview images failed: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="docs")
    public String getDocs() {
        return this.docs;
    }

    public JobProducer getService() {
        if (this.service instanceof JobProducer) {
            return (JobProducer)this.service;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

