/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.statistics.remote;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.ws.rs.Path;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.codehaus.jettison.json.JSONException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.statistics.api.DataResolution;
import org.opencastproject.statistics.api.ResourceType;
import org.opencastproject.statistics.api.StatisticsProvider;
import org.opencastproject.statistics.api.StatisticsService;
import org.opencastproject.statistics.api.TimeSeries;
import org.opencastproject.statistics.api.TimeSeriesProvider;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Path(value="/")
@RestService(name="statisticsservice", title="Statistics Service Remote", abstractText="This service provides statistics.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={StatisticsService.class}, property={"service.description=Statistics Remote Service Proxy", "opencast.service.type=org.opencastproject.statistics", "opencast.service.path=/statistics", "opencast.service.publish=false"})
public class StatisticsServiceRemoteImpl
extends RemoteBase
implements StatisticsService {
    private static final JSONParser jsonParser = new JSONParser();

    public StatisticsServiceRemoteImpl() {
        super("org.opencastproject.statistics");
    }

    public Set<StatisticsProvider> getProviders() {
        HttpGet get = new HttpGet("providers.json");
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200});
        try {
            if (response != null) {
                Set<StatisticsProvider> set = this.jsonToProviders(EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8));
                return set;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new RuntimeException("Unable to get providers from remote service");
    }

    public Set<StatisticsProvider> getProviders(ResourceType resourceType) {
        return this.getProviders().stream().filter(p -> p.getResourceType().equals((Object)resourceType)).collect(Collectors.toSet());
    }

    public Optional<StatisticsProvider> getProvider(String providerId) {
        return this.getProviders().stream().filter(p -> p.getId().equals(providerId)).findAny();
    }

    public TimeSeries getTimeSeriesData(StatisticsProvider provider, String resourceId, Instant from, Instant to, DataResolution resolution, ZoneId zoneId) {
        ArrayList<BasicNameValuePair> queryStringParams = new ArrayList<BasicNameValuePair>();
        queryStringParams.add(new BasicNameValuePair("resourceId", resourceId));
        queryStringParams.add(new BasicNameValuePair("from", from.toString()));
        queryStringParams.add(new BasicNameValuePair("to", to.toString()));
        queryStringParams.add(new BasicNameValuePair("resolution", resolution.name()));
        queryStringParams.add(new BasicNameValuePair("zoneId", zoneId.getId()));
        HttpGet get = new HttpGet("timeseries/" + provider.getId() + ".json?" + URLEncodedUtils.format(queryStringParams, (Charset)StandardCharsets.UTF_8));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200});
        try {
            if (response != null) {
                TimeSeries timeSeries = this.jsonToTimeSeries(EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8));
                return timeSeries;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new RuntimeException("Unable to get time series data from remote service");
    }

    public void writeDuration(String organizationId, String measurementName, String retentionPolicy, String organizationIdResourceName, String fieldName, TimeUnit temporalResolution, Duration duration) {
        ArrayList<BasicNameValuePair> queryStringParams = new ArrayList<BasicNameValuePair>();
        queryStringParams.add(new BasicNameValuePair("organizationId", organizationId));
        queryStringParams.add(new BasicNameValuePair("measurementName", measurementName));
        queryStringParams.add(new BasicNameValuePair("retentionPolicy", retentionPolicy));
        queryStringParams.add(new BasicNameValuePair("organizationIdResourceName", organizationIdResourceName));
        queryStringParams.add(new BasicNameValuePair("fieldName", fieldName));
        queryStringParams.add(new BasicNameValuePair("temporalResolution", temporalResolution.toString()));
        queryStringParams.add(new BasicNameValuePair("duration", duration.toString()));
        HttpGet get = new HttpGet("/writeDuration?" + URLEncodedUtils.format(queryStringParams, (Charset)StandardCharsets.UTF_8));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200});
        this.closeConnection(response);
        throw new RuntimeException("Unable to get time series data from remote service");
    }

    private TimeSeries jsonToTimeSeries(String json) throws ParseException {
        JSONObject jsonObject = (JSONObject)jsonParser.parse(json);
        JSONArray labelsJson = (JSONArray)jsonObject.get((Object)"labels");
        JSONArray valuesJson = (JSONArray)jsonObject.get((Object)"values");
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < labelsJson.size(); ++i) {
            labels.add((String)labelsJson.get(i));
            values.add((Double)valuesJson.get(i));
        }
        return new TimeSeries(labels, values, (Double)jsonObject.getOrDefault((Object)"total", null));
    }

    private Set<StatisticsProvider> jsonToProviders(String json) throws ParseException, JSONException {
        JSONArray providersJson = (JSONArray)jsonParser.parse(json);
        HashSet<StatisticsProvider> providers = new HashSet<StatisticsProvider>();
        for (Object object : providersJson) {
            JSONObject jsonObject = (JSONObject)object;
            final String idJson = (String)jsonObject.get((Object)"id");
            final String titleJson = (String)jsonObject.get((Object)"title");
            final String descriptionJson = (String)jsonObject.get((Object)"description");
            final String resourceTypeJson = (String)jsonObject.get((Object)"resourceType");
            if (jsonObject.containsKey((Object)"dataResolutions")) {
                final JSONArray resolutionsJson = (JSONArray)jsonObject.get((Object)"dataResolutions");
                providers.add((StatisticsProvider)new TimeSeriesProvider(){

                    public String getId() {
                        return idJson;
                    }

                    public ResourceType getResourceType() {
                        return ResourceType.valueOf((String)resourceTypeJson);
                    }

                    public String getTitle() {
                        return titleJson;
                    }

                    public String getDescription() {
                        return descriptionJson;
                    }

                    public TimeSeries getValues(String resourceId, Instant from, Instant to, DataResolution resolution, ZoneId zoneId) {
                        throw new IllegalStateException("This method should never get called");
                    }

                    public Set<DataResolution> getDataResolutions() {
                        HashSet<DataResolution> result = new HashSet<DataResolution>();
                        for (Object obj : resolutionsJson) {
                            result.add(DataResolution.valueOf((String)((String)obj)));
                        }
                        return result;
                    }
                });
                continue;
            }
            providers.add(new StatisticsProvider(){

                public String getId() {
                    return idJson;
                }

                public ResourceType getResourceType() {
                    return ResourceType.valueOf((String)resourceTypeJson);
                }

                public String getTitle() {
                    return titleJson;
                }

                public String getDescription() {
                    return descriptionJson;
                }
            });
        }
        return providers;
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

