/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.statistics.provider.influx.provider;

import java.net.ConnectException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.influxdb.InfluxDBIOException;
import org.influxdb.dto.BoundParameterQuery;
import org.influxdb.dto.QueryResult;
import org.opencastproject.statistics.api.DataResolution;
import org.opencastproject.statistics.api.ResourceType;
import org.opencastproject.statistics.api.TimeSeries;
import org.opencastproject.statistics.api.TimeSeriesProvider;
import org.opencastproject.statistics.provider.influx.StatisticsProviderInfluxService;
import org.opencastproject.statistics.provider.influx.provider.InfluxProviderConfiguration;
import org.opencastproject.statistics.provider.influx.provider.InfluxStatisticsProvider;
import org.opencastproject.util.data.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxTimeSeriesStatisticsProvider
extends InfluxStatisticsProvider
implements TimeSeriesProvider {
    private static final Logger logger = LoggerFactory.getLogger(InfluxTimeSeriesStatisticsProvider.class);
    private Set<InfluxProviderConfiguration.InfluxProviderSource> sources;

    public InfluxTimeSeriesStatisticsProvider(StatisticsProviderInfluxService service, String id, ResourceType resourceType, String title, String description, Set<InfluxProviderConfiguration.InfluxProviderSource> sources) {
        super(service, id, resourceType, title, description);
        this.sources = sources;
    }

    public TimeSeries getValues(String resourceId, Instant from, Instant to, DataResolution resolution, ZoneId zoneId) {
        String influxGrouping = InfluxTimeSeriesStatisticsProvider.dataResolutionToInfluxGrouping(resolution);
        List<Tuple<Instant, Instant>> periods = InfluxTimeSeriesStatisticsProvider.getPeriods(from, to, resolution, zoneId);
        ArrayList labels = new ArrayList();
        ArrayList values = new ArrayList();
        InfluxProviderConfiguration.InfluxProviderSource source = this.getSource(resolution);
        for (Tuple<Instant, Instant> period : periods) {
            BoundParameterQuery query = BoundParameterQuery.QueryBuilder.newQuery("SELECT " + source.getAggregation() + "(" + source.getAggregationVariable() + ") FROM " + source.getMeasurement() + " WHERE " + source.getResourceIdName() + "=$resourceId AND time>=$from AND time<=$to" + influxGrouping).bind("resourceId", resourceId).bind("from", period.getA()).bind("to", period.getB()).create();
            try {
                QueryResult results = this.service.getInfluxDB().query(query);
                TimeSeries currentViews = InfluxTimeSeriesStatisticsProvider.queryResultToTimeSeries(results);
                labels.addAll(currentViews.getLabels());
                values.addAll(currentViews.getValues());
            }
            catch (InfluxDBIOException e) {
                if (e.getCause() instanceof ConnectException) {
                    logger.error("Influx connect exception: {}", (Object)e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        Double total = "SUM".equalsIgnoreCase(source.getAggregation()) ? Double.valueOf(values.stream().mapToDouble(v -> v).sum()) : null;
        return new TimeSeries(labels, values, total);
    }

    public Set<DataResolution> getDataResolutions() {
        return this.sources.stream().flatMap(s -> s.getResolutions().stream()).collect(Collectors.toSet());
    }

    private InfluxProviderConfiguration.InfluxProviderSource getSource(DataResolution resolution) {
        return this.sources.stream().filter(s -> s.getResolutions().contains(resolution)).findAny().orElseThrow(() -> new IllegalStateException("No source available for data resolution " + resolution.name()));
    }

    protected static TimeSeries queryResultToTimeSeries(QueryResult results) {
        if (results.hasError()) {
            throw new RuntimeException("Error while retrieving result from influx: " + results.getError());
        }
        ArrayList labels = new ArrayList();
        ArrayList values = new ArrayList();
        for (QueryResult.Result result : results.getResults()) {
            if (result.hasError()) {
                logger.warn("An element from the set of data returned by influx DB has an error: '{}'. Ignoring this one.", (Object)result.getError());
                continue;
            }
            if (result.getSeries() == null || result.getSeries().isEmpty()) continue;
            labels.addAll(result.getSeries().get(0).getValues().stream().map(l -> (String)l.get(0)).collect(Collectors.toList()));
            values.addAll(result.getSeries().get(0).getValues().stream().map(l -> l.get(1)).map(v -> v == null ? 0.0 : (Double)v).collect(Collectors.toList()));
        }
        return new TimeSeries(labels, values);
    }
}

