/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.statistics.provider.influx.provider;

import com.google.common.collect.Ordering;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opencastproject.statistics.api.DataResolution;
import org.opencastproject.statistics.api.ResourceType;
import org.opencastproject.statistics.api.StatisticsProvider;
import org.opencastproject.statistics.provider.influx.StatisticsProviderInfluxService;
import org.opencastproject.util.data.Tuple;

public abstract class InfluxStatisticsProvider
implements StatisticsProvider {
    protected StatisticsProviderInfluxService service;
    private String id;
    private ResourceType resourceType;
    private String title;
    private String description;

    public InfluxStatisticsProvider(StatisticsProviderInfluxService service, String id, ResourceType resourceType, String title, String description) {
        this.service = service;
        this.id = id;
        this.resourceType = resourceType;
        this.title = title;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    protected static String dataResolutionToInfluxGrouping(DataResolution dataResolution) {
        switch (dataResolution) {
            case HOURLY: {
                return " GROUP BY time(1h)";
            }
            case DAILY: {
                return " GROUP BY time(1d)";
            }
            case WEEKLY: {
                return " GROUP BY time(1w, -3d)";
            }
            case MONTHLY: {
                return "";
            }
            case YEARLY: {
                return "";
            }
        }
        throw new IllegalArgumentException("unmapped DataResolution: " + dataResolution.name());
    }

    protected static List<Tuple<Instant, Instant>> getPeriods(Instant from, Instant to, DataResolution resolution, ZoneId zoneId) {
        switch (resolution) {
            case MONTHLY: {
                return InfluxStatisticsProvider.getMonthPeriods(InfluxStatisticsProvider.getMonths(from, to, zoneId), from, to);
            }
            case YEARLY: {
                return InfluxStatisticsProvider.getYearPeriods(InfluxStatisticsProvider.getYears(from, to, zoneId), from, to);
            }
        }
        return Collections.singletonList(new Tuple((Object)from, (Object)to));
    }

    private static List<Tuple<Instant, Instant>> getMonthPeriods(List<YearMonth> months, Instant from, Instant to) {
        ArrayList<Tuple<Instant, Instant>> result = new ArrayList<Tuple<Instant, Instant>>();
        for (YearMonth month : months) {
            Instant start = month.atDay(1).atStartOfDay().toInstant(ZoneOffset.UTC);
            Instant end = month.atEndOfMonth().atTime(23, 59, 59, 999999999).toInstant(ZoneOffset.UTC);
            result.add((Tuple<Instant, Instant>)new Tuple((Object)((Instant)Ordering.natural().max((Object)start, (Object)from)), (Object)((Instant)Ordering.natural().min((Object)end, (Object)to))));
        }
        return result;
    }

    private static List<Tuple<Instant, Instant>> getYearPeriods(List<Year> years, Instant from, Instant to) {
        ArrayList<Tuple<Instant, Instant>> result = new ArrayList<Tuple<Instant, Instant>>();
        for (Year year : years) {
            Instant start = year.atDay(1).atStartOfDay().toInstant(ZoneOffset.UTC);
            Instant end = year.atMonthDay(MonthDay.of(12, 31)).atTime(23, 59, 59, 999999999).toInstant(ZoneOffset.UTC);
            result.add((Tuple<Instant, Instant>)new Tuple((Object)((Instant)Ordering.natural().max((Object)start, (Object)from)), (Object)((Instant)Ordering.natural().min((Object)end, (Object)to))));
        }
        return result;
    }

    private static List<YearMonth> getMonths(Instant from, Instant to, ZoneId zoneId) {
        LocalDateTime localStart = LocalDateTime.ofInstant(from, zoneId);
        LocalDateTime localEnd = LocalDateTime.ofInstant(to, zoneId);
        ArrayList<YearMonth> months = new ArrayList<YearMonth>();
        while (!localStart.isAfter(localEnd)) {
            months.add(YearMonth.from(localStart));
            localStart = localStart.plusMonths(1L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
        }
        return months;
    }

    private static List<Year> getYears(Instant from, Instant to, ZoneId zoneId) {
        LocalDateTime localStart = LocalDateTime.ofInstant(from, zoneId);
        LocalDateTime localEnd = LocalDateTime.ofInstant(to, zoneId);
        ArrayList<Year> years = new ArrayList<Year>();
        while (!localStart.isAfter(localEnd)) {
            years.add(Year.from(localStart));
            localStart = localStart.plusYears(1L).withMonth(1).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
        }
        return years;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof InfluxStatisticsProvider)) {
            return false;
        }
        StatisticsProvider other = (StatisticsProvider)o;
        return this.getId().equals(other.getId());
    }
}

