/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.statistics.provider.influx.provider;

import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.influxdb.dto.BoundParameterQuery;
import org.influxdb.dto.QueryResult;
import org.opencastproject.statistics.api.DataResolution;
import org.opencastproject.statistics.api.ResourceType;
import org.opencastproject.statistics.api.TimeSeries;
import org.opencastproject.statistics.api.TimeSeriesProvider;
import org.opencastproject.statistics.provider.influx.StatisticsProviderInfluxService;
import org.opencastproject.statistics.provider.influx.provider.InfluxProviderConfiguration;
import org.opencastproject.statistics.provider.influx.provider.InfluxStatisticsProvider;
import org.opencastproject.util.data.Tuple;

public class InfluxRunningTotalStatisticsProvider
extends InfluxStatisticsProvider
implements TimeSeriesProvider {
    private final Set<InfluxProviderConfiguration.InfluxProviderSource> sources;

    public InfluxRunningTotalStatisticsProvider(StatisticsProviderInfluxService service, String id, ResourceType resourceType, String title, String description, Set<InfluxProviderConfiguration.InfluxProviderSource> sources) {
        super(service, id, resourceType, title, description);
        this.sources = sources;
    }

    private static double reduceResult(double previousTotal, QueryResult.Result newResult) {
        if (newResult.getSeries() == null) {
            return previousTotal;
        }
        return previousTotal + newResult.getSeries().stream().reduce(0.0, InfluxRunningTotalStatisticsProvider::reduceSeries, Double::sum);
    }

    private static double reduceSeries(double previousSeriesTotal, QueryResult.Series newSeries) {
        if (newSeries.getValues().isEmpty()) {
            return previousSeriesTotal;
        }
        if (newSeries.getValues().size() > 1) {
            throw new RuntimeException("invalid results returned for aggregation");
        }
        List<Object> objects = newSeries.getValues().get(0);
        if (objects.size() != 2) {
            throw new RuntimeException("invalid results returned for aggregation");
        }
        Object o = objects.get(1);
        if (o == null) {
            return previousSeriesTotal;
        }
        if (!(o instanceof Double)) {
            throw new RuntimeException("invalid results returned for aggregation");
        }
        return previousSeriesTotal + (Double)o;
    }

    private double getPreviousTotal(InfluxProviderConfiguration.InfluxProviderSource source, String resourceId, Instant from) {
        BoundParameterQuery beforeQuery = BoundParameterQuery.QueryBuilder.newQuery("SELECT SUM(" + source.getAggregationVariable() + ") FROM " + source.getMeasurement() + " WHERE " + source.getResourceIdName() + "=$resourceId AND time<$from").bind("resourceId", resourceId).bind("from", from).create();
        QueryResult beforeResults = this.service.getInfluxDB().query(beforeQuery);
        if (beforeResults.hasError()) {
            throw new RuntimeException("Error while retrieving result from influx: " + beforeResults.getError());
        }
        return beforeResults.getResults().stream().reduce(0.0, InfluxRunningTotalStatisticsProvider::reduceResult, Double::sum);
    }

    public TimeSeries getValues(String resourceId, Instant from, Instant to, DataResolution resolution, ZoneId zoneId) {
        String influxGrouping = InfluxRunningTotalStatisticsProvider.dataResolutionToInfluxGrouping(resolution);
        List<Tuple<Instant, Instant>> periods = InfluxRunningTotalStatisticsProvider.getPeriods(from, to, resolution, zoneId);
        ArrayList labels = new ArrayList();
        ArrayList values = new ArrayList();
        InfluxProviderConfiguration.InfluxProviderSource source = this.getSource(resolution);
        double previousTotal = this.getPreviousTotal(source, resourceId, from);
        for (Tuple<Instant, Instant> period : periods) {
            BoundParameterQuery query = BoundParameterQuery.QueryBuilder.newQuery("SELECT " + source.getAggregation() + "(" + source.getAggregationVariable() + ") FROM " + source.getMeasurement() + " WHERE " + source.getResourceIdName() + "=$resourceId AND time>=$from AND time<=$to" + influxGrouping).bind("resourceId", resourceId).bind("from", period.getA()).bind("to", period.getB()).create();
            QueryResult results = this.service.getInfluxDB().query(query);
            Tuple<TimeSeries, Double> currentViews = this.queryResultToTimeSeries(results, previousTotal, (Instant)period.getA());
            previousTotal = (Double)currentViews.getB();
            labels.addAll(((TimeSeries)currentViews.getA()).getLabels());
            values.addAll(((TimeSeries)currentViews.getA()).getValues());
        }
        Double total = "SUM".equalsIgnoreCase(source.getAggregation()) ? Double.valueOf(values.stream().mapToDouble(v -> v).sum()) : null;
        return new TimeSeries(labels, values, total);
    }

    private InfluxProviderConfiguration.InfluxProviderSource getSource(DataResolution resolution) {
        return this.sources.stream().filter(s -> s.getResolutions().contains(resolution)).findAny().orElseThrow(() -> new IllegalStateException("No source available for data resolution " + resolution.name()));
    }

    public Set<DataResolution> getDataResolutions() {
        return new HashSet<DataResolution>(Arrays.asList(DataResolution.YEARLY, DataResolution.MONTHLY, DataResolution.DAILY));
    }

    private Tuple<TimeSeries, Double> queryResultToTimeSeries(QueryResult results, double previousTotal, Instant periodStart) {
        if (results.hasError()) {
            throw new RuntimeException("Error while retrieving result from influx: " + results.getError());
        }
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<Double> values = new ArrayList<Double>();
        double previousSum = previousTotal;
        for (QueryResult.Result result : results.getResults()) {
            if (result.getSeries() == null || result.getSeries().isEmpty()) {
                labels.add(periodStart.toString());
                values.add(previousSum);
                continue;
            }
            labels.addAll(result.getSeries().get(0).getValues().stream().map(l -> (String)l.get(0)).collect(Collectors.toList()));
            for (List<Object> valueList : result.getSeries().get(0).getValues()) {
                Double currentValue = this.reduceValueList(valueList);
                values.add(previousSum += currentValue.doubleValue());
            }
        }
        return Tuple.tuple((Object)new TimeSeries(labels, values), (Object)previousSum);
    }

    private double reduceValueList(List<Object> valueList) {
        Object v = valueList.get(1);
        if (v == null) {
            return 0.0;
        }
        return (Double)v;
    }
}

