/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.statistics.provider.influx.provider;

import com.google.gson.Gson;
import java.util.Set;
import org.opencastproject.statistics.api.DataResolution;
import org.opencastproject.statistics.api.ProviderConfiguration;
import org.opencastproject.statistics.api.ResourceType;

public class InfluxProviderConfiguration
extends ProviderConfiguration {
    private static final Gson gson = new Gson();
    private Set<InfluxProviderSource> sources;

    public InfluxProviderConfiguration() {
    }

    public InfluxProviderConfiguration(String id, String title, String description, ResourceType resourceType, String type, Set<InfluxProviderSource> sources) {
        super(id, title, description, resourceType, type);
        this.sources = sources;
    }

    public Set<InfluxProviderSource> getSources() {
        return this.sources;
    }

    public static InfluxProviderConfiguration fromJson(String json) {
        return (InfluxProviderConfiguration)((Object)gson.fromJson(json, InfluxProviderConfiguration.class));
    }

    public class InfluxProviderSource {
        private String aggregation;
        private String aggregationVariable;
        private String measurement;
        private String resourceIdName;
        private Set<DataResolution> resolutions;

        public InfluxProviderSource() {
        }

        public InfluxProviderSource(String aggregation, String aggregationVariable, String measurement, String resourceIdName, Set<DataResolution> resolutions) {
            this.aggregation = aggregation;
            this.aggregationVariable = aggregationVariable;
            this.measurement = measurement;
            this.resourceIdName = resourceIdName;
            this.resolutions = resolutions;
        }

        public String getAggregation() {
            return this.aggregation;
        }

        public String getAggregationVariable() {
            return this.aggregationVariable;
        }

        public String getMeasurement() {
            return this.measurement;
        }

        public String getResourceIdName() {
            return this.resourceIdName;
        }

        public Set<DataResolution> getResolutions() {
            return this.resolutions;
        }
    }
}

