/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.statistics.provider.influx;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.time.Duration;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.opencastproject.statistics.api.ResourceType;
import org.opencastproject.statistics.api.StatisticsCoordinator;
import org.opencastproject.statistics.api.StatisticsProvider;
import org.opencastproject.statistics.api.StatisticsWriter;
import org.opencastproject.statistics.provider.influx.provider.InfluxProviderConfiguration;
import org.opencastproject.statistics.provider.influx.provider.InfluxRunningTotalStatisticsProvider;
import org.opencastproject.statistics.provider.influx.provider.InfluxStatisticsProvider;
import org.opencastproject.statistics.provider.influx.provider.InfluxTimeSeriesStatisticsProvider;
import org.opencastproject.util.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ManagedService.class, ArtifactInstaller.class, StatisticsWriter.class}, property={"service.description=Statistics Provider Influx Service"})
public class StatisticsProviderInfluxService
implements ManagedService,
ArtifactInstaller,
StatisticsWriter {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsProviderInfluxService.class);
    private static final String KEY_INFLUX_URI = "influx.uri";
    private static final String KEY_INFLUX_USER = "influx.username";
    private static final String KEY_INFLUX_PW = "influx.password";
    private static final String KEY_INFLUX_DB = "influx.db";
    private String influxUri = "http://127.0.0.1:8086";
    private String influxUser = "root";
    private String influxPw = "root";
    private String influxDbName = "opencast";
    private volatile InfluxDB influxDB;
    private StatisticsCoordinator statisticsCoordinator;
    private Map<String, StatisticsProvider> fileNameToProvider = new ConcurrentHashMap<String, StatisticsProvider>();

    @Reference
    public void setStatisticsCoordinator(StatisticsCoordinator service) {
        this.statisticsCoordinator = service;
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating Statistics Provider Influx Service");
    }

    @Deactivate
    public void deactivate(ComponentContext cc) {
        logger.info("Deactivating Statistics Provider Influx Service");
        this.disconnectInflux();
    }

    public void install(File file) throws Exception {
        InfluxStatisticsProvider provider;
        String json = new String(Files.readAllBytes(file.toPath()), Charset.forName("utf-8"));
        InfluxProviderConfiguration providerCfg = InfluxProviderConfiguration.fromJson(json);
        switch (providerCfg.getType().toLowerCase()) {
            case "timeseries": {
                provider = new InfluxTimeSeriesStatisticsProvider(this, providerCfg.getId(), providerCfg.getResourceType(), providerCfg.getTitle(), providerCfg.getDescription(), providerCfg.getSources());
                break;
            }
            case "runningtotal": {
                provider = new InfluxRunningTotalStatisticsProvider(this, providerCfg.getId(), ResourceType.ORGANIZATION, providerCfg.getTitle(), providerCfg.getDescription(), providerCfg.getSources());
                break;
            }
            default: {
                throw new ConfigurationException("Unknown influx statistics type: " + providerCfg.getType());
            }
        }
        this.fileNameToProvider.put(file.getName(), provider);
        if (this.influxDB != null) {
            this.statisticsCoordinator.addProvider((StatisticsProvider)provider);
        }
    }

    public void uninstall(File file) {
        if (this.fileNameToProvider.containsKey(file.getName())) {
            this.statisticsCoordinator.removeProvider(this.fileNameToProvider.get(file.getName()));
            this.fileNameToProvider.remove(file.getName());
        }
    }

    public boolean canHandle(File file) {
        return "statistics".equals(file.getParentFile().getName()) && file.getName().endsWith(".json") && file.getName().toUpperCase().startsWith("influx.".toUpperCase());
    }

    public void update(File file) throws Exception {
        this.uninstall(file);
        this.install(file);
    }

    public void updated(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            logger.info("No configuration available. Not connecting to influx DB.");
            this.disconnectInflux();
        } else {
            Object influxDbValue;
            Object influxPwValue;
            Object influxUserValue;
            Object influxUriValue = dictionary.get(KEY_INFLUX_URI);
            if (influxUriValue != null) {
                this.influxUri = influxUriValue.toString();
            }
            if ((influxUserValue = dictionary.get(KEY_INFLUX_USER)) != null) {
                this.influxUser = influxUserValue.toString();
            }
            if ((influxPwValue = dictionary.get(KEY_INFLUX_PW)) != null) {
                this.influxPw = influxPwValue.toString();
            }
            if ((influxDbValue = dictionary.get(KEY_INFLUX_DB)) != null) {
                this.influxDbName = influxDbValue.toString();
            }
            this.connectInflux();
        }
    }

    public InfluxDB getInfluxDB() {
        return this.influxDB;
    }

    private void connectInflux() {
        this.disconnectInflux();
        this.influxDB = InfluxDBFactory.connect(this.influxUri, this.influxUser, this.influxPw);
        this.influxDB.setDatabase(this.influxDbName);
        this.fileNameToProvider.values().forEach(provider -> this.statisticsCoordinator.addProvider(provider));
        this.statisticsCoordinator.addWriter((StatisticsWriter)this);
    }

    private void disconnectInflux() {
        if (this.influxDB != null) {
            this.fileNameToProvider.values().forEach(provider -> this.statisticsCoordinator.removeProvider(provider));
            this.influxDB.close();
            this.influxDB = null;
        }
    }

    public void writeDuration(String organizationId, String measurementName, String retentionPolicy, String organizationIdResourceName, String fieldName, TimeUnit temporalResolution, Duration duration) {
        double divider;
        switch (temporalResolution) {
            case MILLISECONDS: {
                divider = 1.0;
                break;
            }
            case SECONDS: {
                divider = 1000.0;
                break;
            }
            case MINUTES: {
                divider = 60000.0;
                break;
            }
            case HOURS: {
                divider = 3600000.0;
                break;
            }
            case DAYS: {
                divider = 8.64E7;
                break;
            }
            default: {
                throw new RuntimeException("nanosecond and microsecond resolution not supported");
            }
        }
        Point point = Point.measurement(measurementName).tag(organizationIdResourceName, organizationId).addField(fieldName, (double)duration.toMillis() / divider).build();
        if (retentionPolicy == null) {
            this.influxDB.write(point);
        } else {
            this.influxDB.write(BatchPoints.builder().point(point).retentionPolicy(retentionPolicy).build());
        }
    }

    public String getId() {
        return "influxdb-writer";
    }
}

