/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.fsresources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import javax.servlet.Servlet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.StaticFileAuthorization;
import org.opencastproject.util.ConfigurationException;
import org.opencastproject.util.MimeTypes;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Opencast Download Resources"}, service={Servlet.class})
@HttpWhiteboardServletName(value="/static")
@HttpWhiteboardServletPattern(value={"/static/*"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=opencast)")
public class StaticResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final ArrayList<Range> FULL_RANGE;
    private static final Logger logger;
    private static final String PROP_AUTH_REQUIRED = "authentication.required";
    private static final String PROP_X_ACCEL_REDIRECT = "x.accel.redirect";
    public static final String SERVLET_PATH = "/static";
    private String distributionDirectory;
    private boolean authRequired = true;
    private String xAccelRedirect = null;
    private SecurityService securityService = null;
    private List<StaticFileAuthorization> authorizations = new ArrayList<StaticFileAuthorization>();
    private static final String mimeSeparation = "MATTERHORN_MIME_BOUNDARY";

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addStaticFileAuthorization(StaticFileAuthorization authorization) {
        this.authorizations.add(authorization);
        logger.info("Added static file authorization for {}", (Object)authorization.getProtectedUrlPattern());
    }

    public void removeStaticFileAuthorization(StaticFileAuthorization authorization) {
        this.authorizations.remove(authorization);
        logger.info("Removed static file authorization for {}", (Object)authorization.getProtectedUrlPattern());
    }

    private boolean isAuthorized(String path) {
        for (StaticFileAuthorization auth : this.authorizations) {
            for (Pattern pattern : auth.getProtectedUrlPattern()) {
                logger.debug("Testing pattern `{}`", (Object)pattern);
                if (!pattern.matcher(path).matches()) continue;
                logger.debug("Using regexp `{}` for authorization check", (Object)pattern);
                return auth.verifyUrlAccess(path);
            }
        }
        logger.debug("No authorization plug-in matches");
        return false;
    }

    @Activate
    public void activate(ComponentContext cc) {
        if (cc == null) {
            this.authRequired = true;
            this.xAccelRedirect = null;
        } else {
            String storageDir;
            this.authRequired = BooleanUtils.toBoolean((String)Objects.toString(cc.getProperties().get(PROP_AUTH_REQUIRED), "true"));
            this.xAccelRedirect = Objects.toString(cc.getProperties().get(PROP_X_ACCEL_REDIRECT), null);
            this.distributionDirectory = cc.getBundleContext().getProperty("org.opencastproject.download.directory");
            if (StringUtils.isEmpty((CharSequence)this.distributionDirectory) && StringUtils.isNotEmpty((CharSequence)(storageDir = cc.getBundleContext().getProperty("org.opencastproject.storage.dir")))) {
                this.distributionDirectory = new File(storageDir, "downloads").getPath();
            }
        }
        logger.debug("Authentication check enabled: {}", (Object)this.authRequired);
        if (StringUtils.isEmpty((CharSequence)this.distributionDirectory)) {
            throw new ConfigurationException("Distribution directory not set");
        }
        logger.info("Serving static files from '{}'", (Object)this.distributionDirectory);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.debug("Looking for static resource '{}'", (Object)req.getRequestURI());
        String path = req.getPathInfo();
        if (path == null || path.contains("..")) {
            resp.sendError(403);
            return;
        }
        if (this.authRequired && !this.isAuthorized(path)) {
            resp.sendError(403);
            logger.debug("Not authorized");
            return;
        }
        File file = new File(this.distributionDirectory, path);
        if (!file.isFile() || !file.canRead()) {
            logger.debug("Unable to find file '{}', returning HTTP 404", (Object)file);
            resp.sendError(404);
            return;
        }
        logger.debug("Serving static resource '{}'", (Object)file.getAbsolutePath());
        String eTag = this.computeEtag(file);
        if (eTag.equals(req.getHeader("If-None-Match"))) {
            resp.setStatus(304);
            return;
        }
        resp.setHeader("ETag", eTag);
        if (this.xAccelRedirect != null) {
            resp.setHeader("X-Accel-Redirect", Paths.get(this.xAccelRedirect, path).toString());
            return;
        }
        String contentType = MimeTypes.getMimeType((String)path);
        if (!"application/octet-stream".equals(contentType)) {
            resp.setContentType(contentType);
        }
        resp.setHeader("Content-Length", Long.toString(file.length()));
        resp.setDateHeader("Last-Modified", file.lastModified());
        resp.setHeader("Accept-Ranges", "bytes");
        ArrayList<Range> ranges = this.parseRange(req, resp, eTag, file.lastModified(), file.length());
        if ((ranges == null || ranges.isEmpty()) && req.getHeader("Range") == null || ranges == FULL_RANGE) {
            IOException e = this.copyRange(new FileInputStream(file), resp.getOutputStream(), 0L, file.length());
            if (e != null) {
                try {
                    resp.sendError(500);
                }
                catch (IOException e1) {
                    logger.warn("unable to send http 500 error", (Throwable)e1);
                }
                catch (IllegalStateException e2) {
                    logger.trace("unable to send http 500 error. Client side was probably closed during file copy.", (Throwable)e2);
                }
            }
            return;
        }
        if (ranges == null || ranges.isEmpty()) {
            return;
        }
        if (ranges.size() == 1) {
            Range range = ranges.get(0);
            resp.addHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.length);
            long length = range.end - range.start + 1L;
            if (length < Integer.MAX_VALUE) {
                resp.setContentLength((int)length);
            } else {
                resp.setHeader("content-length", "" + length);
            }
            try {
                resp.setBufferSize(2048);
            }
            catch (IllegalStateException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            resp.setStatus(206);
            IOException e = this.copyRange(new FileInputStream(file), resp.getOutputStream(), range.start, range.end);
            if (e != null) {
                try {
                    resp.sendError(500);
                }
                catch (IOException e1) {
                    logger.warn("unable to send http 500 error", (Throwable)e1);
                }
                catch (IllegalStateException e2) {
                    logger.trace("unable to send http 500 error. Client side was probably closed during file copy.", (Throwable)e2);
                }
            }
            return;
        }
        resp.setStatus(206);
        resp.setContentType("multipart/byteranges; boundary=MATTERHORN_MIME_BOUNDARY");
        try {
            resp.setBufferSize(2048);
        }
        catch (IllegalStateException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        this.copy(file, resp.getOutputStream(), ranges.iterator(), contentType);
    }

    private String computeEtag(File file) {
        CRC32 crc = new CRC32();
        crc.update(file.getName().getBytes());
        StaticResourceServlet.checksum(file.lastModified(), crc);
        StaticResourceServlet.checksum(file.length(), crc);
        return Long.toString(crc.getValue());
    }

    private static void checksum(long l, CRC32 crc) {
        for (int i = 0; i < 8; ++i) {
            crc.update((int)(l & 0xFFL));
            l >>= 8;
        }
    }

    protected void copy(File f, ServletOutputStream out, Iterator<Range> ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasNext()) {
            Range currentRange = ranges.next();
            out.println();
            out.println("--MATTERHORN_MIME_BOUNDARY");
            if (contentType != null) {
                out.println("Content-Type: " + contentType);
            }
            out.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
            out.println();
            FileInputStream in = new FileInputStream(f);
            exception = this.copyRange(in, out, currentRange.start, currentRange.end);
            ((InputStream)in).close();
        }
        out.println();
        out.print("--MATTERHORN_MIME_BOUNDARY--");
        if (exception != null) {
            throw exception;
        }
    }

    protected ArrayList<Range> parseRange(HttpServletRequest req, HttpServletResponse response, String eTag, long lastModified, long fileLength) throws IOException {
        String headerValue = req.getHeader("If-Range");
        if (headerValue != null) {
            long headerValueTime = -1L;
            try {
                headerValueTime = req.getDateHeader("If-Range");
            }
            catch (IllegalArgumentException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            if (headerValueTime == -1L ? !eTag.equals(headerValue.trim()) : lastModified > headerValueTime + 1000L) {
                return FULL_RANGE;
            }
        }
        if (fileLength == 0L) {
            return null;
        }
        String rangeHeader = req.getHeader("Range");
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.addHeader("Content-Range", "bytes */" + fileLength);
            response.sendError(416);
            return null;
        }
        rangeHeader = rangeHeader.substring(6);
        ArrayList<Range> result = new ArrayList<Range>();
        StringTokenizer commaTokenizer = new StringTokenizer(rangeHeader, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String rangeDefinition = commaTokenizer.nextToken().trim();
            Range currentRange = new Range();
            currentRange.length = fileLength;
            int dashPos = rangeDefinition.indexOf(45);
            if (dashPos == -1) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (dashPos == 0) {
                try {
                    long offset = Long.parseLong(rangeDefinition);
                    currentRange.start = fileLength + offset;
                    currentRange.end = fileLength - 1L;
                }
                catch (NumberFormatException e) {
                    response.addHeader("Content-Range", "bytes */" + fileLength);
                    response.sendError(416);
                    return null;
                }
            }
            try {
                currentRange.start = Long.parseLong(rangeDefinition.substring(0, dashPos));
                currentRange.end = dashPos < rangeDefinition.length() - 1 ? Long.parseLong(rangeDefinition.substring(dashPos + 1, rangeDefinition.length())) : fileLength - 1L;
            }
            catch (NumberFormatException e) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (!currentRange.validate()) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            result.add(currentRange);
        }
        return result;
    }

    protected IOException copyRange(InputStream istream, ServletOutputStream ostream, long start, long end) {
        logger.debug("Serving bytes:{}-{}", (Object)start, (Object)end);
        try {
            istream.skip(start);
        }
        catch (IOException e) {
            logger.trace("Cannot skip to input stream position {}. The user probably closed the client side.", (Object)start, (Object)e);
            return e;
        }
        long bytesToRead = end - start + 1L;
        byte[] buffer = new byte[2048];
        int len = buffer.length;
        try {
            len = (int)bytesToRead % buffer.length;
            if (len > 0) {
                if ((len = istream.read(buffer, 0, len)) > 0) {
                    ostream.write(buffer, 0, len);
                    if ((bytesToRead -= (long)len) == 0L) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            len = istream.read(buffer);
            while (len > 0) {
                ostream.write(buffer, 0, len);
                if ((bytesToRead -= (long)len) >= 1L) {
                    len = istream.read(buffer);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            logger.trace("IOException after starting the byte copy, current length {}, buffer {}. The user probably closed the client side after the file started copying.", new Object[]{len, buffer, e});
            return e;
        }
        return null;
    }

    static {
        logger = LoggerFactory.getLogger(StaticResourceServlet.class);
        FULL_RANGE = new ArrayList();
    }

    protected class Range {
        protected long start;
        protected long end;
        protected long length;

        protected Range() {
        }

        public boolean validate() {
            if (this.end >= this.length) {
                this.end = this.length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.start <= this.end && this.length > 0L;
        }

        public void recycle() {
            this.start = 0L;
            this.end = 0L;
            this.length = 0L;
        }
    }
}

