/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.smil.endpoint;

import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.smil.api.SmilException;
import org.opencastproject.smil.api.SmilResponse;
import org.opencastproject.smil.api.SmilService;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="smil", title="SmilService Rest Endpoint", abstractText="SmilRestService provide other services to create and modify Smil objects.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/smil)"})
@Component(property={"service.description=Smil Service REST Endpoint", "opencast.service.type=org.opencastproject.smil", "opencast.service.path=/smil"}, immediate=true, service={SmilServiceRest.class})
public class SmilServiceRest {
    private static final Logger logger = LoggerFactory.getLogger(SmilServiceRest.class);
    private SmilService smilService;

    @POST
    @Path(value="create")
    @Produces(value={"application/xml", "text/xml"})
    @RestQuery(name="create", description="Create new SMIL. Add some MediaPackage metadata.", restParameters={@RestParameter(name="mediaPackage", description="MediaPackage for metadata.", isRequired=false, type=RestParameter.Type.TEXT)}, returnDescription="Returns new SmilResponse with SMIL document inside.", responses={@RestResponse(responseCode=200, description="Create new SMIL successfull"), @RestResponse(responseCode=400, description="Given mediaPackage is not valid")})
    public Response createNewSmil(@FormParam(value="mediaPackage") String mediaPackage) {
        SmilResponse smilResponse = null;
        try {
            if (mediaPackage != null && !mediaPackage.isEmpty()) {
                MediaPackage mp = MediaPackageParser.getFromXml((String)mediaPackage);
                smilResponse = this.smilService.createNewSmil(mp);
            } else {
                smilResponse = this.smilService.createNewSmil();
            }
            return Response.ok((Object)smilResponse).build();
        }
        catch (MediaPackageException ex) {
            logger.info(ex.getMessage(), (Throwable)ex);
            return Response.status((int)400).entity((Object)"MediaPackage not valid.").build();
        }
    }

    @POST
    @Path(value="addPar")
    @Produces(value={"application/xml", "text/xml"})
    @RestQuery(name="addPar", description="Add an parallel element to SMIL (into SMIL body or an element with given parentId).", restParameters={@RestParameter(name="smil", description="SMIL document where to add a par-element.", isRequired=true, type=RestParameter.Type.TEXT), @RestParameter(name="parentId", description="An element Id, were to add new parallel.", isRequired=false, type=RestParameter.Type.STRING)}, returnDescription="Returns SmilResponse with a parallel element inside (the new par will be returned as response entity).", responses={@RestResponse(responseCode=200, description="Add par to SMIL successfull."), @RestResponse(responseCode=400, description="SMIL document not valid."), @RestResponse(responseCode=400, description="SMIL document doesn't contain an element with given parentId.")})
    public Response addParallel(@FormParam(value="smil") String smil, @FormParam(value="parentId") String parentId) {
        SmilResponse smilResponse = null;
        try {
            smilResponse = this.smilService.fromXml(smil);
        }
        catch (SmilException ex) {
            return Response.status((int)400).entity((Object)"SMIL document invalid.").build();
        }
        try {
            smilResponse = parentId != null && !parentId.isEmpty() ? this.smilService.addParallel(smilResponse.getSmil(), parentId) : this.smilService.addParallel(smilResponse.getSmil());
            return Response.ok((Object)smilResponse).build();
        }
        catch (SmilException ex) {
            logger.info(ex.getMessage(), (Throwable)ex);
            return Response.status((int)400).entity((Object)"SMIL document doesn't contain an element with given parentId.").build();
        }
    }

    @POST
    @Path(value="addSeq")
    @Produces(value={"application/xml", "text/xml"})
    @RestQuery(name="addSeq", description="Add an sequence element to SMIL (into SMIL body or an element with given parentId).", restParameters={@RestParameter(name="smil", description="SMIL document where to add a seq-element.", isRequired=true, type=RestParameter.Type.TEXT), @RestParameter(name="parentId", description="An element Id, were to add new sequence.", isRequired=false, type=RestParameter.Type.STRING)}, returnDescription="Returns SmilResponse with a sequence element inside (the new seq will be returned as response entity).", responses={@RestResponse(responseCode=200, description="Add seq to SMIL successfull"), @RestResponse(responseCode=400, description="SMIL document not valid"), @RestResponse(responseCode=400, description="SMIL document doesn't contain an element with given parentId")})
    public Response addSequence(@FormParam(value="smil") String smil, @FormParam(value="parentId") String parentId) {
        SmilResponse smilResponse = null;
        try {
            smilResponse = this.smilService.fromXml(smil);
        }
        catch (SmilException ex) {
            logger.info(ex.getMessage(), (Throwable)ex);
            return Response.status((int)400).entity((Object)"SMIL document invalid.").build();
        }
        try {
            smilResponse = parentId != null && !parentId.isEmpty() ? this.smilService.addSequence(smilResponse.getSmil(), parentId) : this.smilService.addSequence(smilResponse.getSmil());
            return Response.ok((Object)smilResponse).build();
        }
        catch (SmilException ex) {
            logger.info(ex.getMessage(), (Throwable)ex);
            return Response.status((int)400).entity((Object)"SMIL document doesn't contain an element with given parentId.").build();
        }
    }

    @POST
    @Path(value="addClip")
    @Produces(value={"application/xml", "text/xml"})
    @RestQuery(name="addClip", description="Add new media element based on given Track information and start / duration parameters. ParentId specifies where to put the new media element.", restParameters={@RestParameter(name="smil", description="SMIL document where to add new media element.", isRequired=true, type=RestParameter.Type.TEXT), @RestParameter(name="parentId", description="An element Id, were to add new media.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="track", description="Track (MediaPackageElement) to add as media element. Some information like Track source and flavor will be stored in ParamGroup (in SMIL Head) and referenced by paramGroup media element attribute.", isRequired=true, type=RestParameter.Type.TEXT), @RestParameter(name="start", description="Track start position in milliseconds.", isRequired=true, type=RestParameter.Type.INTEGER), @RestParameter(name="duration", description="Clip duration in milliseconds (should be positive).", isRequired=true, type=RestParameter.Type.INTEGER)}, returnDescription="Returns new Smil with an media element inside (the new media and metadata elements will be returned as response entities).", responses={@RestResponse(responseCode=200, description="Add media element to SMIL successfull."), @RestResponse(responseCode=400, description="SMIL document not valid."), @RestResponse(responseCode=400, description="Track not valid."), @RestResponse(responseCode=400, description="SMIL document doesn't contain an element with given parentId."), @RestResponse(responseCode=400, description="Start plus duration is bigger than Track length.")})
    public Response addClip(@FormParam(value="smil") String smil, @FormParam(value="parentId") String parentId, @FormParam(value="track") String track, @FormParam(value="start") long start, @FormParam(value="duration") long duration) {
        SmilResponse smilResponse = null;
        Track trackObj = null;
        try {
            smilResponse = this.smilService.fromXml(smil);
            trackObj = (Track)MediaPackageElementParser.getFromXml((String)track);
        }
        catch (SmilException ex) {
            return Response.status((int)400).entity((Object)"SMIL document invalid.").build();
        }
        catch (MediaPackageException ex) {
            return Response.status((int)400).entity((Object)"Track is not valid.").build();
        }
        try {
            smilResponse = this.smilService.addClip(smilResponse.getSmil(), parentId, trackObj, start, duration);
            return Response.ok((Object)smilResponse).build();
        }
        catch (SmilException ex) {
            logger.info(ex.getMessage(), (Throwable)ex);
            return Response.status((int)400).entity((Object)"SMIL document doesn't contain an element with given parentId.").build();
        }
    }

    @POST
    @Path(value="addClips")
    @Produces(value={"application/xml", "text/xml"})
    @RestQuery(name="addClips", description="Add new media elements based on given Tracks information and start / duration parameters. ParentId specifies where to put the new media.", restParameters={@RestParameter(name="smil", description="SMIL document where to add new media elements.", isRequired=true, type=RestParameter.Type.TEXT), @RestParameter(name="parentId", description="An element Id, were to add new media. ", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="tracks", description="Tracks (MediaPackageElements) to add as media elements.Some information like Track source and flavor will be stored in ParamGroup (in SMIL Head) and referenced by paramGroup media element attribute.", isRequired=true, type=RestParameter.Type.TEXT), @RestParameter(name="start", description="Track start position in milliseconds. The start position will be applied to each media element.", isRequired=true, type=RestParameter.Type.INTEGER), @RestParameter(name="duration", description="Clip duration in milliseconds (should be positive). The duration will be applied to each media element.", isRequired=true, type=RestParameter.Type.INTEGER)}, returnDescription="Returns new Smil with new media elements inside (the new media and metadata elements will be returned as response entities).", responses={@RestResponse(responseCode=200, description="Add media elements to SMIL successfull."), @RestResponse(responseCode=400, description="SMIL document not valid."), @RestResponse(responseCode=400, description="Tracks are not valid."), @RestResponse(responseCode=400, description="SMIL document doesn't contain an element with given parentId."), @RestResponse(responseCode=400, description="Start plus duration is bigger than Track length.")})
    public Response addClips(@FormParam(value="smil") String smil, @FormParam(value="parentId") String parentId, @FormParam(value="tracks") String tracks, @FormParam(value="start") long start, @FormParam(value="duration") long duration) {
        SmilResponse smilResponse = null;
        List tracksList = null;
        try {
            smilResponse = this.smilService.fromXml(smil);
            tracksList = MediaPackageElementParser.getArrayFromXml((String)tracks);
        }
        catch (SmilException ex) {
            logger.info(ex.getMessage(), (Throwable)ex);
            return Response.status((int)400).entity((Object)"SMIL document invalid.").build();
        }
        catch (MediaPackageException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return Response.status((int)400).entity((Object)"Tracks are not valid.").build();
        }
        Track[] tracksArr = tracksList.toArray(new Track[tracksList.size()]);
        try {
            smilResponse = this.smilService.addClips(smilResponse.getSmil(), parentId, tracksArr, start, duration);
            return Response.ok((Object)smilResponse).build();
        }
        catch (SmilException ex) {
            logger.info(ex.getMessage(), (Throwable)ex);
            return Response.status((int)400).entity((Object)"SMIL document doesn't contain an element with given parentId.").build();
        }
    }

    @POST
    @Path(value="addMeta")
    @Produces(value={"application/xml", "text/xml"})
    @RestQuery(name="addMeta", description="Add a meta element to SMIL head.", restParameters={@RestParameter(name="smil", description="SMIL document where to add an meta element.", isRequired=true, type=RestParameter.Type.TEXT), @RestParameter(name="name", description="Value of meta name attribute.", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="content", description="Value of meta content attribute.", isRequired=true, type=RestParameter.Type.STRING)}, returnDescription="Returns SmilResponse with a new meta element inside (the new meta will be returned as response entity).", responses={@RestResponse(responseCode=200, description="Add par to SMIL successfull."), @RestResponse(responseCode=400, description="SMIL document not valid.")})
    public Response addMeta(@FormParam(value="smil") String smil, @FormParam(value="name") String metaName, @FormParam(value="content") String metaContent) {
        SmilResponse smilResponse = null;
        try {
            smilResponse = this.smilService.fromXml(smil);
        }
        catch (SmilException ex) {
            return Response.status((int)400).entity((Object)"SMIL document invalid.").build();
        }
        smilResponse = this.smilService.addMeta(smilResponse.getSmil(), metaName, metaContent);
        return Response.ok((Object)smilResponse).build();
    }

    @POST
    @Path(value="remove")
    @Produces(value={"application/xml", "text/xml"})
    @RestQuery(name="remove", description="Remove an element with given Id from SMIL.", restParameters={@RestParameter(name="smil", description="SMIL document.", isRequired=true, type=RestParameter.Type.TEXT), @RestParameter(name="elementId", description="Id of element to remove.", isRequired=true, type=RestParameter.Type.STRING)}, returnDescription="Returns SMIL document without an element with given Id (if SMIL document contains an element with given Id, this will be returned as entity).", responses={@RestResponse(responseCode=200, description="Removing element from SMIL successfull."), @RestResponse(responseCode=400, description="SMIL document not valid.")})
    public Response removeSmilElement(@FormParam(value="smil") String smil, @FormParam(value="elementId") String elementId) {
        SmilResponse smilResponse = null;
        try {
            smilResponse = this.smilService.fromXml(smil);
            smilResponse = this.smilService.removeSmilElement(smilResponse.getSmil(), elementId);
            return Response.ok((Object)smilResponse).build();
        }
        catch (SmilException ex) {
            logger.info(ex.getMessage(), (Throwable)ex);
            return Response.status((int)400).entity((Object)"SMIL document invalid.").build();
        }
    }

    @Reference
    public void setSmilService(SmilService smilService) {
        this.smilService = smilService;
    }
}

