/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.util;

import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AssetPathUtils {
    private static final Logger logger = LoggerFactory.getLogger(AssetPathUtils.class);
    private static final String CONFIG_ASSET_MANAGER_ROOT = "org.opencastproject.episode.rootdir";
    private static final String CONFIG_STORAGE_DIR = "org.opencastproject.storage.dir";

    private AssetPathUtils() {
    }

    public static List<String> getAssetManagerPath(ComponentContext componentContext) {
        if (componentContext == null || componentContext.getBundleContext() == null) {
            return null;
        }
        BundleContext bundleContext = componentContext.getBundleContext();
        ArrayList<String> assetManagerDirs = new ArrayList<String>();
        String assetManagerDir = StringUtils.trimToNull((String)bundleContext.getProperty(CONFIG_ASSET_MANAGER_ROOT));
        if (assetManagerDir == null && (assetManagerDir = StringUtils.trimToNull((String)bundleContext.getProperty(CONFIG_STORAGE_DIR))) != null) {
            assetManagerDir = new File(assetManagerDir, "archive").getAbsolutePath();
        }
        assetManagerDirs.add(assetManagerDir);
        int index = 1;
        boolean isAssetManagerDir = true;
        while (isAssetManagerDir) {
            String directory = StringUtils.trimToNull((String)bundleContext.getProperty("org.opencastproject.episode.rootdir." + index));
            if (directory != null) {
                assetManagerDirs.add(directory);
            } else {
                isAssetManagerDir = false;
            }
            ++index;
        }
        if (assetManagerDir != null && new File(assetManagerDir).isDirectory()) {
            logger.debug("Found local asset manager directory at {}", (Object)assetManagerDir);
            return assetManagerDirs;
        }
        return null;
    }

    public static File getLocalFile(List<String> localPaths, String organizationId, URI uri) {
        if (localPaths == null || organizationId == null || !uri.getScheme().startsWith("http") || !uri.getPath().startsWith("/assets/assets/")) {
            return null;
        }
        String[] assetPath = uri.getPath().split("/");
        if (assetPath.length != 7) {
            return null;
        }
        String mediaPackageID = assetPath[3];
        String mediaPackageElementID = assetPath[4];
        String version = assetPath[5];
        String filename = mediaPackageElementID + "." + FilenameUtils.getExtension((String)assetPath[6]);
        String localPath = null;
        for (String path : localPaths) {
            Path dirPath = Path.of(path, organizationId, mediaPackageID);
            if (!Files.exists(dirPath, new LinkOption[0]) || !Files.isDirectory(dirPath, new LinkOption[0])) continue;
            localPath = path;
        }
        if (localPath == null) {
            logger.debug("Local snapshot for {} not available.", (Object)uri);
            return null;
        }
        File file = Paths.get(localPath, organizationId, mediaPackageID, version, filename).toFile();
        if (file.isFile()) {
            logger.debug("Converted {} to local file at {}", (Object)uri, (Object)file);
            return file;
        }
        logger.debug("Local file for {} not available. {} does not exist.", (Object)uri, (Object)file);
        return null;
    }
}

