/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.search.api;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.opencastproject.search.api.SearchResult;

public class SearchResultList {
    private final List<SearchResult> list;
    private final long totalhits;

    public SearchResultList(SearchHits hits) {
        this.list = Arrays.stream(hits.getHits()).map(SearchHit::getSourceAsMap).map(SearchResult::rehydrate).collect(Collectors.toUnmodifiableList());
        this.totalhits = hits.getTotalHits().value;
    }

    public List<SearchResult> getHits() {
        return this.list;
    }

    public long getTotalHits() {
        return this.totalhits;
    }
}

