/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.rename;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.VideoStream;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Rename Files Workflow Operation Handler", "workflow.operation=rename-files"}, immediate=true, service={WorkflowOperationHandler.class})
public class RenameFilesWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(RenameFilesWorkflowOperationHandler.class);
    private Workspace workspace = null;

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        String mediaPackageId = mediaPackage.getIdentifier().toString();
        logger.info("Running rename files workflow operation on workflow {}", (Object)workflowInstance.getId());
        String pattern = operation.getConfiguration("name-pattern");
        if (pattern == null) {
            throw new WorkflowOperationException("name-pattern must be configured");
        }
        logger.debug("name-pattern {}", (Object)pattern);
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none);
        List sourceFlavors = tagsAndFlavors.getSrcFlavors();
        TrackSelector trackSelector = new TrackSelector();
        for (MediaPackageElementFlavor sourceFlavor : sourceFlavors) {
            trackSelector.addFlavor(sourceFlavor);
        }
        for (Track track : trackSelector.select(mediaPackage, false)) {
            URI uri = track.getURI();
            String extension = FilenameUtils.getExtension((String)uri.toString());
            String newElementId = UUID.randomUUID().toString();
            String filename = pattern;
            for (Map.Entry<String, String> entry : this.placeholders(mediaPackage, track).entrySet()) {
                filename = filename.replace(entry.getKey(), entry.getValue());
            }
            filename = filename.replaceAll("#\\{[a-z.]*}", "_");
            try (InputStream in = this.workspace.read(uri);){
                URI newUri = this.workspace.put(mediaPackageId, newElementId, filename, in);
                logger.info("Renaming {} to {}", (Object)uri, (Object)newUri);
                track.setIdentifier(newElementId);
                track.setURI(newUri);
            }
            catch (IOException | NotFoundException e) {
                throw new WorkflowOperationException("Failed moving track file", e);
            }
            logger.debug("Removing old track file {}", (Object)uri);
            try {
                this.workspace.delete(uri);
            }
            catch (IOException | NotFoundException e) {
                logger.debug("Could not remove track from workspace. Could be it was never there.");
            }
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    private Map<String, String> placeholders(MediaPackage mediaPackage, Track element) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        String width = Arrays.stream(element.getStreams()).filter(s -> s instanceof VideoStream).map(s -> (VideoStream)s).findFirst().map(VideoStream::getFrameWidth).map(Object::toString).orElse("");
        placeholders.put("#{video.width}", width);
        String height = Arrays.stream(element.getStreams()).filter(h -> h instanceof VideoStream).map(h -> (VideoStream)h).findFirst().map(VideoStream::getFrameHeight).map(Object::toString).orElse("");
        placeholders.put("#{video.height}", height);
        placeholders.put("#{file.extension}", FilenameUtils.getExtension((String)element.getURI().toString()));
        placeholders.put("#{file.basename}", FilenameUtils.getBaseName((String)element.getURI().toString()));
        placeholders.put("#{flavor.type}", element.getFlavor().getType());
        placeholders.put("#{flavor.subtype}", element.getFlavor().getSubtype());
        for (MediaPackageElementFlavor flavor : Arrays.asList(MediaPackageElements.EPISODE, MediaPackageElements.SERIES)) {
            for (Catalog catalog : mediaPackage.getCatalogs(flavor)) {
                DublinCoreCatalog dc = DublinCoreUtil.loadDublinCore((Workspace)this.workspace, (MediaPackageElement)catalog);
                for (Map.Entry entry : dc.getValues().entrySet()) {
                    String key = String.format("#{%s.%s}", flavor.getSubtype(), ((EName)entry.getKey()).getLocalName());
                    String value = ((DublinCoreValue)((List)entry.getValue()).get(0)).getValue();
                    placeholders.put(key, value);
                }
            }
        }
        logger.debug("Placeholders to use for renaming: {}", placeholders);
        return placeholders;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        super.activate(cc);
    }
}

