/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.publication.configurable.endpoint;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.publication.api.ConfigurablePublicationService;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="configurablepublicationservice", title="Configurable Publication Service", abstractText="This service publishes and retracts media package elements to a configurable channel", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files). If the service is down or not working it will return a status 503, this means the underlying service is not working and is either restarting or has failed. A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug!"})
@Component(immediate=true, service={ConfigurablePublicationRestService.class}, property={"service.description=Configurable Publication REST Endpoint", "opencast.service.type=org.opencastproject.publication.configurable", "opencast.service.path=/publication/api", "opencast.service.jobproducer=true"})
public class ConfigurablePublicationRestService
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurablePublicationRestService.class);
    private Gson gson = new Gson();
    private ConfigurablePublicationService service;
    private ServiceRegistry serviceRegistry;

    @Reference
    public void setService(ConfigurablePublicationService service) {
        this.service = service;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public JobProducer getService() {
        return (JobProducer)this.service;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @POST
    @Path(value="/replace")
    @Produces(value={"text/xml"})
    @RestQuery(name="replace", description="Replace a media package in this publication channel", returnDescription="The job that can be used to track the publication", restParameters={@RestParameter(name="mediapackage", isRequired=true, description="The media package", type=RestParameter.Type.TEXT), @RestParameter(name="channel", isRequired=true, description="The channel name", type=RestParameter.Type.STRING), @RestParameter(name="addElements", isRequired=true, description="The media package elements to published", type=RestParameter.Type.STRING), @RestParameter(name="retractElements", isRequired=true, description="The identifiers of the media package elements to be retracted from the media package", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="An XML representation of the publication job")})
    public Response replace(@FormParam(value="mediapackage") String mediaPackageXml, @FormParam(value="channel") String channel, @FormParam(value="addElements") String addElementsXml, @FormParam(value="retractElements") String retractElements) {
        Response response;
        try {
            MediaPackage mediaPackage = MediaPackageParser.getFromXml((String)mediaPackageXml);
            HashSet addElements = new HashSet(MediaPackageElementParser.getArrayFromXml((String)addElementsXml));
            Set retractElementsIds = (Set)this.gson.fromJson(retractElements, new TypeToken<Set<String>>(){}.getType());
            Job job = this.service.replace(mediaPackage, channel, addElements, retractElementsIds);
            response = Response.ok((Object)new JaxbJob(job)).build();
        }
        catch (IllegalArgumentException e) {
            logger.warn("Unable to create a publication job", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            logger.warn("Error publishing or retracting element", (Throwable)e);
            response = Response.serverError().build();
        }
        return response;
    }

    @POST
    @Path(value="/replacesync")
    @Produces(value={"text/xml"})
    @RestQuery(name="replacesync", description="Synchronously replace a media package in this publication channel", returnDescription="The publication", restParameters={@RestParameter(name="mediapackage", isRequired=true, description="The media package", type=RestParameter.Type.TEXT), @RestParameter(name="channel", isRequired=true, description="The channel name", type=RestParameter.Type.STRING), @RestParameter(name="addElements", isRequired=true, description="The media package elements to published", type=RestParameter.Type.STRING), @RestParameter(name="retractElements", isRequired=true, description="The identifiers of the media package elements to be retracted from the media package", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="An XML representation of the publication")})
    public Response replaceSync(@FormParam(value="mediapackage") String mediaPackageXml, @FormParam(value="channel") String channel, @FormParam(value="addElements") String addElementsXml, @FormParam(value="retractElements") String retractElements) {
        Response response;
        try {
            MediaPackage mediaPackage = MediaPackageParser.getFromXml((String)mediaPackageXml);
            HashSet addElements = new HashSet(MediaPackageElementParser.getArrayFromXml((String)addElementsXml));
            Set retractElementsIds = (Set)this.gson.fromJson(retractElements, new TypeToken<Set<String>>(){}.getType());
            Publication publication = this.service.replaceSync(mediaPackage, channel, addElements, retractElementsIds);
            response = Response.ok((Object)MediaPackageElementParser.getAsXml((MediaPackageElement)publication)).build();
        }
        catch (Exception e) {
            logger.warn("Error publishing or retracting element", (Throwable)e);
            response = Response.serverError().build();
        }
        return response;
    }
}

