/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.publication.configurable;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.opencastproject.distribution.api.DistributionException;
import org.opencastproject.distribution.api.DownloadDistributionService;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.PublicationImpl;
import org.opencastproject.publication.api.ConfigurablePublicationService;
import org.opencastproject.publication.api.PublicationException;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.JobUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ConfigurablePublicationService.class}, property={"service.description=Publication Service (Configurable)"})
public class ConfigurablePublicationServiceImpl
extends AbstractJobProducer
implements ConfigurablePublicationService {
    private Gson gson = new Gson();
    private DownloadDistributionService distributionService;
    private SecurityService securityService;
    private UserDirectoryService userDirectoryService;
    private OrganizationDirectoryService organizationDirectoryService;
    private ServiceRegistry serviceRegistry;

    public void activate(ComponentContext cc) {
        super.activate(cc);
    }

    public ConfigurablePublicationServiceImpl() {
        super("org.opencastproject.publication.configurable");
    }

    public String getJobType() {
        return super.getJobType();
    }

    public Job replace(MediaPackage mediaPackage, String channelId, Collection<? extends MediaPackageElement> addElements, Set<String> retractElementIds) throws PublicationException, MediaPackageException {
        try {
            return this.serviceRegistry.createJob("org.opencastproject.publication.configurable", Operation.Replace.toString(), Arrays.asList(MediaPackageParser.getAsXml((MediaPackage)mediaPackage), channelId, MediaPackageElementParser.getArrayAsXml(addElements), this.gson.toJson(retractElementIds)));
        }
        catch (ServiceRegistryException e) {
            throw new PublicationException("Unable to create job", (Throwable)e);
        }
    }

    public Publication replaceSync(MediaPackage mediaPackage, String channelId, Collection<? extends MediaPackageElement> addElements, Set<String> retractElementIds) throws PublicationException, MediaPackageException {
        try {
            return this.doReplaceSync(mediaPackage, channelId, addElements, retractElementIds);
        }
        catch (DistributionException e) {
            throw new PublicationException((Throwable)e);
        }
    }

    protected String process(Job job) throws Exception {
        List arguments = job.getArguments();
        MediaPackage mediaPackage = MediaPackageParser.getFromXml((String)((String)arguments.get(0)));
        String channelId = (String)arguments.get(1);
        List addElements = MediaPackageElementParser.getArrayFromXml((String)((String)arguments.get(2)));
        Set retractElementIds = (Set)this.gson.fromJson((String)arguments.get(3), new TypeToken<Set<String>>(){}.getType());
        Publication result = null;
        switch (Operation.valueOf(job.getOperation())) {
            case Replace: {
                result = this.doReplace(mediaPackage, channelId, addElements, retractElementIds);
                break;
            }
        }
        if (result != null) {
            return MediaPackageElementParser.getAsXml(result);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void distributeMany(MediaPackage mp, String channelId, Collection<? extends MediaPackageElement> elements) throws DistributionException, MediaPackageException {
        Optional<Publication> publicationOpt = this.getPublication(mp, channelId);
        if (publicationOpt.isPresent()) {
            Publication publication = publicationOpt.get();
            elements.forEach(arg_0 -> ((MediaPackage)mp).add(arg_0));
            HashSet<String> elementIds = new HashSet<String>();
            for (MediaPackageElement mediaPackageElement : elements) {
                elementIds.add(mediaPackageElement.getIdentifier());
            }
            try {
                Job job = this.distributionService.distribute(channelId, mp, elementIds, false);
                if (!JobUtil.waitForJob((ServiceRegistry)this.serviceRegistry, (Job)job).isSuccess()) {
                    throw new DistributionException("At least one of the publication jobs did not complete successfully");
                }
                List list = MediaPackageElementParser.getArrayFromXml((String)job.getPayload());
                for (MediaPackageElement mpe : list) {
                    PublicationImpl.addElementToPublication((Publication)publication, (MediaPackageElement)mpe);
                }
                elements.stream().map(MediaPackageElement::getIdentifier).forEach(arg_0 -> ((MediaPackage)mp).removeElementById(arg_0));
            }
            catch (Throwable throwable) {
                elements.stream().map(MediaPackageElement::getIdentifier).forEach(arg_0 -> ((MediaPackage)mp).removeElementById(arg_0));
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void distributeManySync(MediaPackage mp, String channelId, Collection<? extends MediaPackageElement> elements) throws DistributionException {
        Optional<Publication> publicationOpt = this.getPublication(mp, channelId);
        if (publicationOpt.isPresent()) {
            Publication publication = publicationOpt.get();
            elements.forEach(arg_0 -> ((MediaPackage)mp).add(arg_0));
            HashSet<String> elementIds = new HashSet<String>();
            for (MediaPackageElement mediaPackageElement : elements) {
                elementIds.add(mediaPackageElement.getIdentifier());
            }
            try {
                List distributedElements = this.distributionService.distributeSync(channelId, mp, elementIds, false);
                for (MediaPackageElement mpe : distributedElements) {
                    PublicationImpl.addElementToPublication((Publication)publication, (MediaPackageElement)mpe);
                }
                elements.stream().map(MediaPackageElement::getIdentifier).forEach(arg_0 -> ((MediaPackage)mp).removeElementById(arg_0));
            }
            catch (Throwable throwable) {
                elements.stream().map(MediaPackageElement::getIdentifier).forEach(arg_0 -> ((MediaPackage)mp).removeElementById(arg_0));
                throw throwable;
            }
        }
    }

    private Publication doReplace(MediaPackage mp, String channelId, Collection<? extends MediaPackageElement> addElementIds, Set<String> retractElementIds) throws DistributionException, MediaPackageException {
        Publication publication;
        Job retractJob = this.distributionService.retract(channelId, mp, retractElementIds);
        if (!JobUtil.waitForJobs((ServiceRegistry)this.serviceRegistry, (Job[])new Job[]{retractJob}).isSuccess()) {
            throw new DistributionException("At least one of the retraction jobs did not complete successfully");
        }
        Optional<Publication> priorPublication = this.getPublication(mp, channelId);
        if (priorPublication.isPresent()) {
            publication = priorPublication.get();
        } else {
            String publicationUUID = UUID.randomUUID().toString();
            publication = PublicationImpl.publication((String)publicationUUID, (String)channelId, null, null);
            mp.add((MediaPackageElement)publication);
        }
        retractElementIds.forEach(arg_0 -> ((Publication)publication).removeAttachmentById(arg_0));
        this.distributeMany(mp, channelId, addElementIds);
        return publication;
    }

    private Publication doReplaceSync(MediaPackage mp, String channelId, Collection<? extends MediaPackageElement> addElementIds, Set<String> retractElementIds) throws DistributionException {
        Publication publication;
        this.distributionService.retractSync(channelId, mp, retractElementIds);
        Optional<Publication> priorPublication = this.getPublication(mp, channelId);
        if (priorPublication.isPresent()) {
            publication = priorPublication.get();
        } else {
            String publicationUUID = UUID.randomUUID().toString();
            publication = PublicationImpl.publication((String)publicationUUID, (String)channelId, null, null);
            mp.add((MediaPackageElement)publication);
        }
        retractElementIds.forEach(arg_0 -> ((Publication)publication).removeAttachmentById(arg_0));
        this.distributeManySync(mp, channelId, addElementIds);
        return publication;
    }

    private Optional<Publication> getPublication(MediaPackage mp, String channelId) {
        return Arrays.stream(mp.getPublications()).filter(p -> p.getChannel().equalsIgnoreCase(channelId)).findAny();
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.serviceRegistry = this.serviceRegistry;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Reference(target="(distribution.channel=download)")
    public void setDownloadDistributionService(DownloadDistributionService downloadDistributionService) {
        this.distributionService = downloadDistributionService;
    }

    public static enum Operation {
        Replace;

    }
}

