/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.publication.configurable.remote;

import com.google.gson.Gson;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.publication.api.ConfigurablePublicationService;
import org.opencastproject.publication.api.PublicationException;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ConfigurablePublicationService.class}, property={"service.description=Publication (Configurable) Remote Service Proxy"})
public class ConfigurablePublicationServiceRemoteImpl
extends RemoteBase
implements ConfigurablePublicationService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurablePublicationServiceRemoteImpl.class);
    private Gson gson = new Gson();

    public ConfigurablePublicationServiceRemoteImpl() {
        super("org.opencastproject.publication.configurable");
    }

    /*
     * Loose catch block
     */
    public Job replace(MediaPackage mediaPackage, String channelId, Collection<? extends MediaPackageElement> addElements, Set<String> retractElementIds) throws PublicationException, MediaPackageException {
        HttpResponse response;
        block7: {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("mediapackage", MediaPackageParser.getAsXml((MediaPackage)mediaPackage)));
            params.add(new BasicNameValuePair("channel", channelId));
            params.add(new BasicNameValuePair("addElements", MediaPackageElementParser.getArrayAsXml(addElements)));
            params.add(new BasicNameValuePair("retractElements", this.gson.toJson(retractElementIds)));
            HttpPost post = new HttpPost("/replace");
            response = null;
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
            response = this.getResponse((HttpRequestBase)post);
            if (response == null) break block7;
            logger.info("Publishing media package {} to channel {} using a remote publication service", (Object)mediaPackage, (Object)channelId);
            Job job = JobParser.parseJob((InputStream)response.getEntity().getContent());
            this.closeConnection(response);
            return job;
            {
                catch (Exception e) {
                    try {
                        throw new PublicationException("Unable to publish media package '" + mediaPackage + "' using a remote publication service", (Throwable)e);
                    }
                    catch (Exception e2) {
                        try {
                            throw new PublicationException("Unable to publish media package " + mediaPackage + " using a remote publication service.", (Throwable)e2);
                        }
                        catch (Throwable throwable) {
                            this.closeConnection(response);
                            throw throwable;
                        }
                    }
                }
            }
        }
        this.closeConnection(response);
        throw new PublicationException("Unable to publish mediapackage " + mediaPackage + " using a remote publication service.");
    }

    /*
     * Loose catch block
     */
    public Publication replaceSync(MediaPackage mediaPackage, String channelId, Collection<? extends MediaPackageElement> addElements, Set<String> retractElementIds) throws PublicationException, MediaPackageException {
        HttpResponse response;
        block7: {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("mediapackage", MediaPackageParser.getAsXml((MediaPackage)mediaPackage)));
            params.add(new BasicNameValuePair("channel", channelId));
            params.add(new BasicNameValuePair("addElements", MediaPackageElementParser.getArrayAsXml(addElements)));
            params.add(new BasicNameValuePair("retractElements", this.gson.toJson(retractElementIds)));
            HttpPost post = new HttpPost("/replacesync");
            response = null;
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
            response = this.getResponse((HttpRequestBase)post);
            if (response == null) break block7;
            logger.info("Publishing media package {} to channel {} using a remote publication service", (Object)mediaPackage, (Object)channelId);
            String xml = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.forName("utf-8"));
            Publication publication = (Publication)MediaPackageElementParser.getFromXml((String)xml);
            this.closeConnection(response);
            return publication;
            {
                catch (Exception e) {
                    try {
                        throw new PublicationException("Unable to publish media package '" + mediaPackage + "' using a remote publication service", (Throwable)e);
                    }
                    catch (Exception e2) {
                        try {
                            throw new PublicationException("Unable to publish media package " + mediaPackage + " using a remote publication service.", (Throwable)e2);
                        }
                        catch (Throwable throwable) {
                            this.closeConnection(response);
                            throw throwable;
                        }
                    }
                }
            }
        }
        this.closeConnection(response);
        throw new PublicationException("Unable to publish mediapackage " + mediaPackage + " using a remote publication service.");
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

