/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.oaipmh.util;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Stream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.XmlSafeParser;
import org.opencastproject.util.data.Function;
import org.opencastproject.util.data.Function0;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.functions.Misc;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XmlGen {
    private final Document document;
    private final Option<String> defaultNamespace;
    protected Function0<Node> nodeZero = new Function0<Node>(){

        public Node apply() {
            return XmlGen.this.nodeZero();
        }
    };
    protected Function<String, Node> mkText = new Function<String, Node>(){

        public Node apply(String token) {
            return XmlGen.this.$txt(token);
        }
    };

    public XmlGen(Option<String> defaultNamespace) {
        this.document = this.createDocument();
        this.defaultNamespace = defaultNamespace;
    }

    private Document createDocument() {
        try {
            DocumentBuilderFactory factory = XmlSafeParser.newDocumentBuilderFactory();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            return (Document)Misc.chuck((Throwable)e);
        }
    }

    private void write(OutputStream out) {
        try {
            Transformer transformer = XmlSafeParser.newTransformerFactory().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public void generate(OutputStream out) {
        this.generate();
        this.write(out);
    }

    public Document generate() {
        Node node = this.document.importNode(this.create(), true);
        Element docElem = this.document.getDocumentElement();
        if (docElem != null) {
            this.document.removeChild(docElem);
        }
        this.document.appendChild(node);
        return this.document;
    }

    public String generateAsString() {
        return (String)IoSupport.withResource((Closeable)new ByteArrayOutputStream(), (Function)new Function<ByteArrayOutputStream, String>(){

            public String apply(ByteArrayOutputStream out) {
                XmlGen.this.generate((OutputStream)out);
                return out.toString();
            }
        });
    }

    public abstract Element create();

    protected Namespace ns(String prefix, String namespace) {
        return new Namespace(prefix, namespace);
    }

    protected Node schemaLocation(String location) {
        return this.$a("xsi:schemaLocation", location);
    }

    protected Node $langNode(String language) {
        if (StringUtils.isBlank((CharSequence)language) || "__".equals(language) || "**".equals(language)) {
            return this.nodeZero();
        }
        Attr a = this.document.createAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang");
        a.setValue(language);
        return a;
    }

    protected Node $a(String name, String value) {
        Attr a = this.document.createAttribute(name);
        a.setValue(value);
        return a;
    }

    protected Node $aBlank(String name, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            Attr a = this.document.createAttribute(name);
            a.setValue(value);
            return a;
        }
        return this.nodeZero();
    }

    protected Node $aSome(final String name, Option<String> value) {
        return (Node)value.fold((Option.Match)new Option.Match<String, Node>(){

            public Node some(String value) {
                Attr a = XmlGen.this.document.createAttribute(name);
                a.setValue(value);
                return a;
            }

            public Node none() {
                return XmlGen.this.nodeZero();
            }
        });
    }

    protected Element $e(String qname, Option<String> namespace, List<Node> nodes) {
        return this.appendTo(this.createElemNs(namespace, qname), nodes);
    }

    protected Element $e(String qname, Option<String> namespace, NodeList nodes) {
        return this.appendTo(this.createElemNs(namespace, qname), nodes);
    }

    protected Element $e(String qname, Option<String> namespace, Node ... nodes) {
        return this.$e(qname, namespace, Arrays.asList(nodes));
    }

    protected Element $e(String name, Node ... nodes) {
        return this.$e(name, this.defaultNamespace, Arrays.asList(nodes));
    }

    protected Element $e(String name, List<Node> nodes) {
        return this.$e(name, this.defaultNamespace, Collections.unmodifiableList(nodes));
    }

    protected Element $e(String qname, String namespace, Node ... nodes) {
        return this.$e(qname, (Option<String>)Option.some((Object)namespace), Arrays.asList(nodes));
    }

    protected Element $e(String qname, String namespace, List<Node> nodes) {
        return this.$e(qname, (Option<String>)Option.some((Object)namespace), nodes);
    }

    protected Node $eTxtBlank(final String name, String text) {
        return (Node)this.$txtBlank(text).map((Function)new Function<Node, Node>(){

            public Node apply(Node text) {
                Element e = XmlGen.this.createElemDefaultNs(name);
                e.appendChild(text);
                return e;
            }
        }).getOrElse(this.nodeZero);
    }

    protected Node $eTxt(String name, String text) {
        Element e = this.createElemDefaultNs(name);
        e.appendChild(this.$txt(text));
        return e;
    }

    protected Node $eTxt(String qname, String namespace, String text) {
        Element e = this.createElemNs(namespace, qname);
        e.appendChild(this.$txt(text));
        return e;
    }

    protected Element $e(String name, List<Namespace> namespaces, Node ... nodes) {
        return this.appendTo(this.appendNs(this.createElemDefaultNs(name), namespaces), Arrays.asList(nodes));
    }

    protected Element $e(String name, List<Namespace> namespaces, NodeList nodes) {
        return this.appendTo(this.appendNs(this.createElemDefaultNs(name), namespaces), nodes);
    }

    protected Element $e(String name, List<Namespace> namespaces, List<Node> nodes) {
        return this.appendTo(this.appendNs(this.createElemDefaultNs(name), namespaces), nodes);
    }

    protected Element $e(String qname, String namespace, List<Namespace> namespaces, Node ... nodes) {
        return this.appendTo(this.appendNs(this.createElemNs(namespace, qname), namespaces), Arrays.asList(nodes));
    }

    private Element createElemDefaultNs(String name) {
        return this.createElemNs(this.defaultNamespace, name);
    }

    private Element createElemNs(Option<String> namespace, String qname) {
        return this.createElemNs((String)namespace.getOrElseNull(), qname);
    }

    private Element createElemNs(String namespace, String qname) {
        return this.document.createElementNS(namespace, qname);
    }

    protected Element $e(String qname, String namespace, List<Namespace> namespaces, List<Node> nodes) {
        return this.appendTo(this.appendNs(this.createElemNs(namespace, qname), namespaces), nodes);
    }

    protected Node $e(String name, Option<Node> ... nodes) {
        List<Node> existing = this.filter(Arrays.asList(nodes));
        if (!existing.isEmpty()) {
            return this.$e(name, existing);
        }
        return this.nodeZero();
    }

    protected Node $txt(String text) {
        return this.document.createTextNode(text);
    }

    protected Node $cdata(String text) {
        return this.document.createCDATASection(text);
    }

    protected Option<Node> $txtBlank(String text) {
        return StringUtils.isNotBlank((CharSequence)text) ? Option.some((Object)this.$txt(text)) : Option.none();
    }

    private List<Node> filter(List<Option<Node>> nodes) {
        return Stream.$(nodes).bind((Fn)new Fn<Option<Node>, Collection<Node>>(){

            public Collection<Node> apply(Option<Node> nodeOption) {
                return (Collection)nodeOption.fold((Option.Match)new Option.Match<Node, Collection<Node>>(){

                    public Collection<Node> some(Node node) {
                        return Collections.singletonList(node);
                    }

                    public Collection<Node> none() {
                        return Collections.emptyList();
                    }
                });
            }
        }).toList();
    }

    private Element appendNs(Element e, List<Namespace> namespaces) {
        for (Namespace n : namespaces) {
            e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + n.getPrefix(), n.getNamespace());
        }
        return e;
    }

    private Element appendTo(Element e, List<Node> nodes) {
        for (Node node : nodes) {
            this.appendTo(e, node);
        }
        return e;
    }

    private Element appendTo(Element e, NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            this.appendTo(e, nodes.item(i));
        }
        return e;
    }

    private void appendTo(Element e, Node n) {
        Node toAppend;
        Node node = toAppend = ObjectUtils.equals((Object)n.getOwnerDocument(), (Object)this.document) ? n : this.document.importNode(n, true);
        if (toAppend instanceof Attr) {
            e.setAttributeNode((Attr)toAppend);
        } else {
            e.appendChild(toAppend);
        }
    }

    protected Node nodeZero() {
        return this.document.createTextNode("");
    }

    protected class Namespace {
        private final String prefix;
        private final String namespace;

        Namespace(String prefix, String namespace) {
            this.prefix = prefix;
            this.namespace = namespace;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }
}

