/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.oaipmh.util;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.map.LRUMap;
import org.opencastproject.oaipmh.server.ResumableQuery;
import org.opencastproject.util.data.Option;

public final class ResumptionTokenStore {
    private final Map<String, ResumableQuery> resumptionTokens;

    private ResumptionTokenStore(int size) {
        this.resumptionTokens = Collections.synchronizedMap(new LRUMap(size));
    }

    public static ResumptionTokenStore create() {
        return new ResumptionTokenStore(100);
    }

    public static ResumptionTokenStore create(int size) {
        return new ResumptionTokenStore(size);
    }

    public String put(ResumableQuery query) {
        String token = DigestUtils.md5Hex((String)Double.toString(Math.random()));
        this.resumptionTokens.put(token, query);
        return token;
    }

    public Option<ResumableQuery> get(String resumptionToken) {
        return Option.option((Object)this.resumptionTokens.get(resumptionToken));
    }
}

