/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.oaipmh.util;

import java.util.Dictionary;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;

public final class OsgiUtil {
    private OsgiUtil() {
    }

    public static String getContextProperty(ComponentContext cc, String key) {
        String p = cc.getBundleContext().getProperty(key);
        if (StringUtils.isBlank((CharSequence)p)) {
            throw new RuntimeException("Please provide bundle context property " + key);
        }
        return p;
    }

    public static String getCfg(Dictionary d, String key) throws ConfigurationException {
        Object p = d.get(key);
        if (p == null) {
            throw new ConfigurationException(key, "does not exist");
        }
        String ps = p.toString();
        if (StringUtils.isBlank((CharSequence)ps)) {
            throw new ConfigurationException(key, "is blank");
        }
        return ps;
    }

    public static int getCfgAsInt(Dictionary d, String key) throws ConfigurationException {
        try {
            return Integer.parseInt(OsgiUtil.getCfg(d, key));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(key, "not an integer");
        }
    }

    public static void checkDictionary(Dictionary properties, ComponentContext componentContext) throws ConfigurationException {
        if (properties == null) {
            String dicName = componentContext.getProperties().get("service.pid").toString();
            throw new ConfigurationException("*", "Dictionary for " + dicName + " does not exist");
        }
    }
}

