/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.oaipmh.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.opencastproject.util.data.Function0;

public final class ConcurrencyUtil {
    private ConcurrencyUtil() {
    }

    public static void shutdownAndAwaitTermination(ExecutorService exe, int waitSeconds, Function0<Void> executorDoesNotTerminate) {
        exe.shutdown();
        try {
            if (!exe.awaitTermination(waitSeconds, TimeUnit.SECONDS)) {
                exe.shutdownNow();
                if (!exe.awaitTermination(waitSeconds, TimeUnit.SECONDS)) {
                    executorDoesNotTerminate.apply();
                }
            }
        }
        catch (InterruptedException ie) {
            exe.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

