/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.oaipmh.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.oaipmh.OaiPmhUtil;
import org.opencastproject.oaipmh.persistence.OaiPmhDatabaseException;
import org.opencastproject.oaipmh.persistence.SearchResult;
import org.opencastproject.oaipmh.persistence.SearchResultItem;
import org.opencastproject.oaipmh.server.MetadataFormat;
import org.opencastproject.oaipmh.server.OaiPmhRepository;
import org.opencastproject.oaipmh.server.Params;
import org.opencastproject.oaipmh.server.ResumableQuery;
import org.opencastproject.oaipmh.util.XmlGen;
import org.opencastproject.util.data.Function;
import org.opencastproject.util.data.Option;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class OaiXmlGen
extends XmlGen {
    protected OaiPmhRepository repository;

    public OaiXmlGen(OaiPmhRepository repository) {
        super((Option<String>)Option.some((Object)"http://www.openarchives.org/OAI/2.0/"));
        this.repository = repository;
    }

    Element oai(Node ... nodes) {
        ArrayList<Node> combined = new ArrayList<Node>();
        combined.add(this.schemaLocation("http://www.openarchives.org/OAI/2.0/ http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd"));
        combined.add(this.$eTxt("responseDate", "http://www.openarchives.org/OAI/2.0/", OaiPmhUtil.toUtcSecond(new Date())));
        Collections.addAll(combined, nodes);
        return this.$e("OAI-PMH", Collections.singletonList(this.ns("xsi", "http://www.w3.org/2001/XMLSchema-instance")), combined);
    }

    Element dc(Node ... nodes) {
        ArrayList<Node> combined = new ArrayList<Node>(Arrays.asList(nodes));
        combined.add(this.schemaLocation("http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd"));
        return this.$e("oai_dc:dc", "http://www.openarchives.org/OAI/2.0/oai_dc/", Arrays.asList(this.ns("dc", "http://purl.org/dc/elements/1.1/"), this.ns("xsi", "http://www.w3.org/2001/XMLSchema-instance")), combined);
    }

    Element dc(SearchResultItem item, Option<String> set) {
        try {
            return this.getDublincoreElement(item.getEpisodeDublinCore());
        }
        catch (OaiPmhDatabaseException ex) {
            return this.dc(this.$e("dc:identifier", this.$txtBlank(item.getId())));
        }
    }

    private Element getDublincoreElement(DublinCoreCatalog dc) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll(this.getDublinCoreNodes(dc, DublinCore.PROPERTY_TITLE));
        nodes.addAll(this.getDublinCoreNodes(dc, DublinCore.PROPERTY_CREATOR));
        nodes.addAll(this.getDublinCoreNodes(dc, DublinCore.PROPERTY_SUBJECT));
        nodes.addAll(this.getDublinCoreNodes(dc, DublinCore.PROPERTY_DESCRIPTION));
        nodes.addAll(this.getDublinCoreNodes(dc, DublinCore.PROPERTY_PUBLISHER));
        nodes.addAll(this.getDublinCoreNodes(dc, DublinCore.PROPERTY_CONTRIBUTOR));
        nodes.addAll(this.getDublinCoreNodes(dc, DublinCore.PROPERTY_TYPE));
        nodes.addAll(this.getDublinCoreNodes(dc, DublinCore.PROPERTY_FORMAT));
        nodes.addAll(this.getDublinCoreNodes(dc, DublinCore.PROPERTY_IDENTIFIER));
        nodes.addAll(this.getDublinCoreNodes(dc, DublinCore.PROPERTY_SOURCE));
        nodes.addAll(this.getDublinCoreNodes(dc, DublinCore.PROPERTY_LANGUAGE));
        nodes.addAll(this.getDublinCoreNodes(dc, DublinCore.PROPERTY_RELATION));
        nodes.addAll(this.getDublinCoreNodes(dc, DublinCore.PROPERTY_COVERAGE));
        nodes.addAll(this.getDublinCoreNodes(dc, DublinCore.PROPERTY_LICENSE));
        return this.dc(nodes.toArray(new Node[nodes.size()]));
    }

    private List<Node> getDublinCoreNodes(DublinCoreCatalog dc, EName eName) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        List values = dc.get(eName);
        for (DublinCoreValue dcValue : values) {
            Element element = this.$e("dc:" + eName.getLocalName(), this.$langNode(dcValue.getLanguage()), this.$txt(dcValue.getValue()));
            nodes.add(element);
        }
        return nodes;
    }

    Node resumptionToken(Option<String> resumptionToken, String metadataPrefix, SearchResult result, Date until, Option<String> set) {
        Option token;
        if (result.size() == result.getLimit()) {
            SearchResultItem lastResult = (SearchResultItem)result.getItems().get((int)(result.size() - 1L));
            token = Option.some((Object)Option.some((Object)this.repository.saveQuery(new ResumableQuery(metadataPrefix, lastResult.getModificationDate(), until, set))));
        } else {
            token = resumptionToken.isSome() ? Option.some((Object)Option.none()) : Option.none();
        }
        return (Node)token.map((Function)new Function<Option<String>, Node>(){

            public Node apply(Option<String> token) {
                return OaiXmlGen.this.$e("resumptionToken", new Node[]{(Node)token.map(OaiXmlGen.this.mkText).getOrElse(OaiXmlGen.this.nodeZero)});
            }
        }).getOrElse(this.nodeZero);
    }

    Element record(SearchResultItem item, Node metadata) {
        if (item.isDeleted()) {
            return this.$e("record", this.header(item));
        }
        return this.$e("record", this.header(item), this.$e("metadata", metadata));
    }

    Element metadataFormat(MetadataFormat f) {
        return this.$e("metadataFormat", this.$eTxt("metadataPrefix", f.getPrefix()), this.$eTxt("schema", f.getSchema().toString()), this.$eTxt("metadataNamespace", f.getNamespace().toString()));
    }

    Node metadataPrefixAttr(Params p) {
        return this.$aSome("metadataPrefix", p.getMetadataPrefix());
    }

    Element header(SearchResultItem item) {
        Element header = this.$e("header", this.$eTxt("identifier", item.getId()), this.$eTxt("datestamp", this.repository.toSupportedGranularity(item.getModificationDate())));
        if (item.isDeleted()) {
            header.setAttribute("status", "deleted");
        }
        for (String setSpec : item.getSetSpecs()) {
            header.appendChild(this.$eTxt("setSpec", setSpec));
        }
        return header;
    }

    protected List<Node> merge(Node[] a, Node ... b) {
        ArrayList<Node> merge = new ArrayList<Node>(a.length + b.length);
        Collections.addAll(merge, a);
        Collections.addAll(merge, b);
        return merge;
    }
}

