/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.oaipmh.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.oaipmh.server.OaiPmhRepository;
import org.opencastproject.oaipmh.server.OaiPmhServerInfo;
import org.opencastproject.oaipmh.server.OaiPmhServerInfoUtil;
import org.opencastproject.oaipmh.server.Params;
import org.opencastproject.oaipmh.util.XmlGen;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Collections;
import org.opencastproject.util.data.Monadics;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.data.functions.Strings;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={OaiPmhServerInfo.class, OaiPmhServer.class}, property={"service.description=OAI-PMH server"})
public final class OaiPmhServer
extends HttpServlet
implements OaiPmhServerInfo {
    private static final long serialVersionUID = -7536526468920288612L;
    private static final Logger logger = LoggerFactory.getLogger(OaiPmhServer.class);
    private static final String CFG_DEFAULT_REPOSITORY = "default-repository";
    private static final String CFG_OAIPMH_MOUNTPOINT = "org.opencastproject.oaipmh.mountpoint";
    private static final String CFG_DEFAULT_OAIPMH_MOUNTPOINT = "/oaipmh";
    private SecurityService securityService;
    private final Map<String, OaiPmhRepository> repositories = Collections.map((Tuple[])new Tuple[0]);
    private ComponentContext componentContext;
    private String defaultRepo;
    private String mountPoint;
    private ServiceRegistration<?> serviceRegistration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetRepository")
    public void setRepository(OaiPmhRepository r) {
        Map<String, OaiPmhRepository> map = this.repositories;
        synchronized (map) {
            String rId = r.getRepositoryId();
            if (this.repositories.containsKey(rId)) {
                logger.error("A repository with id {} has already been registered", (Object)rId);
            } else {
                this.repositories.put(rId, r);
                logger.info("Registered repository " + rId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetRepository(OaiPmhRepository r) {
        Map<String, OaiPmhRepository> map = this.repositories;
        synchronized (map) {
            this.repositories.remove(r.getRepositoryId());
            logger.info("Unregistered repository " + r.getRepositoryId());
        }
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Activate
    public void activate(ComponentContext cc) throws ConfigurationException {
        logger.info("Activate");
        this.componentContext = cc;
        try {
            this.mountPoint = UrlSupport.concat((String)"/", (String)StringUtils.trimToNull((String)org.opencastproject.oaipmh.util.OsgiUtil.getContextProperty(this.componentContext, CFG_OAIPMH_MOUNTPOINT)));
        }
        catch (RuntimeException e) {
            this.mountPoint = CFG_DEFAULT_OAIPMH_MOUNTPOINT;
        }
        this.updated(cc.getProperties());
    }

    @Modified
    public void modified(ComponentContext cc) throws ConfigurationException {
        logger.info("Updated");
        this.updated(cc.getProperties());
    }

    @Deactivate
    public void deactivate() {
        this.tryUnregisterServlet();
    }

    public synchronized void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        org.opencastproject.oaipmh.util.OsgiUtil.checkDictionary(properties, this.componentContext);
        this.defaultRepo = org.opencastproject.oaipmh.util.OsgiUtil.getCfg(properties, CFG_DEFAULT_REPOSITORY);
        try {
            this.tryUnregisterServlet();
            logger.info("Registering OAI-PMH server under " + this.mountPoint);
            logger.info("Default repository is " + this.defaultRepo);
            this.serviceRegistration = OsgiUtil.registerServlet((BundleContext)this.componentContext.getBundleContext(), (Object)this, (String)this.mountPoint);
        }
        catch (Exception e) {
            logger.error("Error registering OAI-PMH servlet", (Throwable)e);
            throw new RuntimeException("Error registering OAI-PMH servlet", e);
        }
        logger.info("There are {} repositories registered yet. Watch out for later registration messages.", (Object)this.repositories.values().size());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.dispatch(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.dispatch(req, res);
    }

    private void dispatch(HttpServletRequest req, HttpServletResponse res) throws IOException {
        try {
            for (String serverUrl : OaiPmhServerInfoUtil.oaiPmhServerUrlOfCurrentOrganization(this.securityService)) {
                Iterator iterator = OaiPmhServer.repositoryId(req, this.mountPoint).iterator();
                if (iterator.hasNext()) {
                    String repoId = (String)iterator.next();
                    if (this.runRepo(repoId, serverUrl, req, res)) {
                        return;
                    }
                    res.sendError(404);
                    return;
                }
                if (!this.runRepo(this.defaultRepo, serverUrl, req, res)) continue;
                return;
            }
            res.sendError(503);
        }
        catch (Exception e) {
            logger.error("Error handling OAI-PMH request", (Throwable)e);
            res.sendError(500, e.getMessage());
        }
    }

    private boolean runRepo(String repoId, String serverUrl, HttpServletRequest req, HttpServletResponse res) throws Exception {
        Iterator iterator = this.getRepoById(repoId).iterator();
        if (iterator.hasNext()) {
            OaiPmhRepository repo = (OaiPmhRepository)iterator.next();
            String repoUrl = UrlSupport.concat((String[])new String[]{serverUrl, this.mountPoint, repoId});
            this.runRepo(repo, repoUrl, req, res);
            return true;
        }
        return false;
    }

    private void runRepo(OaiPmhRepository repo, final String repoUrl, final HttpServletRequest req, HttpServletResponse res) throws Exception {
        Params p = new Params(){

            @Override
            String getParameter(String key) {
                return req.getParameter(key);
            }

            @Override
            String getRepositoryUrl() {
                return repoUrl;
            }
        };
        XmlGen oai = repo.selectVerb(p);
        res.setCharacterEncoding("UTF-8");
        res.setContentType("text/xml;charset=UTF-8");
        oai.generate((OutputStream)res.getOutputStream());
    }

    private synchronized void tryUnregisterServlet() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    public static Option<String> repositoryId(HttpServletRequest req, String mountPoint) {
        return Monadics.mlist((Object[])StringUtils.removeStart((String)UrlSupport.removeDoubleSeparator((String)req.getRequestURI()), (String)mountPoint).split("/")).bind(Strings.trimToNil).headOpt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Option<OaiPmhRepository> getRepoById(String id) {
        Map<String, OaiPmhRepository> map = this.repositories;
        synchronized (map) {
            if (this.hasRepo(id)) {
                return Option.some((Object)this.repositories.get(id));
            }
            logger.warn("No OAI-PMH repository has been registered with id " + id);
            return Option.none();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRepo(String id) {
        Map<String, OaiPmhRepository> map = this.repositories;
        synchronized (map) {
            return this.repositories.containsKey(id);
        }
    }

    @Override
    public String getMountPoint() {
        return this.mountPoint;
    }
}

