/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.oaipmh.server;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.oaipmh.Granularity;
import org.opencastproject.oaipmh.OaiPmhConstants;
import org.opencastproject.oaipmh.OaiPmhUtil;
import org.opencastproject.oaipmh.persistence.OaiPmhDatabase;
import org.opencastproject.oaipmh.persistence.OaiPmhDatabaseException;
import org.opencastproject.oaipmh.persistence.OaiPmhSetDefinition;
import org.opencastproject.oaipmh.persistence.OaiPmhSetDefinitionImpl;
import org.opencastproject.oaipmh.persistence.QueryBuilder;
import org.opencastproject.oaipmh.persistence.SearchResult;
import org.opencastproject.oaipmh.persistence.SearchResultItem;
import org.opencastproject.oaipmh.server.Functions;
import org.opencastproject.oaipmh.server.ListGenParams;
import org.opencastproject.oaipmh.server.MetadataProvider;
import org.opencastproject.oaipmh.server.OaiDcMetadataProvider;
import org.opencastproject.oaipmh.server.OaiVerbXmlGen;
import org.opencastproject.oaipmh.server.OaiXmlGen;
import org.opencastproject.oaipmh.server.Params;
import org.opencastproject.oaipmh.server.ResumableQuery;
import org.opencastproject.oaipmh.util.XmlGen;
import org.opencastproject.util.data.Function;
import org.opencastproject.util.data.Function0;
import org.opencastproject.util.data.Monadics;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Predicate;
import org.opencastproject.util.data.Prelude;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.data.functions.Misc;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class OaiPmhRepository
implements ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(OaiPmhRepository.class);
    private static final OaiDcMetadataProvider OAI_DC_METADATA_PROVIDER = new OaiDcMetadataProvider();
    private static final String OAI_NS = "http://www.openarchives.org/OAI/2.0/";
    private static final String CONF_KEY_SET_PREFIX = "set.";
    private static final String CONF_KEY_SET_SETSPEC_SUFFIX = ".setSpec";
    private static final String CONF_KEY_SET_NAME_SUFFIX = ".name";
    private static final String CONF_KEY_SET_DESCRIPTION_SUFFIX = ".description";
    private static final String CONF_KEY_SET_FILTER_INFIX = ".filter.";
    private static final String CONF_KEY_SET_FILTER_FLAVOR_SUFFIX = ".flavor";
    private static final String CONF_KEY_SET_FILTER_CONTAINS_SUFFIX = ".contains";
    private static final String CONF_KEY_SET_FILTER_CONTAINSNOT_SUFFIX = ".containsnot";
    private static final String CONF_KEY_SET_FILTER_MATCH_SUFFIX = ".match";
    private List<OaiPmhSetDefinition> sets = new ArrayList<OaiPmhSetDefinition>();
    private final Function<String, Option<MetadataProvider>> getMetadataProvider = new Function<String, Option<MetadataProvider>>(){

        public Option<MetadataProvider> apply(String metadataPrefix) {
            return OaiPmhRepository.this.getMetadataProvider(metadataPrefix);
        }
    };
    final Function<Date, String> toSupportedGranularity = new Function<Date, String>(){

        public String apply(Date date) {
            return OaiPmhRepository.this.toSupportedGranularity(date);
        }
    };
    private final Function<Date, Date> granulate = new Function<Date, Date>(){

        public Date apply(Date date) {
            return OaiPmhRepository.granulate(OaiPmhRepository.this.getRepositoryTimeGranularity(), date);
        }
    };

    public abstract Granularity getRepositoryTimeGranularity();

    public abstract String getRepositoryName();

    public abstract String getRepositoryId();

    public abstract OaiPmhDatabase getPersistence();

    public abstract String getAdminEmail();

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            return;
        }
        this.sets = new ArrayList<OaiPmhSetDefinition>();
        List confKeys = EnumerationUtils.toList(properties.keys());
        for (String confKey : confKeys) {
            if (!confKey.startsWith(CONF_KEY_SET_PREFIX) || !confKey.endsWith(CONF_KEY_SET_SETSPEC_SUFFIX)) continue;
            String confKeyPrefix = confKey.replace(CONF_KEY_SET_SETSPEC_SUFFIX, "");
            String setSpec = (String)properties.get(confKey);
            String setSpecName = (String)properties.get(confKeyPrefix + CONF_KEY_SET_NAME_SUFFIX);
            String setDescription = null;
            if (confKey.contains(confKeyPrefix + CONF_KEY_SET_DESCRIPTION_SUFFIX)) {
                setDescription = (String)properties.get(confKeyPrefix + CONF_KEY_SET_DESCRIPTION_SUFFIX);
            }
            try {
                OaiPmhSetDefinitionImpl setDefinition = OaiPmhSetDefinitionImpl.build((String)setSpec, (String)setSpecName, setDescription);
                List confKeyFilterNames = confKeys.stream().filter(key -> key.startsWith(confKeyPrefix + CONF_KEY_SET_FILTER_INFIX) && key.endsWith(CONF_KEY_SET_FILTER_FLAVOR_SUFFIX)).map(key -> key.replace(confKeyPrefix + CONF_KEY_SET_FILTER_INFIX, "").replace(CONF_KEY_SET_FILTER_FLAVOR_SUFFIX, "")).distinct().collect(Collectors.toList());
                for (String filterName : confKeyFilterNames) {
                    String setSpecFilterFlavor = (String)properties.get(confKeyPrefix + CONF_KEY_SET_FILTER_INFIX + filterName + CONF_KEY_SET_FILTER_FLAVOR_SUFFIX);
                    List confKeyCriteria = confKeys.stream().filter(key -> key.startsWith(confKeyPrefix + CONF_KEY_SET_FILTER_INFIX + filterName) && (key.endsWith(CONF_KEY_SET_FILTER_CONTAINS_SUFFIX) || key.endsWith(CONF_KEY_SET_FILTER_CONTAINSNOT_SUFFIX) || key.endsWith(CONF_KEY_SET_FILTER_MATCH_SUFFIX))).distinct().collect(Collectors.toList());
                    for (String confKeyCriterion : confKeyCriteria) {
                        String criterion = null;
                        if (confKeyCriterion.endsWith(CONF_KEY_SET_FILTER_CONTAINS_SUFFIX)) {
                            criterion = "contains";
                        } else if (confKeyCriterion.endsWith(CONF_KEY_SET_FILTER_CONTAINSNOT_SUFFIX)) {
                            criterion = "containsnot";
                        } else if (confKeyCriterion.endsWith(CONF_KEY_SET_FILTER_MATCH_SUFFIX)) {
                            criterion = "match";
                        } else {
                            logger.warn("Configuration key {} not valid.", (Object)confKeyCriterion);
                            continue;
                        }
                        setDefinition.addFilter(filterName, setSpecFilterFlavor, criterion, (String)properties.get(confKeyCriterion));
                    }
                }
                if (setDefinition.getFilters().isEmpty()) {
                    logger.warn("No filter criteria defined for OAI-PMH set definition {}.", (Object)setDefinition.getSetSpec());
                    continue;
                }
                this.sets.add((OaiPmhSetDefinition)setDefinition);
                logger.debug("OAI-PMH set difinition {} initialized.", (Object)setDefinition.getSetSpec());
            }
            catch (IllegalArgumentException e) {
                logger.warn("Unable to parse OAI-PMH set definition for setSpec {}.", (Object)setSpec, (Object)e);
            }
        }
    }

    public abstract String saveQuery(ResumableQuery var1);

    public abstract Option<ResumableQuery> getSavedQuery(String var1);

    public abstract int getResultLimit();

    public abstract List<MetadataProvider> getRepositoryMetadataProviders();

    public Date currentDate() {
        return new Date();
    }

    public final List<MetadataProvider> getMetadataProviders() {
        return Monadics.mlist(this.getRepositoryMetadataProviders()).cons((Object)OAI_DC_METADATA_PROVIDER).value();
    }

    public void addItem(MediaPackage mp) {
        this.getPersistence().search(QueryBuilder.queryRepo((String)this.getRepositoryId()).build());
        try {
            this.getPersistence().store(mp, this.getRepositoryId());
        }
        catch (OaiPmhDatabaseException e) {
            Misc.chuck((Throwable)e);
        }
    }

    public XmlGen selectVerb(Params p) {
        if (p.isVerbListIdentifiers()) {
            return this.handleListIdentifiers(p);
        }
        if (p.isVerbListRecords()) {
            return this.handleListRecords(p);
        }
        if (p.isVerbGetRecord()) {
            return this.handleGetRecord(p);
        }
        if (p.isVerbIdentify()) {
            return this.handleIdentify(p);
        }
        if (p.isVerbListMetadataFormats()) {
            return this.handleListMetadataFormats(p);
        }
        if (p.isVerbListSets()) {
            return this.handleListSets(p);
        }
        return this.createErrorResponse("badVerb", (Option<String>)Option.none(), p.getRepositoryUrl(), "Illegal OAI verb or verb is missing.");
    }

    public Option<MetadataProvider> getMetadataProvider(final String metadataPrefix) {
        return Monadics.mlist(this.getMetadataProviders()).find((Function)new Predicate<MetadataProvider>(){

            public Boolean apply(MetadataProvider metadataProvider) {
                return metadataProvider.getMetadataFormat().getPrefix().equals(metadataPrefix);
            }
        });
    }

    private XmlGen handleGetRecord(Params p) {
        if (p.getIdentifier().isNone() || p.getMetadataPrefix().isNone()) {
            return this.createBadArgumentResponse(p);
        }
        Iterator iterator = p.getMetadataPrefix().bind(this.getMetadataProvider).iterator();
        if (iterator.hasNext()) {
            final MetadataProvider metadataProvider = (MetadataProvider)iterator.next();
            if (p.getSet().isSome() && !this.sets.stream().anyMatch(setDef -> StringUtils.equals((CharSequence)setDef.getSetSpec(), (CharSequence)((CharSequence)p.getSet().get())))) {
                return this.createNoRecordsMatchResponse(p);
            }
            SearchResult res = this.getPersistence().search(QueryBuilder.queryRepo((String)this.getRepositoryId()).mediaPackageId(p.getIdentifier()).setDefinitions(this.sets).setSpec((String)p.getSet().getOrElseNull()).build());
            List items = res.getItems();
            switch (items.size()) {
                case 0: {
                    return this.createIdDoesNotExistResponse(p);
                }
                case 1: {
                    final SearchResultItem item = (SearchResultItem)items.get(0);
                    return new OaiVerbXmlGen(this, p){

                        @Override
                        public Element create() {
                            Element metadata = metadataProvider.createMetadata(OaiPmhRepository.this, item, this.p.getSet());
                            return this.oai(this.request(this.$a("identifier", (String)this.p.getIdentifier().get()), this.metadataPrefixAttr(this.p)), this.verb(this.record(item, metadata)));
                        }
                    };
                }
            }
            throw new RuntimeException("ERROR: Search index contains more than one item with id " + p.getIdentifier());
        }
        return this.createCannotDisseminateFormatResponse(p);
    }

    private XmlGen handleIdentify(Params p) {
        return new OaiVerbXmlGen(this, p){

            @Override
            public Element create() {
                return this.oai(this.request(new Node[0]), this.verb(this.$eTxt("repositoryName", OaiPmhRepository.OAI_NS, OaiPmhRepository.this.getRepositoryName()), this.$eTxt("baseURL", OaiPmhRepository.OAI_NS, this.p.getRepositoryUrl()), this.$eTxt("protocolVersion", OaiPmhRepository.OAI_NS, "2.0"), this.$eTxt("adminEmail", OaiPmhRepository.OAI_NS, OaiPmhRepository.this.getAdminEmail()), this.$eTxt("earliestDatestamp", OaiPmhRepository.OAI_NS, "2010-01-01"), this.$eTxt("deletedRecord", OaiPmhRepository.OAI_NS, "transient"), this.$eTxt("granularity", OaiPmhRepository.OAI_NS, OaiPmhUtil.toOaiRepresentation(OaiPmhRepository.this.getRepositoryTimeGranularity()))));
            }
        };
    }

    private XmlGen handleListMetadataFormats(Params p) {
        for (String id : p.getIdentifier()) {
            SearchResult res = this.getPersistence().search(QueryBuilder.queryRepo((String)this.getRepositoryId()).mediaPackageId(id).build());
            if (res.getItems().size() == 1) continue;
            return this.createIdDoesNotExistResponse(p);
        }
        return new OaiVerbXmlGen(this, p){

            @Override
            public Element create() {
                List metadataFormats = Monadics.mlist(OaiPmhRepository.this.getMetadataProviders()).map((Function)new Function<MetadataProvider, Node>(){

                    public Node apply(MetadataProvider metadataProvider) {
                        return this.metadataFormat(metadataProvider.getMetadataFormat());
                    }
                }).value();
                return this.oai(this.request(this.$aSome("identifier", this.p.getIdentifier())), this.verb(metadataFormats));
            }
        };
    }

    private XmlGen handleListRecords(Params p) {
        ListItemsEnv env = new ListItemsEnv(){

            @Override
            protected ListItemsEnv.ListXmlGen respond(ListGenParams listParams) {
                return new ListItemsEnv.ListXmlGen(listParams){

                    @Override
                    protected List<Node> createContent(final Option<String> set) {
                        return Monadics.mlist((List)this.params.getResult().getItems()).map((Function)new Function<SearchResultItem, Node>(){

                            public Node apply(SearchResultItem item) {
                                logger.debug("Requested set: {}", (Object)set);
                                Element metadata = params.getMetadataProvider().createMetadata(OaiPmhRepository.this, item, (Option<String>)set);
                                return this.record(item, metadata);
                            }
                        }).value();
                    }
                };
            }
        };
        return env.apply(p);
    }

    private XmlGen handleListIdentifiers(Params p) {
        ListItemsEnv env = new ListItemsEnv(){

            @Override
            protected ListItemsEnv.ListXmlGen respond(ListGenParams listParams) {
                return new ListItemsEnv.ListXmlGen(listParams){

                    @Override
                    protected List<Node> createContent(Option<String> set) {
                        return Monadics.mlist((List)this.params.getResult().getItems()).map((Function)new Function<SearchResultItem, Node>(){

                            public Node apply(SearchResultItem item) {
                                return this.header(item);
                            }
                        }).value();
                    }
                };
            }
        };
        return env.apply(p);
    }

    private XmlGen handleListSets(Params p) {
        return new OaiVerbXmlGen(this, p){

            @Override
            public Element create() {
                if (OaiPmhRepository.this.sets.isEmpty()) {
                    return OaiPmhRepository.this.createNoSetHierarchyResponse(this.p).create();
                }
                LinkedList<Node> setNodes = new LinkedList<Node>();
                OaiPmhRepository.this.sets.forEach(set -> {
                    String setSpec = set.getSetSpec();
                    String name = set.getName();
                    String description = set.getDescription();
                    if (StringUtils.isNotBlank((CharSequence)description)) {
                        setNodes.add(this.$e("set", this.$eTxt("setSpec", setSpec), this.$eTxt("setName", name), this.$e("setDescription", this.dc(this.$eTxt("dc:description", description)))));
                    } else {
                        setNodes.add(this.$e("set", this.$eTxt("setSpec", setSpec), this.$eTxt("setName", name)));
                    }
                });
                return this.oai(this.request(new Node[0]), this.verb(setNodes));
            }
        };
    }

    private XmlGen createCannotDisseminateFormatResponse(Params p) {
        return this.createErrorResponse("cannotDisseminateFormat", p.getVerb(), p.getRepositoryUrl(), "The metadata format identified by the value given for the metadataPrefix argument is not supported by the item or by the repository.");
    }

    private XmlGen createIdDoesNotExistResponse(Params p) {
        return this.createErrorResponse("idDoesNotExist", p.getVerb(), p.getRepositoryUrl(), String.format("The requested id %s does not exist in the repository.", p.getIdentifier().getOrElse((Object)"?")));
    }

    private XmlGen createBadArgumentResponse(Params p) {
        return this.createErrorResponse("badArgument", p.getVerb(), p.getRepositoryUrl(), "The request includes illegal arguments or is missing required arguments.");
    }

    private XmlGen createBadResumptionTokenResponse(Params p) {
        return this.createErrorResponse("badResumptionToken", p.getVerb(), p.getRepositoryUrl(), "The value of the resumptionToken argument is either invalid or expired.");
    }

    private XmlGen createNoRecordsMatchResponse(Params p) {
        return this.createErrorResponse("noRecordsMatch", p.getVerb(), p.getRepositoryUrl(), "The combination of the values of the from, until, and set arguments results in an empty list.");
    }

    private XmlGen createNoSetHierarchyResponse(Params p) {
        return this.createErrorResponse("noSetHierarchy", p.getVerb(), p.getRepositoryUrl(), "This repository does not support sets");
    }

    private XmlGen createErrorResponse(final String code, final Option<String> verb, final String repositoryUrl, final String msg) {
        return new OaiXmlGen(this){

            @Override
            public Element create() {
                return this.oai(this.$e("request", OaiPmhRepository.OAI_NS, this.$aSome("verb", (Option<String>)verb), this.$txt(repositoryUrl)), this.$e("error", OaiPmhRepository.OAI_NS, this.$a("code", code), this.$cdata(msg)));
            }
        };
    }

    String toSupportedGranularity(Date d) {
        return OaiPmhUtil.toUtc(d, this.getRepositoryTimeGranularity());
    }

    public static Date granulate(Granularity g, Date d) {
        switch (g) {
            case SECOND: {
                Calendar c = Calendar.getInstance();
                c.setTimeZone(OaiPmhUtil.newDateFormat().getTimeZone());
                c.setTime(d);
                c.set(14, 0);
                return c.getTime();
            }
            case DAY: {
                Calendar c = Calendar.getInstance();
                c.setTimeZone(OaiPmhUtil.newDateFormat().getTimeZone());
                c.setTime(d);
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
                c.set(14, 0);
                return c.getTime();
            }
        }
        return (Date)Prelude.unexhaustiveMatch();
    }

    abstract class ListItemsEnv {
        private final Function<String, Option<String>> getMetadataPrefixFromToken = new Function<String, Option<String>>(){

            public Option<String> apply(String token) {
                return OaiPmhRepository.this.getSavedQuery(token).map((Function)new Function<ResumableQuery, String>(){

                    public String apply(ResumableQuery resumableQuery) {
                        return resumableQuery.getMetadataPrefix();
                    }
                });
            }
        };
        private final Function<String, Option<MetadataProvider>> getMetadataProviderFromToken = new Function<String, Option<MetadataProvider>>(){

            public Option<MetadataProvider> apply(String token) {
                return OaiPmhRepository.this.getSavedQuery(token).flatMap((Function)new Function<ResumableQuery, Option<MetadataProvider>>(){

                    public Option<MetadataProvider> apply(ResumableQuery resumableQuery) {
                        return OaiPmhRepository.this.getMetadataProvider(resumableQuery.getMetadataPrefix());
                    }
                });
            }
        };

        ListItemsEnv() {
        }

        protected abstract ListXmlGen respond(ListGenParams var1);

        public XmlGen apply(Params p) {
            boolean otherParamExists;
            if (p.getSet().isSome() && OaiPmhRepository.this.sets.isEmpty()) {
                return OaiPmhRepository.this.createNoSetHierarchyResponse(p);
            }
            boolean resumptionTokenExists = p.getResumptionToken().isSome();
            boolean bl = otherParamExists = p.getMetadataPrefix().isSome() || p.getFrom().isSome() || p.getUntil().isSome() || p.getSet().isSome();
            if (resumptionTokenExists && otherParamExists || !resumptionTokenExists && !otherParamExists) {
                return OaiPmhRepository.this.createBadArgumentResponse(p);
            }
            Option from = p.getFrom().map(Functions.asDate).map(OaiPmhRepository.this.granulate);
            Function<Date, Date> untilAdjustment = OaiPmhRepository.this.getRepositoryTimeGranularity() == Granularity.DAY ? Functions.addDay(1) : org.opencastproject.util.data.functions.Functions.identity();
            Option untilGranularity = p.getUntil().map(Functions.asDate).map(OaiPmhRepository.this.granulate).map(untilAdjustment);
            for (Tuple fromUntil : from.and(untilGranularity)) {
                if (((Date)fromUntil.getA()).before((Date)fromUntil.getB())) continue;
                return OaiPmhRepository.this.createBadArgumentResponse(p);
            }
            if (otherParamExists && p.getMetadataPrefix().isNone()) {
                return OaiPmhRepository.this.createBadArgumentResponse(p);
            }
            Option until = untilGranularity.orElse(Option.some((Object)OaiPmhRepository.this.currentDate()));
            String metadataPrefix = (String)p.getResumptionToken().flatMap(this.getMetadataPrefixFromToken).getOrElse(this.getMetadataPrefix(p));
            Iterator iterator = p.getResumptionToken().flatMap(this.getMetadataProviderFromToken).orElse(OaiPmhRepository.this.getMetadataProvider.curry((Object)metadataPrefix)).iterator();
            if (iterator.hasNext()) {
                MetadataProvider metadataProvider = (MetadataProvider)iterator.next();
                try {
                    SearchResult result;
                    final Option[] set = new Option[]{p.getSet()};
                    if (!resumptionTokenExists) {
                        if (p.getSet().isSome() && !OaiPmhRepository.this.sets.stream().anyMatch(setDef -> StringUtils.equals((CharSequence)setDef.getSetSpec(), (CharSequence)((CharSequence)p.getSet().get())))) {
                            return OaiPmhRepository.this.createNoRecordsMatchResponse(p);
                        }
                        result = OaiPmhRepository.this.getPersistence().search(QueryBuilder.queryRepo((String)OaiPmhRepository.this.getRepositoryId()).setDefinitions(OaiPmhRepository.this.sets).setSpec((String)p.getSet().getOrElseNull()).modifiedAfter(from).modifiedBefore(until).limit(Integer.valueOf(OaiPmhRepository.this.getResultLimit())).build());
                    } else {
                        result = (SearchResult)OaiPmhRepository.this.getSavedQuery((String)p.getResumptionToken().get()).fold((Option.Match)new Option.Match<ResumableQuery, SearchResult>(){

                            public SearchResult some(ResumableQuery rq) {
                                set[0] = rq.getSet();
                                return OaiPmhRepository.this.getPersistence().search(QueryBuilder.queryRepo((String)OaiPmhRepository.this.getRepositoryId()).setDefinitions(OaiPmhRepository.this.sets).setSpec((String)rq.getSet().getOrElseNull()).modifiedAfter(rq.getLastResult()).modifiedBefore(rq.getUntil()).limit(Integer.valueOf(OaiPmhRepository.this.getResultLimit())).subsequentRequest(true).build());
                            }

                            public SearchResult none() {
                                throw new BadResumptionTokenException();
                            }
                        });
                    }
                    if (result.size() > 0L) {
                        return this.respond(new ListGenParams(OaiPmhRepository.this, result, metadataProvider, metadataPrefix, p.getResumptionToken(), (Option<Date>)from, (Date)until.get(), (Option<String>)set[0], p));
                    }
                    return OaiPmhRepository.this.createNoRecordsMatchResponse(p);
                }
                catch (BadResumptionTokenException e) {
                    return OaiPmhRepository.this.createBadResumptionTokenResponse(p);
                }
            }
            return OaiPmhRepository.this.createCannotDisseminateFormatResponse(p);
        }

        private Function0<String> getMetadataPrefix(final Params p) {
            return new Function0<String>(){

                public String apply() {
                    return (String)p.getMetadataPrefix().getOrElse((Object)OaiPmhConstants.OAI_DC_METADATA_FORMAT.getPrefix());
                }
            };
        }

        private class BadResumptionTokenException
        extends RuntimeException {
            private BadResumptionTokenException() {
            }
        }

        abstract class ListXmlGen
        extends OaiVerbXmlGen {
            protected final ListGenParams params;

            ListXmlGen(ListGenParams p) {
                super(p.getRepository(), p.getParams());
                this.params = p;
            }

            protected abstract List<Node> createContent(Option<String> var1);

            @Override
            public Element create() {
                ArrayList<Node> content = new ArrayList<Node>(this.createContent(this.params.getSet()));
                if (content.size() == 0) {
                    return OaiPmhRepository.this.createNoRecordsMatchResponse(this.params.getParams()).create();
                }
                content.add(this.resumptionToken(this.params.getResumptionToken(), this.params.getMetadataPrefix(), this.params.getResult(), this.params.getUntil(), this.params.getSet()));
                return this.oai(this.request(this.$a("metadataPrefix", this.params.getMetadataPrefix()), this.$aSome("from", (Option<String>)this.params.getFrom().map(OaiPmhRepository.this.toSupportedGranularity)), this.$aSome("until", (Option<String>)Option.some((Object)OaiPmhRepository.this.toSupportedGranularity(this.params.getUntil()))), this.$aSome("set", this.params.getSet())), this.verb(content));
            }
        }
    }

    static class BadArgumentException
    extends RuntimeException {
        BadArgumentException() {
        }
    }
}

