/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.oaipmh.server;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.opencastproject.oaipmh.OaiPmhUtil;
import org.opencastproject.oaipmh.server.OaiPmhRepository;
import org.opencastproject.util.data.Function;

public final class Functions {
    public static final Function<String, Date> asDate = new Function<String, Date>(){

        public Date apply(String s) {
            try {
                return OaiPmhUtil.fromUtc(s);
            }
            catch (ParseException e) {
                throw new OaiPmhRepository.BadArgumentException();
            }
        }
    };

    public static Function<Date, Date> addDay(final int days) {
        return new Function<Date, Date>(){

            public Date apply(Date date) {
                Calendar c = Calendar.getInstance();
                c.setTimeZone(TimeZone.getTimeZone("UTC"));
                c.setTime(date);
                c.add(5, days);
                return c.getTime();
            }
        };
    }

    private Functions() {
    }
}

