/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.oaipmh.server;

import java.util.List;
import java.util.Objects;
import org.opencastproject.oaipmh.Granularity;
import org.opencastproject.oaipmh.matterhorn.MatterhornInlinedMetadataProvider;
import org.opencastproject.oaipmh.matterhorn.MatterhornMetadataProvider;
import org.opencastproject.oaipmh.persistence.OaiPmhDatabase;
import org.opencastproject.oaipmh.server.MetadataProvider;
import org.opencastproject.oaipmh.server.OaiPmhRepository;
import org.opencastproject.oaipmh.server.ResumableQuery;
import org.opencastproject.oaipmh.util.ResumptionTokenStore;
import org.opencastproject.util.data.Collections;
import org.opencastproject.util.data.Option;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={OaiPmhRepository.class, ManagedService.class}, property={"service.description=Opencast default OAI-PMH repository", "service.pid=org.opencastproject.oaipmh.server.DefaultRepository"})
public class DefaultRepository
extends OaiPmhRepository {
    private OaiPmhDatabase persistence;
    private String adminEmail;
    private final ResumptionTokenStore tokenStore = ResumptionTokenStore.create();
    private final List<MetadataProvider> metadataProviders = Collections.list((Object[])new MetadataProvider[]{new MatterhornMetadataProvider(), new MatterhornInlinedMetadataProvider()});

    @Reference
    public void setPersistence(OaiPmhDatabase persistence) {
        this.persistence = persistence;
    }

    @Activate
    public void activate(ComponentContext cc) {
        this.adminEmail = Objects.toString(cc.getBundleContext().getProperty("org.opencastproject.admin.email"), "");
    }

    @Override
    public Granularity getRepositoryTimeGranularity() {
        return Granularity.SECOND;
    }

    @Override
    public String getRepositoryName() {
        return "Matterhorn OAI-PMH repository";
    }

    @Override
    public String getRepositoryId() {
        return "default";
    }

    @Override
    public OaiPmhDatabase getPersistence() {
        return this.persistence;
    }

    @Override
    public String getAdminEmail() {
        return this.adminEmail;
    }

    @Override
    public String saveQuery(ResumableQuery query) {
        return this.tokenStore.put(query);
    }

    @Override
    public Option<ResumableQuery> getSavedQuery(String resumptionToken) {
        return this.tokenStore.get(resumptionToken);
    }

    @Override
    public int getResultLimit() {
        return 50;
    }

    @Override
    public List<MetadataProvider> getRepositoryMetadataProviders() {
        return this.metadataProviders;
    }
}

