/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.oaipmh.matterhorn;

import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.opencastproject.oaipmh.persistence.SearchResultElementItem;
import org.opencastproject.oaipmh.persistence.SearchResultItem;
import org.opencastproject.oaipmh.server.MetadataFormat;
import org.opencastproject.oaipmh.server.MetadataProvider;
import org.opencastproject.oaipmh.server.OaiPmhRepository;
import org.opencastproject.oaipmh.util.XmlGen;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.XmlUtil;
import org.opencastproject.util.data.Collections;
import org.opencastproject.util.data.Option;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MatterhornInlinedMetadataProvider
implements MetadataProvider {
    private static final URL SCHEMA_URL = UrlSupport.url((String)"http://www.opencastproject.org/oai/matterhorn-inlined.xsd");
    private static final URI NAMESPACE_URI = UrlSupport.uri((String)"http://www.opencastproject.org/oai/matterhorn-inlined");
    private static final MetadataFormat METADATA_FORMAT = new MetadataFormat(){

        @Override
        public String getPrefix() {
            return "matterhorn-inlined";
        }

        @Override
        public URL getSchema() {
            return SCHEMA_URL;
        }

        @Override
        public URI getNamespace() {
            return NAMESPACE_URI;
        }
    };
    private static final Option<String> NS_URI = Option.some((Object)NAMESPACE_URI.toString());

    @Override
    public MetadataFormat getMetadataFormat() {
        return METADATA_FORMAT;
    }

    @Override
    public Element createMetadata(OaiPmhRepository repository, final SearchResultItem item, Option<String> set) {
        XmlGen xml = new XmlGen(Option.none()){

            @Override
            public Element create() {
                List inlinedNodes = Collections.list((Object[])new Node[]{this.parse((Option<String>)Option.option((Object)item.getMediaPackageXml()))});
                for (SearchResultElementItem elementItem : item.getElements()) {
                    inlinedNodes.add(this.$e(elementItem.getType(), NS_URI, this.$a("type", elementItem.getFlavor()), this.parse((Option<String>)Option.option((Object)elementItem.getXml()))));
                }
                return this.$e("inlined", NS_URI, (List<Node>)inlinedNodes);
            }

            private Node parse(Option<String> xml) {
                for (String a : xml) {
                    Iterator iterator = XmlUtil.parseNs((String)a).right().iterator();
                    if (!iterator.hasNext()) continue;
                    Document d = (Document)iterator.next();
                    return d.getDocumentElement();
                }
                return this.nodeZero();
            }
        };
        return xml.create();
    }
}

