/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.oaipmh;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.opencastproject.oaipmh.Granularity;

public final class OaiPmhUtil {
    private static final String GRANULARITY_DAY = "YYYY-MM-DD";
    private static final String GRANULARITY_SECOND = "YYYY-MM-DDThh:mm:ssZ";

    private OaiPmhUtil() {
    }

    public static String toUtc(Date d, Granularity g) {
        if (d != null) {
            switch (g) {
                case SECOND: {
                    return OaiPmhUtil.toUtcSecond(d);
                }
                case DAY: {
                    return OaiPmhUtil.toUtcDay(d);
                }
            }
            throw new RuntimeException("bug");
        }
        return null;
    }

    public static String toUtcSecond(Date d) {
        return OaiPmhUtil.newDateTimeFormat().format(d);
    }

    public static String toUtcDay(Date d) {
        return OaiPmhUtil.newDateFormat().format(d);
    }

    public static Date fromUtc(String d) throws ParseException {
        try {
            return OaiPmhUtil.newDateTimeFormat().parse(d);
        }
        catch (ParseException e) {
            return OaiPmhUtil.newDateFormat().parse(d);
        }
    }

    public static DateFormat newDateTimeFormat() {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        f.setTimeZone(TimeZone.getTimeZone("UTC"));
        return f;
    }

    public static DateFormat newDateFormat() {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        f.setTimeZone(TimeZone.getTimeZone("UTC"));
        return f;
    }

    public static Granularity fromOaiRepresentation(String oai) {
        if (GRANULARITY_DAY.equals(oai)) {
            return Granularity.DAY;
        }
        if (GRANULARITY_SECOND.equals(oai)) {
            return Granularity.SECOND;
        }
        throw new IllegalArgumentException(oai + " is not a valid representation");
    }

    public static String toOaiRepresentation(Granularity g) {
        switch (g) {
            case DAY: {
                return GRANULARITY_DAY;
            }
            case SECOND: {
                return GRANULARITY_SECOND;
            }
        }
        throw new RuntimeException("bug");
    }
}

