/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.mpeg7;

import org.apache.commons.lang3.StringUtils;
import org.opencastproject.metadata.mpeg7.Textual;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TextualImpl
implements Textual {
    public static final String DEFAULT_PHONETIC_ALPHABET = "sampa";
    protected String text = null;
    protected String language = null;
    protected String transcription = null;
    protected String alphabet = "sampa";

    public TextualImpl() {
    }

    public TextualImpl(String text) {
        this(text, null);
    }

    public TextualImpl(String[] words) {
        this(words, null);
    }

    public TextualImpl(String text, String language) {
        if (StringUtils.trimToNull((String)text) == null) {
            throw new IllegalArgumentException("The text cannot be empty");
        }
        this.text = text;
        this.language = language;
    }

    public TextualImpl(String[] words, String language) {
        this(StringUtils.join((Object[])words, (char)' '), null);
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getPhoneticAlphabet() {
        return this.alphabet;
    }

    @Override
    public String getPhoneticTranscription() {
        return this.transcription;
    }

    @Override
    public void setText(String text) {
        if (StringUtils.trimToNull((String)text) == null) {
            throw new IllegalArgumentException("The text cannot be empty");
        }
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public void setPhoneticTranscription(String transcription, String alphabet) {
        if (transcription != null && alphabet == null) {
            alphabet = DEFAULT_PHONETIC_ALPHABET;
        }
        this.transcription = transcription;
        this.alphabet = alphabet;
    }

    public Node toXml(Document document) {
        Element node = document.createElement("Text");
        if (this.language != null) {
            node.setAttribute("xml:lang", this.language);
        }
        if (this.transcription != null) {
            node.setAttribute("phoneticTranscription", this.transcription);
            node.setAttribute("phoneticAlphabet", this.alphabet);
        }
        node.appendChild(document.createTextNode(this.text));
        return node;
    }
}

