/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.mpeg7;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opencastproject.metadata.mpeg7.Segment;
import org.opencastproject.metadata.mpeg7.SegmentImpl;
import org.opencastproject.metadata.mpeg7.TemporalDecomposition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TemporalDecompositionImpl<T extends Segment>
implements TemporalDecomposition<T> {
    protected boolean gap = false;
    protected boolean overlap = false;
    protected TemporalDecomposition.DecompositionCriteria criteria = TemporalDecomposition.DecompositionCriteria.Temporal;
    protected List<T> segments = new ArrayList<T>();
    protected boolean hasGap = false;
    protected boolean isOverlapping = false;
    private Segment.Type segmentType = null;

    public TemporalDecompositionImpl(Segment.Type segmentType) {
        this.segmentType = segmentType;
    }

    @Override
    public void setGap(boolean hasGap) {
        this.hasGap = hasGap;
    }

    @Override
    public boolean hasGap() {
        return this.gap;
    }

    @Override
    public T createSegment(String id) {
        SegmentImpl segment = new SegmentImpl(this.segmentType, id);
        if (this.segments.contains(segment)) {
            throw new IllegalArgumentException("Duplicate segment id detected: " + id);
        }
        this.segments.add(segment);
        return (T)segment;
    }

    @Override
    public boolean hasSegments() {
        return this.segments.size() > 0;
    }

    @Override
    public void setOverlapping(boolean isOverlapping) {
        this.isOverlapping = isOverlapping;
    }

    @Override
    public void setCriteria(TemporalDecomposition.DecompositionCriteria criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("Decomposition criteria must not be null");
        }
        this.criteria = criteria;
    }

    @Override
    public boolean isOverlapping() {
        return this.overlap;
    }

    @Override
    public TemporalDecomposition.DecompositionCriteria getCriteria() {
        return TemporalDecomposition.DecompositionCriteria.Temporal;
    }

    @Override
    public T getSegmentById(String segmentId) {
        for (Segment segment : this.segments) {
            if (!segmentId.equals(segment.getIdentifier())) continue;
            return (T)segment;
        }
        return null;
    }

    @Override
    public Iterator<T> segments() {
        return this.segments.iterator();
    }

    public Node toXml(Document document) {
        Element node = document.createElement("TemporalDecomposition");
        node.setAttribute("gap", this.gap ? "true" : "false");
        node.setAttribute("overlap", this.overlap ? "true" : "false");
        node.setAttribute("criteria", this.criteria.toString().toLowerCase());
        for (Segment segment : this.segments) {
            node.appendChild(segment.toXml(document));
        }
        return node;
    }
}

