/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.mpeg7;

import org.opencastproject.metadata.mpeg7.Audio;
import org.opencastproject.metadata.mpeg7.AudioVisual;
import org.opencastproject.metadata.mpeg7.MediaLocator;
import org.opencastproject.metadata.mpeg7.MediaTime;
import org.opencastproject.metadata.mpeg7.MultimediaContentType;
import org.opencastproject.metadata.mpeg7.Segment;
import org.opencastproject.metadata.mpeg7.TemporalDecomposition;
import org.opencastproject.metadata.mpeg7.TemporalDecompositionImpl;
import org.opencastproject.metadata.mpeg7.Video;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MultimediaContentTypeImpl<S extends Segment>
implements MultimediaContentType,
Audio,
Video,
AudioVisual {
    protected MultimediaContentType.Type type = null;
    protected String id = null;
    protected MediaLocator mediaLocator = null;
    protected MediaTime mediaTime = null;
    protected TemporalDecomposition<S> temporalDecomposition = null;

    public MultimediaContentTypeImpl(MultimediaContentType.Type type, String id) {
        this.type = type;
        this.id = id;
        this.temporalDecomposition = this.createTemporalDecomposition(type);
    }

    @Override
    public void setMediaTime(MediaTime time) {
        this.mediaTime = time;
    }

    @Override
    public void setMediaLocator(MediaLocator locator) {
        this.mediaLocator = locator;
    }

    private TemporalDecomposition<S> createTemporalDecomposition(MultimediaContentType.Type contentType) {
        if (this.type.equals((Object)MultimediaContentType.Type.AudioVisual)) {
            return new TemporalDecompositionImpl(Segment.Type.AudioVisualSegment);
        }
        if (this.type.equals((Object)MultimediaContentType.Type.Audio)) {
            return new TemporalDecompositionImpl(Segment.Type.AudioSegment);
        }
        if (this.type.equals((Object)MultimediaContentType.Type.Video)) {
            return new TemporalDecompositionImpl(Segment.Type.VideoSegment);
        }
        throw new IllegalStateException("Unknown multimedia content type detected: " + contentType.toString());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public MediaLocator getMediaLocator() {
        return this.mediaLocator;
    }

    @Override
    public MediaTime getMediaTime() {
        return this.mediaTime;
    }

    public TemporalDecomposition<S> getTemporalDecomposition() {
        return this.temporalDecomposition;
    }

    public Node toXml(Document document) {
        Element node = document.createElement(this.type.toString());
        node.setAttribute("id", this.id);
        if (this.mediaLocator != null) {
            node.appendChild(this.mediaLocator.toXml(document));
        }
        if (this.mediaTime != null) {
            node.appendChild(this.mediaTime.toXml(document));
        }
        if (this.temporalDecomposition.hasSegments()) {
            node.appendChild(this.temporalDecomposition.toXml(document));
        }
        return node;
    }
}

