/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.mpeg7;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.opencastproject.metadata.mpeg7.FreeTextAnnotationImpl;
import org.opencastproject.metadata.mpeg7.KeywordAnnotationImpl;
import org.opencastproject.metadata.mpeg7.MediaDuration;
import org.opencastproject.metadata.mpeg7.MediaDurationImpl;
import org.opencastproject.metadata.mpeg7.MediaLocator;
import org.opencastproject.metadata.mpeg7.MediaLocatorImpl;
import org.opencastproject.metadata.mpeg7.MediaRelTimePointImpl;
import org.opencastproject.metadata.mpeg7.MediaTime;
import org.opencastproject.metadata.mpeg7.MediaTimeImpl;
import org.opencastproject.metadata.mpeg7.MediaTimePoint;
import org.opencastproject.metadata.mpeg7.MediaTimePointImpl;
import org.opencastproject.metadata.mpeg7.Mpeg7CatalogImpl;
import org.opencastproject.metadata.mpeg7.MultimediaContentType;
import org.opencastproject.metadata.mpeg7.Segment;
import org.opencastproject.metadata.mpeg7.SpatioTemporalDecomposition;
import org.opencastproject.metadata.mpeg7.SpatioTemporalLocatorImpl;
import org.opencastproject.metadata.mpeg7.TemporalDecomposition;
import org.opencastproject.metadata.mpeg7.TextAnnotation;
import org.opencastproject.metadata.mpeg7.Textual;
import org.opencastproject.metadata.mpeg7.TextualImpl;
import org.opencastproject.metadata.mpeg7.VideoSegment;
import org.opencastproject.metadata.mpeg7.VideoText;
import org.opencastproject.metadata.mpeg7.VideoTextImpl;
import org.opencastproject.util.XmlSafeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Mpeg7Parser
extends DefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)Mpeg7Parser.class.getName());
    private static DecimalFormatSymbols standardSymbols = new DecimalFormatSymbols(Locale.US);
    private Mpeg7CatalogImpl mpeg7Doc = null;
    private StringBuffer tagContent = new StringBuffer();
    private MultimediaContentType multimediaContent = null;
    private MultimediaContentType.Type contentType = null;
    private String contentId = null;
    private MediaLocator mediaLocator = null;
    private MediaTimePoint contentTimePoint = null;
    private MediaTimePoint mediaTimePoint = null;
    private MediaDuration mediaDuration = null;
    private MediaTime mediaTime = null;
    private TemporalDecomposition<?> temporalDecomposition = null;
    private Segment segment = null;
    private SpatioTemporalDecomposition spatioTemporalDecomposition = null;
    private TextAnnotation textAnnotation = null;
    private VideoText videoText = null;
    private Textual textual = null;
    private ParserState state = ParserState.Document;
    private boolean isMpeg7 = false;
    private DecimalFormat floatFormat = new DecimalFormat();

    public Mpeg7Parser() {
        this.floatFormat.setDecimalFormatSymbols(standardSymbols);
    }

    public Mpeg7Parser(Mpeg7CatalogImpl catalog) {
        this.mpeg7Doc = catalog;
        this.floatFormat.setDecimalFormatSymbols(standardSymbols);
    }

    public Mpeg7CatalogImpl parse(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        if (this.mpeg7Doc == null) {
            this.mpeg7Doc = new Mpeg7CatalogImpl();
        }
        SAXParserFactory factory = XmlSafeParser.newSAXParserFactory();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        parser.parse(is, (DefaultHandler)this);
        if (!this.isMpeg7) {
            throw new IllegalArgumentException("Content of input stream is not mpeg-7");
        }
        return this.mpeg7Doc;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        String language;
        String isOverlapping;
        String hasGap;
        super.startElement(uri, localName, name, attributes);
        this.tagContent = new StringBuffer();
        if (!this.isMpeg7 && "Mpeg7".equals(name)) {
            this.isMpeg7 = true;
        }
        if ("MultimediaContent".equals(localName)) {
            this.state = ParserState.MultimediaContent;
        }
        if ("Audio".equals(localName) || "Video".equals(localName) || "AudioVisual".equals(localName)) {
            this.contentType = MultimediaContentType.Type.valueOf(localName);
            this.contentId = attributes.getValue("id");
            if (MultimediaContentType.Type.Audio.equals((Object)this.contentType)) {
                this.multimediaContent = this.mpeg7Doc.addAudioContent(this.contentId, this.mediaTime, this.mediaLocator);
            } else if (MultimediaContentType.Type.Video.equals((Object)this.contentType)) {
                this.multimediaContent = this.mpeg7Doc.addVideoContent(this.contentId, this.mediaTime, this.mediaLocator);
            } else if (MultimediaContentType.Type.AudioVisual.equals((Object)this.contentType)) {
                this.multimediaContent = this.mpeg7Doc.addAudioVisualContent(this.contentId, this.mediaTime, this.mediaLocator);
            }
        }
        if ("TemporalDecomposition".equals(localName)) {
            hasGap = attributes.getValue("gap");
            isOverlapping = attributes.getValue("overlap");
            String criteria = attributes.getValue("criteria");
            if (!"temporal".equals(criteria)) {
                throw new IllegalStateException("Decompositions other than temporal are not supported");
            }
            this.temporalDecomposition = this.multimediaContent.getTemporalDecomposition();
            this.temporalDecomposition.setGap("true".equals(hasGap));
            this.temporalDecomposition.setOverlapping("overlap".equals(isOverlapping));
        }
        if ("AudioSegment".equals(localName) || "VideoSegment".equals(localName) || "AudioVisualSegment".equals(localName)) {
            String segmentId = attributes.getValue("id");
            this.segment = this.temporalDecomposition.createSegment(segmentId);
            this.state = ParserState.Segment;
        }
        if ("TextAnnotation".equals(localName)) {
            language = attributes.getValue("xml:lang");
            float confidence = -1.0f;
            float relevance = -1.0f;
            try {
                confidence = this.floatFormat.parse(attributes.getValue("confidence")).floatValue();
            }
            catch (Exception e) {
                confidence = -1.0f;
            }
            try {
                relevance = this.floatFormat.parse(attributes.getValue("relevance")).floatValue();
            }
            catch (Exception e) {
                relevance = -1.0f;
            }
            this.textAnnotation = this.segment.createTextAnnotation(confidence, relevance, language);
        }
        if ("SpatioTemporalDecomposition".equals(localName)) {
            hasGap = attributes.getValue("gap");
            isOverlapping = attributes.getValue("overlap");
            if (!(this.segment instanceof VideoSegment)) {
                throw new IllegalStateException("Can't have a spatio temporal decomposition outside of a video segment");
            }
            boolean gap = "true".equalsIgnoreCase(attributes.getValue("gap"));
            boolean overlap = "true".equalsIgnoreCase(attributes.getValue("overlap"));
            this.spatioTemporalDecomposition = ((VideoSegment)this.segment).createSpatioTemporalDecomposition(gap, overlap);
            this.spatioTemporalDecomposition.setGap("true".equals(hasGap));
            this.spatioTemporalDecomposition.setOverlapping("overlap".equals(isOverlapping));
        }
        if ("VideoText".equals(localName)) {
            String id = attributes.getValue("id");
            this.videoText = new VideoTextImpl(id);
            this.state = ParserState.VideoText;
        }
        if ("Text".equals(localName)) {
            language = attributes.getValue("xml:lang");
            this.textual = new TextualImpl();
            this.textual.setLanguage(language);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if ("MultimediaContent".equals(localName)) {
            this.state = ParserState.Document;
        } else if ("AudioSegment".equals(localName) || "VideoSegment".equals(localName) || "AudioVisualSegment".equals(localName)) {
            this.state = ParserState.MultimediaContent;
        }
        if ("MediaUri".equals(localName)) {
            MediaLocatorImpl locator = new MediaLocatorImpl();
            URI mediaUri = URI.create(this.getTagContent());
            locator.setMediaURI(mediaUri);
            if (ParserState.MultimediaContent.equals((Object)this.state)) {
                this.multimediaContent.setMediaLocator(locator);
            }
        }
        if ("MediaTime".equals(localName)) {
            if (ParserState.MultimediaContent.equals((Object)this.state)) {
                this.mediaTime = new MediaTimeImpl(this.mediaTimePoint, this.mediaDuration);
                this.multimediaContent.setMediaTime(this.mediaTime);
            } else if (ParserState.Segment.equals((Object)this.state)) {
                this.mediaTime = new MediaTimeImpl(this.mediaTimePoint, this.mediaDuration);
                this.segment.setMediaTime(this.mediaTime);
            } else if (ParserState.VideoText.equals((Object)this.state)) {
                SpatioTemporalLocatorImpl spatioTemporalLocator = new SpatioTemporalLocatorImpl(this.mediaTime);
                this.videoText.setSpatioTemporalLocator(spatioTemporalLocator);
            }
        }
        if ("MediaTimePoint".equals(localName)) {
            this.mediaTimePoint = MediaTimePointImpl.parseTimePoint(this.getTagContent());
            if (ParserState.MultimediaContent.equals((Object)this.state)) {
                this.contentTimePoint = this.mediaTimePoint;
            }
        }
        if ("MediaRelTimePoint".equals(localName)) {
            MediaRelTimePointImpl tp = MediaRelTimePointImpl.parseTimePoint(this.getTagContent());
            this.mediaTimePoint = tp;
            if (ParserState.MultimediaContent.equals((Object)this.state)) {
                this.contentTimePoint = tp;
            } else if (ParserState.Segment.equals((Object)this.state)) {
                tp.setReferenceTimePoint(this.contentTimePoint);
            }
        }
        if ("MediaDuration".equals(localName)) {
            this.mediaDuration = MediaDurationImpl.parseDuration(this.getTagContent());
        }
        if ("Keyword".equals(localName)) {
            KeywordAnnotationImpl keyword = new KeywordAnnotationImpl(this.tagContent.toString());
            this.textAnnotation.addKeywordAnnotation(keyword);
        }
        if ("FreeTextAnnotation".equals(localName)) {
            FreeTextAnnotationImpl freeText = new FreeTextAnnotationImpl(this.tagContent.toString());
            this.textAnnotation.addFreeTextAnnotation(freeText);
        }
        if ("VideoText".equals(localName)) {
            this.spatioTemporalDecomposition.addVideoText(this.videoText);
        }
        if ("SpatioTemporalLocator".equals(localName)) {
            this.videoText.setSpatioTemporalLocator(new SpatioTemporalLocatorImpl(this.mediaTime));
        }
        if ("Text".equals(localName)) {
            this.textual.setText(this.tagContent.toString());
            this.videoText.setText(this.textual);
        }
        if ("Box".equals(localName)) {
            String[] coords = this.tagContent.toString().trim().split(" ");
            if (coords.length != 4) {
                throw new IllegalStateException("Box coordinates '" + this.tagContent + "' is malformatted");
            }
            int[] coordsL = new int[4];
            for (int i = 0; i < 4; ++i) {
                try {
                    coordsL[i] = (int)this.floatFormat.parse(coords[i]).floatValue();
                    continue;
                }
                catch (ParseException e) {
                    throw new SAXException(e);
                }
            }
            this.videoText.setBoundary(new Rectangle(coordsL[0], coordsL[1], coordsL[2] - coordsL[0], coordsL[3] - coordsL[1]));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        this.tagContent.append(ch, start, length);
    }

    private String getTagContent() {
        String str = this.tagContent.toString().trim();
        return str;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        logger.warn("Error while parsing mpeg-7 catalog: " + e.getMessage());
        super.error(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        logger.warn("Fatal error while parsing mpeg-7 catalog: " + e.getMessage());
        super.fatalError(e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        logger.warn("Warning while parsing mpeg-7 catalog: " + e.getMessage());
        super.warning(e);
    }

    static enum ParserState {
        Document,
        MultimediaContent,
        Segment,
        VideoText;

    }
}

